import subprocess
import multiprocessing
import time
import os

def start_worker(queue_name):
    """Start a Celery worker for a specific queue."""
    subprocess.run([
        "celery", "-A", "scraper_worker.celery_app", "worker",
        "-Q", queue_name,
        "--concurrency=2",
        "--prefetch-multiplier=1",
        "--loglevel=info"
    ])

def enqueue_tasks():
    """Run the enqueueing logic after workers are ready."""
    time.sleep(10)
    subprocess.run(["python", "enqueue_tasks.py"])

def main():
    processes = []

    # Start Celery workers for Campus and Trends
    campus_worker = multiprocessing.Process(target=start_worker, args=("campus_queue",))
    trends_worker = multiprocessing.Process(target=start_worker, args=("trends_queue",))
    processes.extend([campus_worker, trends_worker])

    enqueue_proc = multiprocessing.Process(target=enqueue_tasks)
    processes.append(enqueue_proc)

    # Start all
    for p in processes:
        p.start()

    for p in processes:
        p.join()

if __name__ == "__main__":
    main()
