import requests
import json
from pprint import pprint
from extractor import extract_place_data

# ==============================
# STEP 1: Setup Credentials and Request Payload
# ==============================

USERNAME = "envigo_A3H"  # Your  proxy username
PASSWORD = "Envigo+123bot"  # Your proxy password

# Target Google Maps CID URL (specific business)
payload = {
    'source': 'google',
    'url': 'https://maps.google.com/maps?cid=9295441962122134247'
}

# ==============================
# STEP 2: Send POST Request to Oxylabs
# ==============================

response = requests.post(
    'https://realtime.oxylabs.io/v1/queries',
    auth=(USERNAME, PASSWORD),
    json=payload,
)

# Parse response to JSON
response_json = response.json()

# Optional: Pretty print the full JSON response to console
pprint(response_json)

# ==============================
# STEP 3: Save Response to File
# ==============================

with open("oxylabs_google_maps_response.json", "w", encoding="utf-8") as f:
    json.dump(response_json, f, indent=4, ensure_ascii=False)

print("Response saved to 'oxylabs_google_maps_response.json'")

# ==============================
# STEP 4: Load Response and Extract HTML Content
# ==============================

with open("oxylabs_google_maps_response.json", "r", encoding="utf-8") as f:
    oxylabs_data = json.load(f)

# Initialize variables
html_content = None
google_map_url = None

# Extract HTML content and original URL
results = oxylabs_data.get("results", [])
if results:
    html_content = results[0].get("content")  # raw HTML
    google_map_url = results[0].get("url")    # original Google Maps URL

# ==============================
# STEP 5: Run Extraction Logic
# ==============================

if html_content:
    print("HTML content loaded, starting extraction...")

    place_data = extract_place_data(html_content, google_map_url=google_map_url)

    if place_data:
        print("Extracted Place Data:")
        print(json.dumps(place_data, indent=2, ensure_ascii=False))
    else:
        print("Failed to extract structured place data.")
else:
    print("No HTML content found in Oxylabs response.")
