################################################################
# Single store
################################################################
# import pandas as pd
# import time
# from scraper_worker import scrape_task

# BRANDS = {
#     "campus": "campus.csv"
# }

# for brand, csv_file in BRANDS.items():
#     print(f"Enqueueing tasks for {brand.upper()}...")
#     df = pd.read_csv(csv_file)

#     for idx, row in df.iterrows():
#         params = {k: v for k, v in row.items() if pd.notnull(v)}
#         if "headless" in params:
#             params["headless"] = str(params["headless"]).lower()

#         scrape_task.apply_async(
#             args=[params, idx, brand],
#             queue=f"{brand}_queue"
#         )

#         time.sleep(0.5)

################################################################
# Multiple stores
################################################################

import pandas as pd
import time
from scraper_worker import scrape_task

BRANDS = {
    "campus": "campus.csv",
    "trends": "Trends.csv"
}

for brand, csv_file in BRANDS.items():
    print(f" Enqueueing tasks for {brand.upper()}...")
    df = pd.read_csv(csv_file)

    for idx, row in df.iterrows():
        params = {k: v for k, v in row.items() if pd.notnull(v)}
        if "headless" in params:
            params["headless"] = str(params["headless"]).lower()

        scrape_task.apply_async(
            args=[params, idx, brand],
            queue=f"{brand}_queue"
        )

        time.sleep(0.5)  # throttle to avoid overload
