import subprocess
import multiprocessing
import time
import os

def start_worker(queue_name):
    """Start a Celery worker for a specific queue."""
    subprocess.run([
        "celery", "-A", "scraper_worker.celery_app", "worker",
        "-Q", queue_name,
        "--concurrency=2",
        "--prefetch-multiplier=1",
        "--loglevel=info"
    ])

def enqueue_tasks():
    """Run the enqueueing logic after workers are ready."""
    # Wait for FastAPI and workers to be ready
    time.sleep(10)
    subprocess.run(["python", "enqueue_tasks.py"])

def main():
    processes = []

    # Start Celery workers for Campus and Trends
    campus_worker = multiprocessing.Process(target=start_worker, args=("campus_queue",))
    trends_worker = multiprocessing.Process(target=start_worker, args=("trends_queue",))
    processes.extend([campus_worker, trends_worker])

    # Start enqueue script after delay
    enqueue_proc = multiprocessing.Process(target=enqueue_tasks)
    processes.append(enqueue_proc)

    # Start all
    for p in processes:
        p.start()

    # Optional: Wait for all to finish (or daemonize)
    for p in processes:
        p.join()

if __name__ == "__main__":
    main()
