<?php

namespace Drupal\postcode_city\Controller;
use Drupal\Core\Database\Database;
use Symfony\Component\HttpFoundation\JsonResponse;

/**
 * Provides city information based on postcode.
 */
class PostcodeCityController {

  /**
   * Fetches city based on postcode.
   *
   * @param string $pincode
   *   The postcode provided in the request.
   *
   * @return \Symfony\Component\HttpFoundation\JsonResponse
   *   JSON response with the city name or an error message.
   */
  public function fetchCity($pincode) {
    // Mock data: Replace this with your API or database logic.
    $connection = Database::getConnection();

    $query = $connection->select('pincodes', 'pincode')
    ->fields('pincode', ['id', 'Pincode', 'City']) // Specify the fields to retrieve.
    ->condition('Pincode', $pincode, '=');

    // Fetch the record.
    $result = $query->execute()->fetchAssoc();
   // print_r($result['City']);exit;
    // Return the result or NULL if no record found.
    if (isset($result['City'])) {
      return new JsonResponse(['city' => $result['City']]);
    }
    else {
      return new JsonResponse(['error' => 'Invalid postcode'], 404);
    }
  }

}
