<?php
namespace Drupal\postcode_city\Form;

use Drupal\Core\Form\FormStateInterface;
use Drupal\webform\WebformSubmissionInterface;

class WebformPostcodeCity {

    /**
     * Ajax callback to update city options based on pincode.
     */
    public static function updateCityOptions(array &$form, FormStateInterface $form_state) {
        $pincode = $form_state->getValue('postcode');
        $options = self::getCityOptionsByPincode($pincode);

        $form['elements']['city']['#options'] = $options;

        return $form['elements']['city'];
    }

    /**
     * Get city options by pincode.
     */
    private static function getCityOptionsByPincode($pincode) {
        // Replace this with your custom logic or database query.
        $cities_by_pincode = [
            '110001' => ['Delhi' => 'Delhi'],
            '400001' => ['Mumbai' => 'Mumbai'],
            '600001' => ['Chennai' => 'Chennai'],
        ];
        //print_r($cities_by_pincode);
        return $cities_by_pincode[$pincode] ?? ['' => '- Select -'];
    }
}


?>