/**
 * @file
 * bef_datepickers.js
 *
 * Provides jQueryUI Datepicker integration with Better Exposed Filters.
 */

(function ($, Drupal, drupalSettings) {
  /*
   * Helper functions
   */

  Drupal.behaviors.betterExposedFiltersDatePickers = {
    attach: function (context, settings) {

      // Check for and initialize datepickers.
      var befSettings = drupalSettings.better_exposed_filters;
      if (befSettings && befSettings.datepicker && befSettings.datepicker_options && $.fn.datepicker) {
        var opt = [];
        $.each(befSettings.datepicker_options, function (key, val) {
          if (key && val) {
            opt[key] = JSON.parse(val);
          }
        });
        $('.bef-datepicker').datepicker(opt);
      }

    }
  };
})(jQuery, Drupal, drupalSettings);
