<?php
/*
  Plugin Name: Custody Icici Plugin
  Plugin URI: marcellus.in/
  description: A simple custom plugin to Manage the Custody Icici forms data
  Version: 1.0.0
  Author: Ashish Pal
*/
define('PLUGIN_URL', plugins_url()."/");
define('PLUGIN_DIR_URL', plugin_dir_path( __FILE__ ));

function custody_icici_plugin_menu() {
  add_menu_page("Form Custody Icici", "Form Custody Icici","manage_options", "custodylist", "manageform",plugins_url('/custody-icici-plugin/images/generic.png'));
  add_submenu_page("custodylist","Add New", "Add New","manage_options", "custodylist&action=new", "manageform");
  add_submenu_page("custodylist","Type of Form", "Edit Type of Form","manage_options", "custodylist&action=ETOF", "manageform");
  add_submenu_page("custodylist","Type of Account", "Edit Type of Account","manage_options", "custodylist&action=ETOA", "manageform");
}
add_action('admin_init','enqueue_form_plugin_styles');
add_action('admin_init','enqueue_form_plugin_scripts');
function enqueue_form_plugin_styles() {
    wp_enqueue_style('datatable-css',PLUGIN_URL.'custody-icici-plugin/css/datatable.min.css' , array(), '1.0.0');
    wp_enqueue_style('style',PLUGIN_URL.'custody-icici-plugin/css/style.css' , array(), '1.0.0');
}
function enqueue_form_plugin_scripts(){
    wp_enqueue_script('script-js', PLUGIN_URL.'custody-icici-plugin/js/script.js', array('jquery'));
    wp_enqueue_script('datatable-js', PLUGIN_URL.'custody-icici-plugin/js/datatable.min.js', array('jquery'),'', true);
}

add_action("admin_menu", "custody_icici_plugin_menu");

function manageform(){
  include "uploadfile.php";
}