<?php
/**
 * Template Name: Video
 *
 */
 ?>
<?php get_header(); ?>
 
    <div id="full-content" class="media-coverage-page">
	    <section style="background: url('<?php echo home_url(); ?>/wp-content/uploads/2018/11/media-coverage-banner-bg.jpg')no-repeat center/cover;"  class="media-banner-bg">  
	      <div class="container">
	          <h1 class="page-title-cus"><?php  the_title() ?></h1>
	      </div>
	    </section>
        
                <section class="video-section section-padding">
				<div class="container">
					<h2 class="sec-title">Marcellus Webinars <span class="small">– detailed discussions of our portfolio performance and philosophy with our team</span></h2>
					<div class="owl-carousel owl-theme video-slider">
                            <?php
                            $pageURL = '';
                            $newWindow = false;
                            $the_query = new WP_Query( array(
                            'post_type'=>'video',
                            'order'=> 'desc',
                            'posts_per_page'=>-1,
                            'meta_query' => array(
                                'relation'		=> 'AND',
                                array(
                                'key'     => 'video_type',
                                'value'   => 'Marcellus Webinars',
                                'compare' 	=> '='
                                )
                            ),
                            'paged' => get_query_var('paged') ? get_query_var('paged') : 1) 
                            ); 
                             while ($the_query -> have_posts()) : $the_query -> the_post(); 
                             if (!empty(get_field('youtube_url'))) {
                                $pageURL = get_permalink();
                             } else {
                                 $pageURL = get_field( 'website_link');
                                 $newWindow = true;
                             }  
                        ?>
							<div class="grid-item-block">	
                            
								<div class="video-item">
                                <?php  $image = get_field('video_thumbnail');  ?>
									<figure style="background-image:url(<?php echo $image['url']; ?>)">
                                    
                                    
                                    <a href="<?php echo $pageURL; ?>" ></a>
                                    </figure>
									<div class="grid-item-body">
										<p class="published">Published on <?php the_time('d M, Y'); ?></p>
										<h2 class="title-2">
										<a href="<?php echo $pageURL; ?>" >
										<?php echo wp_trim_words( the_title(), 10); ?>
											
										</a></h2>
										
									</div>
									<div class="grid-item-footer">
                                        <a href="<?php echo $pageURL; ?>" class="btn-video-link" 
                                        <?php if($newWindow==true) {?>target="_blank" <?php }?>
                                        >WATCH VIDEO <i class="fa fa-play"></i></a>
										</div>
								</div>
							</div>
                        <?php 
                            endwhile; 
                        ?>
					</div>
				</div>
				<div class="container">
					<h2 class="sec-title">Marcellus Snippets <span class="small">– short videos that highlight a specific facet of our philosophy</span></h2>
					<div class="owl-carousel owl-theme video-slider">
                    <?php
                            $pageURL = '';
                            $newWindow = false;
                            $the_query = new WP_Query( array(
                            'post_type'=>'video',
                            'order'=> 'desc',
                            'posts_per_page'=>-1,
                            'meta_query' => array(
                                'relation'		=> 'AND',
                                array(
                                'key'     => 'video_type',
                                'value'   => 'Marcellus Snippets',
                                'compare' 	=> '='
                                )
                            ),
                            'paged' => get_query_var('paged') ? get_query_var('paged') : 1) 
                            ); 
                             while ($the_query -> have_posts()) : $the_query -> the_post(); 

                             
                            if (!empty(get_field('youtube_url'))) {
                                $pageURL = get_permalink();
                             } else {
                                 $pageURL = get_field( 'website_link');
                                 $newWindow = true;
                             }  
                             ?>

							<div class="grid-item-block">	
								<div class="video-item">
								    <?php $image = get_field('video_thumbnail'); ?>
									<figure style="background-image:url(<?php echo $image['url']; ?>)">
									<a href="<?php echo $pageURL; ?>" ></a>
                                    </figure>
									<div class="grid-item-body">
										<p class="published">Published on <?php the_time('d M, Y'); ?></p>
										<h2 class="title-2">
										<a href="<?php echo $pageURL; ?>" >
										<?php echo wp_trim_words( the_title(), 10); ?>
											
										</a></h2>
										
									</div>
									<div class="grid-item-footer">
                                        <a href="<?php echo $pageURL; ?>" class="btn-video-link" 
                                        <?php if($newWindow==true) {?>target="_blank" <?php }?>
                                        >WATCH VIDEO <i class="fa fa-play"></i></a>
									</div>
								</div>
							</div>
							<?php 
                            endwhile; 
							?>
					</div>
				</div>
			</section>
		
<?php if (is_page('152') ):?>
    <?php include(TEMPLATEPATH.'/includes/forms/enquiry.php'); ?>
<?php endif; ?>



<?php get_footer(); ?>