<?php
function register_our_team() {
	$labels = array(
		'name'               => _x( 'Our Team', 'post type general name' ),
		'singular_name'      => _x( 'Team', 'post type singular name' ),
		'add_new'            => _x( 'Add New', 'Team' ),
		'add_new_item'       => __( 'Add New Team' ),
		'edit_item'          => __( 'Edit Team' ),
		'new_item'           => __( 'New Team' ),
		'all_items'          => __( 'All Team' ),
		'view_item'          => __( 'View Team' ),
		'search_items'       => __( 'Search Team' ),
		'not_found'          => __( 'No records found' ),
		'not_found_in_trash' => __( 'No records found in the Trash' ), 
		'parent_item_colon'  => '',
		'menu_name'          => 'Our Team'
	);
	$args = array(
		'labels'        => $labels,
		'description'   => 'Holds our products and product specific data',
		'public'        => true,
		'menu_position' => 10,
		'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'comments' ),
		'has_archive'   => true,
	);
	register_post_type( 'Team', $args );	
}
add_action( 'init', 'register_our_team' );

  
add_action( 'init', 'register_resources' );
function register_resources() {
	$labels = array(
		'name' => _x( 'Resources', 'resources' ),
		'singular_name' => _x( 'Resources', 'resources' )
	);
	$args = array(
		'labels' => $labels,
		'hierarchical' => false,	    
		'show_ui' => true,
		'supports' => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt', 'comments' )
	);
	register_post_type( 'resources', $args );
}  

add_action( 'init', 'register_books' );
function register_books() {
	$labels = array(
		'name' => _x( 'Books', 'books' ),
		'singular_name' => _x( 'Books', 'books' )
	);
	$args = array(
		'labels' => $labels,
		'hierarchical' => false,	    
		'show_ui' => true,
		'supports' => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt', 'comments' )
	);
	register_post_type( 'books', $args );
}  

add_action( 'init', 'register_media_coverage' );
function register_media_coverage() {
	$labels = array(
		'name' => _x( 'Media Coverage', 'media_coverage' ),
		'singular_name' => _x( 'Media Coverage', 'media_coverage' )
	);
	$args = array(
		'labels' => $labels,
		'hierarchical' => false,	    
		'show_ui' => true,
		'supports' => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt', 'comments' )
	);
	register_post_type( 'media_coverage', $args );
}  	    

add_action( 'init', 'register_jobs' );
function register_jobs() {
	$labels = array(
		'name' => _x( 'Jobs', 'jobs' ),
		'singular_name' => _x( 'Jobs', 'jobs' )
	);
	$args = array(
		'labels' => $labels,
		'hierarchical' => false,	    
		'show_ui' => true,
		'supports' => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt', 'comments' )
	);
	register_post_type( 'jobs', $args );
}

function cp_blogs() {
	$labels = array(
		'name'               => _x( 'Blogs', 'post type general name' ),
		'singular_name'      => _x( 'Blog', 'post type singular name' ),
		'add_new'            => _x( 'Add New', 'Blog' ),
		'add_new_item'       => __( 'Add New Blog' ),
		'edit_item'          => __( 'Edit Blog' ),
		'new_item'           => __( 'New Blog' ),
		'all_items'          => __( 'All Blogs' ),
		'view_item'          => __( 'View Blogs' ),
		'search_items'       => __( 'Search Blogs' ),
		'not_found'          => __( 'No records found' ),
		'not_found_in_trash' => __( 'No records found in the Trash' ), 
		'parent_item_colon'  => '',
		'menu_name'          => 'Blogs'
	);
	$args = array(
		'labels'        => $labels,
		'description'   => 'Holds our products and product specific data',
		'public'        => true,
		'menu_position' => 5,
		'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'comments' ),
		'has_archive'   => true,
	);
	register_post_type( 'blogs', $args );	
}
add_action( 'init', 'cp_blogs' );


add_action( 'init', 'cp_newsletter' );   


function cp_newsletter() {
	$labels = array(
		'name'               => _x( 'Newsletter', 'post type general name' ),
		'singular_name'      => _x( 'Newsletter', 'post type singular name' ),
		'add_new'            => _x( 'Add New', 'Newsletter' ),
		'add_new_item'       => __( 'Add New Newsletter' ),
		'edit_item'          => __( 'Edit Newsletter' ),
		'new_item'           => __( 'New Newsletter' ),
		'all_items'          => __( 'All Newsletter' ),
		'view_item'          => __( 'View Newsletter' ),
		'search_items'       => __( 'Search Newsletter' ),
		'not_found'          => __( 'No records found' ),
		'not_found_in_trash' => __( 'No records found in the Trash' ), 
		'parent_item_colon'  => '',
		'menu_name'          => 'Newsletter'
	);
	$args = array(
        'labels' => $labels, 
		'public' => true, 
        'publicly_queryable' => true, 
        'show_ui' => true, 
        'query_var' => true, 
        'taxonomies'            => array('newsletter_categories'),
        'hierarchical'          => true,
        'show_in_menu'          => true,
        'menu_position'         => 5,
        'show_in_admin_bar'     => true,
        'show_in_nav_menus'     => true,
        'can_export'            => true,
        'has_archive'           => 'newsletter',        
        'exclude_from_search'   => false,
        'capability_type'       => 'page',
         'rewrite' => array(
            'slug' => 'newsletter/%newsletter_categories%'
        ), 
        
	);
	register_post_type( 'newsletter', $args );	


register_taxonomy(  
        'newsletter_categories',  
        'newsletter',        
        array(  
            'hierarchical' => true,  
            'label' => 'Categories',
            'query_var' => true,
            'rewrite' => array(
                'slug' => 'newsletter'
            )
        )  
    );

register_taxonomy_for_object_type( 'categories', 'newsletter' ); 

}

function wpse239701_events_post_link( $permalink, $post_id, $leavename ) {
    if ( strpos( $permalink, '%newsletter_categories%' ) === false ) {
        return $permalink;
    }

    // Get post
    $post = get_post($post_id);
    if ( ! $post ) {
        return $permalink;
    }

    // Get taxonomy terms
    $terms = wp_get_object_terms($post->ID, 'newsletter_categories');   
    if ( ! is_wp_error( $terms ) && ! empty( $terms ) && is_object( $terms[0] ) ) {
        $taxonomy_slug = $terms[0]->slug;
    } else { 
        $taxonomy_slug = 'uncategorized'; 
    }

    return str_replace( '%newsletter_categories%', $taxonomy_slug, $permalink );
}   
// add_filter( 'post_link', 'wpse239701_events_post_link', 10, 3 ); // Not needed - we aren't adding our custom taxonomy to posts, but if we were, this would be used.
add_filter( 'post_type_link', 'wpse239701_events_post_link', 10, 3 );





// Long Story and Short Story
function story() {
 
	// Set UI labels for Custom Post Type
		$labels = array(
			'name'                => _x( 'Story', 'Post Type General Name'),
			'singular_name'       => _x( 'Story', 'Post Type Singular Name'),
			'menu_name'           => __( 'Story'),
			'parent_item_colon'   => __( 'Parent Movie'),
			'all_items'           => __( 'All Story'),
			'view_item'           => __( 'View Story'),
			'add_new_item'        => __( 'Add New Story'),
			'add_new'             => __( 'Add New'),
			'edit_item'           => __( 'Edit Story'),
			'update_item'         => __( 'Update Story'),
			'search_items'        => __( 'Search Story'),
			'not_found'           => __( 'Not Found'),
			'not_found_in_trash'  => __( 'Not found in Trash'),
		);
		 
	// Set other options for Custom Post Type
		 
		$args = array(
			'label'               => __( 'Story'),
			'description'         => __( 'Story'),
			'labels'              => $labels,
			'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
			'hierarchical'        => false,
			'public'              => true,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => true,
			'show_in_admin_bar'   => true,
			'menu_position'       => 5,
			'can_export'          => true,
			'has_archive'         => true,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'capability_type'     => 'page',
			'taxonomies'          => array( 'category' ),
		);
		// Registering your Custom Post Type
		register_post_type( 'story', $args );
	}
	 
	add_action( 'init', 'story', 0 );


    // Long Story and Short Story
function video() {
 
	// Set UI labels for Custom Post Type
		$labels = array(
            'name'               => _x( 'Video', 'post type general name' ),
            'singular_name'      => _x( 'Video', 'post type singular name' ),
            'add_new'            => _x( 'Add New', 'Video' ),
            'add_new_item'       => __( 'Add New Video' ),
            'edit_item'          => __( 'Edit Video' ),
            'new_item'           => __( 'New Video' ),
            'all_items'          => __( 'All Video' ),
            'view_item'          => __( 'View Video' ),
            'search_items'       => __( 'Search Video' ),
            'not_found'          => __( 'No records found' ),
            'not_found_in_trash' => __( 'No records found in the Trash' ), 
            'parent_item_colon'  => '',
            'menu_name'          => 'Video'
		);
		 
	// Set other options for Custom Post Type
		 
		$args = array(
		'labels'        => $labels,
		'description'   => 'Holds our products and product specific data',
		'public'        => true,
		'menu_position' => 5,
		'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'comments', 'custom-fields' ),
		'has_archive'   => true
		);
		// Registering your Custom Post Type
		register_post_type( 'video', $args );
	}
	 
	add_action( 'init', 'video', 0 );


	register_taxonomy(  
        'videos_categories',  
        'video',        
        array(  
            'hierarchical' => true,  
            'label' => 'Categories',
            'query_var' => true,
            'rewrite' => array(
                'slug' => 'video'
            )
        )  
    );

register_taxonomy_for_object_type( 'categories', 'video' ); 

function newsletter_for_partners() {
 
// Set UI labels for Custom Post Type
    $labels = array(
        'name'                => _x( 'Newsletter for Partners', 'Post Type General Name', 'twentytwenty' ),
        'singular_name'       => _x( 'Newsletter for Partners', 'Post Type Singular Name', 'twentytwenty' ),
        'menu_name'           => __( 'Newsletter for Partners', 'twentytwenty' ),
        'parent_item_colon'   => __( 'Parent Newsletter for Partners', 'twentytwenty' ),
        'all_items'           => __( 'All Newsletter for Partners', 'twentytwenty' ),
        'view_item'           => __( 'View Newsletter for Partners', 'twentytwenty' ),
        'add_new_item'        => __( 'Add New Newsletter for Partners', 'twentytwenty' ),
        'add_new'             => __( 'Add New', 'twentytwenty' ),
        'edit_item'           => __( 'Edit Newsletter for Partners', 'twentytwenty' ),
        'update_item'         => __( 'Update Newsletter for Partners', 'twentytwenty' ),
        'search_items'        => __( 'Search Newsletter for Partners', 'twentytwenty' ),
        'not_found'           => __( 'Not Found', 'twentytwenty' ),
        'not_found_in_trash'  => __( 'Not found in Trash', 'twentytwenty' ),
    );
     
// Set other options for Custom Post Type
     
    $args = array(
        'label'               => __( 'Newsletter for Partners', 'twentytwenty' ),
        'description'         => __( 'Newsletter for Partners', 'twentytwenty' ),
        'labels'              => $labels,
        // Features this CPT supports in Post Editor
        'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
        
        /* A hierarchical CPT is like Pages and can have
        * Parent and child items. A non-hierarchical CPT
        * is like Posts.
        */ 
        'hierarchical'        => false,
        'public'              => true,
        'show_ui'             => true,
        'show_in_menu'        => true,
        'show_in_nav_menus'   => true,
        'show_in_admin_bar'   => true,
        'menu_position'       => 5,
        'can_export'          => true,
        'has_archive'         => true,
        'exclude_from_search' => false,
        'publicly_queryable'  => true,
        'capability_type'     => 'post',
        'show_in_rest' => true,
 
    );
     
    // Registering your Custom Post Type
    register_post_type( 'newsletterPartners', $args );
 
}
 
/* Hook into the 'init' action so that the function
* Containing our post type registration is not 
* unnecessarily executed. 
*/
 
add_action( 'init', 'newsletter_for_partners', 0 );