<?php
/**
 * Template Name: Media Coverage Interview
 *
 */
 ?>
<?php get_header(); ?>
 
    <div id="full-content" class="media-coverage-page">
	    <section style="background: url('<?php echo home_url(); ?>/wp-content/uploads/2018/11/media-coverage-banner-bg.jpg')no-repeat center/cover;"  class="media-banner-bg">  
	      <div class="container">
	          <h1 class="page-title-cus">MEDIA COVERAGE INTERVIEW</h1>
	      </div>
	    </section>

	    <div class="container">
	    	<div class="row media-cover-content">
				<ul class="clearfix">
					<?php
						$args = array('post_type' => 'media_coverage','meta_value' =>'online_interview', 'posts_per_page' => 5, 'orderby' => 'id', 'paged' => $paged,'order' => 'DESC');
						$loop = new WP_Query($args);
						while ($loop->have_posts()) : $loop->the_post(); 
					?>
						<li>
							<div class="media-cover-wrap">
								<div class="media-img">
									<?php the_post_thumbnail('full', array('class'=>'img-fluid')); ?>
								</div>
								<h2 class="media-coverage-title-h2"><?php the_title(); ?></h2>		
								<p class="media-description">
								<?php echo get_the_content(); ?></p>
								<hr/>
								<p class="published">Published on <span class="publish-date"><?php the_time('d M, Y'); ?> by</span><span class="publish-by"> <?php echo get_field('article_by'); ?></span></p>

								<a href="<?php echo get_field('article_url'); ?>" target="_blank" class="article-link">VIEW FULL ARTICLE</a>
							</div>
						</li>
					<?php endwhile; ?>
				</ul>
				<div class="pagination">
				    <?php 
				        echo paginate_links( array(
				            'base'         => str_replace( 999999999, '%#%', esc_url(get_pagenum_link( 999999999 ))),
				            'total'        => $loop->max_num_pages,
				            'current'      => max( 1, get_query_var( 'paged' ) ),
				            'format'       => '?paged=%#%',
				            'show_all'     => false,
				            'type'         => 'plain',
				            'end_size'     => 2,
				            'mid_size'     => 1,
				            'prev_next'    => true,
				            'prev_text'    => sprintf( '<i></i> %1$s', __( '<<', 'text-domain' ) ),
				            'next_text'    => sprintf( '%1$s <i></i>', __( '>>', 'text-domain' ) ),
				            'add_args'     => false,
				            'add_fragment' => '',
				        ) );
				    ?>
				</div>


	    	</div>
	    </div>
    </div>
 <?php include(TEMPLATEPATH.'/includes/forms/enquiry.php'); ?>
<?php get_footer(); ?>