<?php
/**
 * The template for displaying Archive pages.
 *
 * Used to display archive-type pages if nothing more specific matches a query.
 * For example, puts together date-based pages if no date.php file exists.
 *
 * Learn more: http://codex.wordpress.org/Template_Hierarchy
 *
 * @package WordPress
 * @subpackage Twenty_Eleven
 * @since Twenty Eleven 1.0
 */

get_header(); ?>
        <section style="background: url('<?php echo home_url(); ?>/wp-content/uploads/2018/11/media-coverage-banner-bg.jpg')no-repeat center/cover;"  class="media-banner-bg">  
	      <div class="container">
	          <h1 class="page-title-cus">
                  <?php  if($taxonomy = 'newsletter_categories'){ ?>
                  Newsletters : <?php echo single_cat_title(); ?></h1>

                 <?php } ?> 
	      </div>
	    </section>


		<section id="primary">
            <?php  if($taxonomy = 'newsletter_categories'){ ?>
            
            <div class="page-full-tabs">
                <div class="container">
                    <nav class="pagetabs">
                         <ul>
                            <?php
                            $category = get_the_category();
                            $current_category_ID = isset($category->cat_ID) ? $category->cat_ID : 0;
                            $args = array(
                                'taxonomy' => 'newsletter_categories',
                                'hide_empty' => 0,
                                'hierarchical' => 1,
                                'title_li' => '',
                                'current_category' => $current_category_ID
                            );
                            wp_list_categories($args);
                            //print_r(wp_list_categories($args));

                        ?>
                        </ul>
                    </nav>
                </div>
            </div>

   
            <div class="resource-content newsletter">
            <div class="container">

   

			<?php //if ( have_posts() ) : 
            
           
            
            ?>
            <div class="data-record row">
				    <?php //while ( have_posts() ) : the_post(); 
                    
                     
                                    $the_query = new WP_Query( array('posts_per_page'=>-1,
                                    'post_type'=>'newsletter',
                                    'order'=> 'DESC',
                                    'tax_query' => [
                                            [
                                                'taxonomy' => 'newsletter_categories',
                                                'terms'    => get_queried_object_id()
                                            ]
                                    ],
                                    'paged' => get_query_var('paged') ? get_query_var('paged') : 1) 
                                    ); 
                                    while ($the_query -> have_posts()) : $the_query -> the_post(); 
                                
                    
                    ?>
                    <article class="col-sm-8 col-md-4 col-12 mb-5" >
                            <div class="media-cover-wrap">
                                <div class="blog-item-info">
                                    <p class="published"><span class="month"><?php the_time('M Y'); ?></span>&nbsp;&nbsp;&nbsp; Published on <span class="publish-date"><?php the_time('d M, Y'); ?></span></p>
                                    <h3 class="blog-title-h2"> 
                                        <a href="<?php the_permalink(); ?>"><?php 
                                        echo mb_strimwidth(get_the_title(), 0,40, '...'); 
                                ?></a></h3>
                                    <p class="media-description"><?php echo pov_excerpt( get_the_excerpt(), '80'); ?></p>
                                    <hr>
                                        <a href="<?php the_permalink(); ?>" class="view-detail">Read more</a>
                                </div>
                            </div>
                    </article>
				    <?php endwhile; ?>
                </div>
                <?php //endif; ?>
               <div class="pagination-custom">
								<?php 
									$big = 999999999; // need an unlikely integer
									echo paginate_links( array(
									'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
									'format' => '?paged=%#%',
									'current' => max( 1, get_query_var('paged') ),
									'total' => $the_query->max_num_pages
									) );
									wp_reset_postdata(); 
								?>
						</div>
                
                            
                </div>
                </div>
             <?php } ?>
		</section><!-- #primary -->

<?php get_sidebar(); ?>
<?php get_footer(); ?>