<?php
/**
 * Template Name: Resources
 *
 */
 ?>
<?php get_header(); ?>
 
    <div id="full-content" class="media-coverage-page">
	    <section style="background: url('<?php echo home_url(); ?>/wp-content/uploads/2018/11/media-coverage-banner-bg.jpg')no-repeat center/cover;"  class="media-banner-bg">  
	      <div class="container">
	          <h1 class="page-title-cus"><?php if(is_page(108)) { echo 'Blogs'; } else { the_title(); } ?></h1>
	      </div>
	    </section>
		<?php if(is_page(134)) { ?>
			<section class="what-we-read section-padding">
				<div class="container">
					<div class="row ">
						<div class="col-lg-12 col-md-12">
							 <?php					            
					            $categories = get_categories(array('child_of' => 5, 'orderby' => 'ID', 'order' => 'ASC'));
					            foreach($categories as $category) { 
					                echo '<h4>'.$category->name.'</h4>';
					                echo '<ul class="post-title">';
					                    $query = new WP_Query( array( 'cat'=> $category->term_id) );
					                    while( $query->have_posts() ):$query->the_post();
					                     echo '<li><a target="_blank" rel="noopener" href="'.get_the_permalink().'">'.get_the_title().'</a></li>';
					                    endwhile;
					                    wp_reset_postdata();
					                echo '</ul>';
					            }
					        ?>
						</div>
					</div>
				</div>
			</section>
		<?php } else if(is_page(152)) { ?><!-- video section -->
			<section class="video-section section-padding">
				<div class="container">
					<div class="row">
						<?php 
							$videos = get_cfc_meta('videos');
							if(count($videos) > 0) :
							krsort($videos,SORT_REGULAR);
							foreach( $videos as $key => $value ) : 
							$videoThumb = get_cfc_field( 'videos','video-thumbnail', false, $key );
							$videoURL = get_cfc_field( 'videos','video-url', false, $key );
							$videoTitle = get_cfc_field( 'videos','video-title', false, $key );
						?>
							<div class="col-lg-4 col-md-4 col-sm-6 col-12 video-item">
								<div class="videowrap">
									<figure>
										<img src="<?php echo $videoThumb['url']; ?>" class="img-fluid">
                                    </figure>
                                    <div class="videowrap-info">
										<h2 class="video-title-h2"><?php echo $videoTitle; ?></h2>
										<a href="<?php echo $videoURL; ?>" target="_blank"><i class="fa fa-play"></i></a>
									</div>
								</div>
							</div>
							<?php 
								endforeach; 
							endif; 
							?>
					</div>
				</div>
			</section>	
		<?php } else { ?>
			<section class="section-padding">
				<div class="container">
					<div class="row">
						<div class="col-lg-12 col-md-12">
							<?php if(have_posts()) : while(have_posts()) : the_post(); ?>
								<?php the_content(); ?>
							<?php endwhile; endif; ?>
						</div>
					</div>
				</div>
			</section>
		<?php } ?>
    </div>
<?php if (is_page('152') ):?>
    <?php include(TEMPLATEPATH.'/includes/forms/enquiry.php'); ?>
<?php endif; ?>



<?php get_footer(); ?>