<?php
/**
 * Template Name: Newsletter
 *
 */
 ?>
<?php get_header(); ?>
 
    <div id="full-content" class="media-coverage-page">
	    <section style="background: url('<?php echo home_url(); ?>/wp-content/uploads/2018/11/media-coverage-banner-bg.jpg')no-repeat center/cover;"  class="media-banner-bg">  
	      <div class="container">
	          <h1 class="page-title-cus"><?php if(is_page(131)) { echo 'Newsletter'; } else { the_title(); } ?></h1>
	      </div>
	    </section>

		
			<section class="section-padding">
				<div class="container">
					<div class=" resource-content newsletter">
					 <div class="data-record row">
                                               
					
                                <?php
                                    $the_query = new WP_Query( array('posts_per_page'=>10,
                                    'post_type'=>'Newsletter',
                                    'order'=> 'DESC',
                                    'paged' => get_query_var('paged') ? get_query_var('paged') : 1) 
                                    ); 
                                    while ($the_query -> have_posts()) : $the_query -> the_post(); 
                                ?>  
                                <article class="col-sm-8 col-md-4 col-12 mb-5" >
                                        <div class="media-cover-wrap">
                                            <div class="blog-item-info">
                                                <p class="published"><span class="month"><?php the_time('M Y'); ?></span>&nbsp;&nbsp;&nbsp; Published on <span class="publish-date"><?php the_time('d M, Y'); ?></span></p>
                                                <h3 class="blog-title-h2"> 
                                                    <a href="<?php the_permalink(); ?>"><?php 
                                                 echo mb_strimwidth(get_the_title(), 0,40, '...'); 
                                            ?></a></h3>
                                                <p class="media-description"><?php echo pov_excerpt( get_the_excerpt(), '80'); ?></p>
                                                <hr>
                                                    <a href="<?php the_permalink(); ?>" class="view-detail">Read more</a>
                                            </div>
                                        </div>
                                </article>
								<?php endwhile; ?>							
						</section>
						<div class="pagination-custom">
								<?php 
									$big = 999999999; // need an unlikely integer
									echo paginate_links( array(
									'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
									'format' => '?paged=%#%',
									'current' => max( 1, get_query_var('paged') ),
									'total' => $the_query->max_num_pages
									) );
									wp_reset_postdata(); 
								?>
						</div>
					</div>
				</div>
			</section>
		
			
    </div>
<?php include(TEMPLATEPATH.'/includes/forms/enquiry.php'); ?>
<?php get_footer(); ?>