<?php
/**
 * Template Name: Blog Listing
 *
 */
 ?>
<?php get_header(); ?>
 
    <div id="full-content" class="media-coverage-page">
	    <section style="background: url('<?php echo home_url(); ?>/wp-content/uploads/2018/11/media-coverage-banner-bg.jpg')no-repeat center/cover;"  class="media-banner-bg">  
	      <div class="container">
	          <h1 class="page-title-cus"><?php if(is_page(131)) { echo 'Player'; } else { the_title(); } ?></h1>
	      </div>
	    </section>
		
			<section class="section-padding">
				<div class="container">
					
					<div class="resource-content">
					
						<div class="row">
							<?php
								$the_query = new WP_Query( array('posts_per_page'=>9,
								'post_type'=>'blogs',
								'order'=> 'DESC',
								'paged' => get_query_var('paged') ? get_query_var('paged') : 1) 
								); 
								 while ($the_query -> have_posts()) : $the_query -> the_post(); 
							?>
								<div class="col-sm-6 col-md-4 mb-5">
                                   
									<div class="grid-item-block">		
                                     <figure>
                                     <?php if ( has_post_thumbnail() ) {?>
                                        <?php the_post_thumbnail( 'blog-featured-thumb-large' ); ?>
                                        <?php } else { ?>
                                        <img src="<?php echo get_template_directory_uri() ?>/images/featured_default_image.jpg" alt="<?php the_title(); ?>" />
                                        <?php } ?>

                                        
                                    </figure>
                                    <div class="grid-item-body">
											<p class="published">Published on <?php the_time('d M, Y'); ?></p>								
											<h2 class="title"><a href="<?php the_permalink(); ?>"><?php echo wp_trim_words( get_the_title(), 12); ?> </a></h2>		
											<p class="description"><?php echo pov_excerpt( get_the_excerpt(), '150'); ?></p>
											
										</div>
										<div class="grid-item-footer">
										<hr/>
										<a href="<?php the_permalink(); ?>" class="view-detail">VIEW MORE</a>
                                        </div>
									</div>

								</div>
								<?php endwhile; ?>							
							</div>
						<div class="row">
						<div class="pagination-custom">
								<?php 
									$big = 999999999; // need an unlikely integer
									echo paginate_links( array(
									'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
									'format' => '?paged=%#%',
									'current' => max( 1, get_query_var('paged') ),
									'total' => $the_query->max_num_pages
									) );
									wp_reset_postdata(); 
								?>
						</div>
                        </div>
					</div>
				</div>
			</section>
		
			
    </div>
	<?php include(TEMPLATEPATH.'/includes/forms/enquiry.php'); ?>
<?php get_footer(); ?>
