<?php 
require_once(TEMPLATEPATH . '/includes/functions/sidebars.php'); 
require_once(TEMPLATEPATH . '/includes/functions/customize.php'); 
require_once(TEMPLATEPATH . '/includes/functions/custom-post.php'); 

 
//Add support for WordPress 3.0's custom menus
add_action( 'init', 'register_my_menu' );
 
//Register area for custom menu
function register_my_menu() {
    register_nav_menu( 'primary-menu', __( 'Primary Menu' ) );
    register_nav_menu( 'footer-menu', __( 'Footer Menu' ) );
    
}

function register_footer_menu() {
  register_nav_menu('footer-menu-1',__( 'Footer Menu 1' ));
  register_nav_menu('footer-menu-2',__( 'Footer Menu 2' ));
}
add_action( 'init', 'register_footer_menu' );

add_theme_support( 'post-thumbnails' );
add_image_size( 'blog-featured-thumb-large', 346, 211  );
add_image_size( 'blog-featured-thumb-small', 100, 80 );






//Add files for menu
function default_enqueue_style() {
	wp_enqueue_style( 'menu', get_stylesheet_directory_uri().'/css/meanmenu.css', false ); 
}
function default_enqueue_script() {
	wp_enqueue_script( 'menu-script', get_stylesheet_directory_uri().'/js/jquery.meanmenu.js', false );
}
add_action( 'wp_enqueue_scripts', 'default_enqueue_style' );
add_action( 'wp_enqueue_scripts', 'default_enqueue_script' );

//Enable multisite feature (WordPress 3.0)
define('WP_ALLOW_MULTISITE', true);

// Shorten Excerpt text for use in theme
function pov_excerpt($text, $chars = 620) {
    $text = $text." ";
    $text = substr($text,0,$chars);
    $text = substr($text,0,strrpos($text,' '));
    $text = $text."...";
    return $text;
}
function widget_init(){
register_sidebar( array(
'name' => 'Footer About Us',
'id' => 'footer-about-us',
'description' => 'Appears in the footer area',
'before_widget' => '<aside id="%1$s" class="widget %2$s">',
'after_widget' => '</aside>',
'before_title' => '<h3 class="widget-title">',
'after_title' => '</h3>',
) );
}

add_action( 'init', 'widget_init' );

// hook into admin-ajax
// the text after 'wp_ajax_' and 'wp_ajax_no_priv_' in the add_action() calls
// that follow is what you will use as the value of data.action in the ajax
// call in your JS

// if the ajax call will be made from JS executed when user is logged into WP,
// then use this version
add_action ('wp_ajax_marcellus_send_otp', 'marcellus_send_otp') ;
// if the ajax call will be made from JS executed when no user is logged into WP,
// then use this version
add_action ('wp_ajax_nopriv_marcellus_send_otp', 'marcellus_send_otp') ;
function marcellus_send_otp ()
{
    //$headers = 'From: admin <noreply@admin>';
    $headers = array('From: Marcellus – OTP  <noreply@marcellus.in>','Content-Type: text/html; charset=UTF-8');
    $to = $_POST['email'];
    $name = $_POST['name'];
    if (!empty($to) && !empty($name)) {
    $subject = 'Be the First to Know';
    // The unique token can be inserted in the message with %s
    //$message = 'Thank you. Please token otp to continue';
    $message = '<table width="600px" cellspacing="0" align="center" cellpadding="0" border="0" style="border:1px solid #ccc; background:#fff;">';
    $message .= '<tr><td style="background-color:#fff; border-bottom: solid 1px #ccc;"><a href="#" title=""><img src="http://marcellus.in/wp-content/uploads/2018/11/logo.png" border="0" hspace="10" vspace="10" /></a></td></tr>';
    $message .= '<tr><td style="padding:25px 15px; font-family:Arial, Helvetica, sans-serif; font-size:12px; color:#333;"><table width="600px" border="0" cellspacing="2" cellpadding="3" style="padding-left:10px; padding-right:10px;font-family: Arial, Helvetica, sans-serif; font-size: 12px; color: #333; font-weight: standard;"><tr><td height="39" colspan="3"><b style="padding-left:10px;">Dear %s,</b> <br> <br><span style="padding-left:10px;"><b>%s</b> is the OTP for email verification. Please enter it in the space provided on the website. <br></span><span style="padding-left:10px;">Thank You for using Marcellus.</span></td></tr><tr><td colspan="3">&nbsp;</td></tr></table></td></tr>';
    $message .= '<tr><td style="background-color:#FFF; border-top:1px solid #ccc;"><table width="600"><tr><td style="text-align:left; padding:6px; font-family:Arial, Helvetica, sans-serif; font-size:11px; color:#333;">Copyright 2018 Marcellus. All Rights Reserved.<br /><br /></td></tr></table></td></tr></table>';
    //if ($isAllValid) {
    EmailConfirmation::sendOtp($to,$name, $subject, $message, $headers);
    //}
    $return_html = 'OTP has been sent.';
    wp_send_json_success ($return_html) ;
    } else {
        // set the return value you want on error
        // return value can be ANY data type (e.g., array())
        $return_html = 'Please fill email and name.' ;
        wp_send_json_error ($return_html) ;
    }
    exit;
}

// if the ajax call will be made from JS executed when user is logged into WP,
// then use this version
add_action ('wp_ajax_marcellus_check_otp', 'marcellus_check_otp') ;
// if the ajax call will be made from JS executed when no user is logged into WP,
// then use this version
add_action ('wp_ajax_nopriv_marcellus_check_otp', 'marcellus_check_otp') ;
function marcellus_check_otp ()
{
    $to = $_POST['email'];
    $otp = $_POST['otp'];
    if (!empty($to) && !empty($otp)) {
        $check = EmailConfirmation::checkOtp($otp, $to);
        if($check) {
            $return_html = 'OTP has been sent.';
            wp_send_json_success ($return_html) ;
        } else {
            $return_html = 'OTP is not matching.';
            wp_send_json_error ($return_html) ;
        }
        
    } else {
        $return_html = 'Please send otp';
        wp_send_json_error ($return_html) ;
    }
    exit;
}


function html5_search_form( $form ) { 
     $form = '<section class="search"><form role="search" method="get" id="search-form" action="' . home_url( '/' ) . '" >
    <label class="screen-reader-text" for="s">' . __('',  'domain') . '</label>
     <input type="search" value="' . get_search_query() . '" name="s" id="s" placeholder="Search here..." class="form-control" />
     
     </form></section>';
     return $form;
}

add_filter( 'get_search_form', 'html5_search_form' );


function mailtrap($phpmailer) {
  $phpmailer->isSMTP();
  $phpmailer->Host = 'smtp.gmail.com';
  $phpmailer->SMTPAuth = true;
  $phpmailer->Port = 587;
  $phpmailer->Username = 'manzar.abdb@gmail.com';
  $phpmailer->Password = 'Manzar@123';
}

add_action('phpmailer_init', 'mailtrap');
