<?php
/**
 * Template Name: Video
 *
 */
 ?>
<?php get_header(); ?>
 
    <div id="full-content" class="media-coverage-page">
	    <section style="background: url('<?php echo home_url(); ?>/wp-content/uploads/2018/11/media-coverage-banner-bg.jpg')no-repeat center/cover;"  class="media-banner-bg">  
	      <div class="container">
	          <h1 class="page-title-cus"><?php  the_title() ?></h1>
	      </div>
	    </section>
		
			<section class="video-section  section-padding">
				<div class="container">
					<div class="row ">
						
                            <?php
								$the_query = new WP_Query( array(
								'post_type'=>'video',
								'order'=> 'desc',
								'posts_per_page'=>9,
								'paged' => get_query_var('paged') ? get_query_var('paged') : 1) 
								); 
								 while ($the_query -> have_posts()) : $the_query -> the_post(); 
							?>
                            <div class="col-lg-4 col-md-4 col-sm-6 col-12 video-item">
                                 <section class="grid-item-block">
                                 <?php if (!empty(get_field('youtube_url'))) {?>
                                    <figure>
                                        <a href="<?php echo get_permalink(); ?>" target="_blank">
                                             <?php if (get_field('video_thumbnail') ) {
                                                     $image = get_field('video_thumbnail'); 
                                                 ?>
                                                 <img src="<?php echo $image['url'] ?>" alt="<?php the_title(); ?>" />                                               
                                            <?php } else { ?>
                                                <img src="<?php echo get_template_directory_uri() ?>/images/featured_default_image.jpg" alt="<?php the_title(); ?>" />
                                            <?php } ?>
                                         <i class="fa fa-play"></i>
                                        </a>
                                    </figure>
                                    <div class="grid-item-body">
										<h2 class="title">
                                            <a href="<?php echo get_permalink(); ?>" ><?php 
                                                 echo mb_strimwidth(get_the_title(), 0,80, '...'); 
                                            ?></a>
                                        </h2>
                                        </div>
                                        <div class="grid-item-footer">
                                        <hr >
                                      <a href="<?php echo get_permalink( $post->ID); ?>" class="view-detail">Watch Video</a>
									</div>


                                <?php } else {?>        
                                       <figure>
                                        <a href="<?php echo get_field( 'website_link'); ?>" target="_blank">
                                             <?php if (get_field('video_thumbnail') ) {
                                                     $image = get_field('video_thumbnail'); 
                                                 ?>
                                                 <img src="<?php echo $image['url'] ?>" alt="<?php the_title(); ?>" />                                               
                                            <?php } else { ?>
                                                <img src="<?php echo get_template_directory_uri() ?>/images/featured_default_image.jpg" alt="<?php the_title(); ?>" />
                                            <?php } ?>
                                         <i class="fa fa-play"></i>
                                        </a>
                                    </figure>
                                    <div class="grid-item-body">
										<h2 class="title">
                                            <a href="<?php echo get_field( 'website_link'); ?>" ><?php 
                                                 echo mb_strimwidth(get_the_title(), 0,80, '...'); 
                                            ?></a>
                                        </h2>
                                        </div>
                                        <div class="grid-item-footer">
                                        <hr >
                                       <a href="<?php echo get_field( 'website_link'); ?>" class="view-detail" target="_blank">Watch Video</a>
									</div>

                                <?php } ?>
                                </section>
                           
                            </div>

                            <?php endwhile; ?>                         
					</div>
					<div class="pagination-custom">
								<?php 
									$big = 999999999; // need an unlikely integer
									echo paginate_links( array(
									'base' => str_replace( $big, '%#%', get_pagenum_link( $big ) ),
									'format' => '?paged=%#%',
									'current' => max( 1, get_query_var('paged') ),
									'total' => $the_query->max_num_pages
									) );
									wp_reset_postdata(); 
								?>
						</div>
				</div>
			</section>
		
<?php if (is_page('152') ):?>
    <?php include(TEMPLATEPATH.'/includes/forms/enquiry.php'); ?>
<?php endif; ?>



<?php get_footer(); ?>