<?php
defined( 'ABSPATH' ) or die( 'Direct access is not permitted' );
global $wpdb;
$table_name = $wpdb->prefix."custody_icici_forms";
?>
<div class="wrap">
      <a href='admin.php?page=custodylist&action=new' class="page-title-action">Add New Forms</a>
      <h2>Custody Forms list</h2>
      <form class="search-form wp-clearfix" method="get">
            <input type="hidden" name="page" value="custodylist">
            <input type="hidden" name="action" value="search">
            <p class="search-box">
              <label class="screen-reader-text" for="tag-search-input">Search</label>
              <input type="search" id="tag-search-input" name="s" value="">
              <select name="search_type" id="search_type">
                <option value="">Select Search Type</option>
                <option value="STOF">Type of Form</option>
                <option value="TOA">Type of Account</option>
                <option value="URL">User URL</option>    
              </select>
              <input type="submit" id="search-submit" class="button" value="Search">
            </p>
      </form> 
      <table class="wp-list-table widefat fixed striped posts" id="form_list">
        <thead>
          <tr>
            <th width="5%">Id</th>
            <th width="20%">Type of form</th>
            <th width="20%">Type of Account</th>
            <th width="20%">User URl</th>
            <th width="20%">Url</th>
            <th width="5%">Status</th>
            <th width="5%">Ordering</th>
            <th width="8%">Actions</th>
          </tr>
        </thead>
        <tbody>
         <?php
            $limit = 25;
            $page_num = isset( $_GET['pagenum'] ) ? absint( $_GET['pagenum'] ) : 1;
            $offset = ( $page_num - 1 ) * $limit;

            $query ="SELECT * FROM $table_name where 1 ";
            $query_count ="SELECT count(id) FROM $table_name where 1 ";
            if(isset($_GET['action']) && $_GET['action']=="search"){
              $search = array("STOF"=>"type_of_form","TOA"=>"type_of_account","URL" =>"Slug");
              if(!empty($_GET["search_type"])){
                $search_query =' and '.$search[$_GET['search_type']]." like '%".$_GET["s"]."%'";
                $query = $query.$search_query;
              }else{
                if(!empty($_GET["s"])){
                  $search_query = "and like '%".$_GET["s"]."%' ";
                  $query = $query.$search_query;
                }
              }
            }
            $query_count = $query_count.$search_query;
            $total =  $wpdb->get_var($query_count);
            $query = $query."order by id";
            $num_of_pages = ceil( $total / $limit );
            $query = $query." LIMIT ".$offset.','.$limit;
            $result = $wpdb->get_results($query);
          if($total>=1){
            foreach ($result as $print) {
              $status = 'De-Active';
              $status_val = 1;
              $class= 'View';
              if($print->status==1){
                 $status = 'Active';
                 $status_val = 0;
                 $class = 'Delete';   
              }
              ?>
                <tr>
                  <td><?php echo $print->id?></td>
                  <td><?php echo $print->type_of_form?></td>
                  <td><?php echo $print->type_of_account?></td>
                  <td><a href="<?php echo $print->slug?>">User Url</a></td>
                  <td><a href="<?php echo $print->download_file_name?>">Check File</a></td>
                  <td><?php echo $status?></td>
                  <td><?php echo $print->ordering?></td>
                  <td>
                  <span class="edit"><a href="admin.php?page=custodylist&action=update&upt=<?php echo $print->id?>" aria-label="Edit">Edit</a>|</span> |<span class="view"><a href="admin.php?page=custodylist&action=view&upt=<?php echo $print->id?>" aria-label="view">View</a>|</span> | </span><span class="<?php echo $class?>"><a href="admin.php?page=custodylist&action=status&status=<?php echo $status_val?>&upt=<?php echo $print->id?>" class="delete-tag aria-button-if-js" aria-label="Delete “blog”" role="button"><?php echo $status?></a></td>
                </tr>
              
            <?php }
                
                $page_links = paginate_links( array(
                  'base' => add_query_arg( 'pagenum', '%#%' ),
                  'format' => '',
                  'prev_text' => __( '«', 'text-domain' ),
                  'next_text' => __( '»', 'text-domain' ),
                  'total' => $num_of_pages,
                  'current' => $pagenum
                  ));
            if ($page_links && $num_of_pages > 1) {
            echo '<div class="tablenav"><div class="tablenav-pages" style="margin: 1em 0;">' . $page_links . '</div></div>';
            }
        }else{?>
              <tr>
                  <td colspan="8">No Record found</td>
              </tr>       
        <?php }    
            ?>
        </tbody>

      </table>
  </div>
  