<?php
function register_our_team() {
	$labels = array(
		'name'               => _x( 'Our Team', 'post type general name' ),
		'singular_name'      => _x( 'Team', 'post type singular name' ),
		'add_new'            => _x( 'Add New', 'Team' ),
		'add_new_item'       => __( 'Add New Team' ),
		'edit_item'          => __( 'Edit Team' ),
		'new_item'           => __( 'New Team' ),
		'all_items'          => __( 'All Team' ),
		'view_item'          => __( 'View Team' ),
		'search_items'       => __( 'Search Team' ),
		'not_found'          => __( 'No records found' ),
		'not_found_in_trash' => __( 'No records found in the Trash' ), 
		'parent_item_colon'  => '',
		'menu_name'          => 'Our Team'
	);
	$args = array(
		'labels'        => $labels,
		'description'   => 'Holds our products and product specific data',
		'public'        => true,
		'menu_position' => 10,
		'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'comments' ),
		'has_archive'   => true,
	);
	register_post_type( 'Team', $args );	
}
add_action( 'init', 'register_our_team' );

  
add_action( 'init', 'register_resources' );
function register_resources() {
	$labels = array(
		'name' => _x( 'Resources', 'resources' ),
		'singular_name' => _x( 'Resources', 'resources' )
	);
	$args = array(
		'labels' => $labels,
		'hierarchical' => false,	    
		'show_ui' => true,
		'supports' => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt', 'comments' )
	);
	register_post_type( 'resources', $args );
}  

add_action( 'init', 'register_books' );
function register_books() {
	$labels = array(
		'name' => _x( 'Books', 'books' ),
		'singular_name' => _x( 'Books', 'books' )
	);
	$args = array(
		'labels' => $labels,
		'hierarchical' => false,	    
		'show_ui' => true,
		'supports' => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt', 'comments' )
	);
	register_post_type( 'books', $args );
}  

add_action( 'init', 'register_media_coverage' );
function register_media_coverage() {
	$labels = array(
		'name' => _x( 'Media Coverage', 'media_coverage' ),
		'singular_name' => _x( 'Media Coverage', 'media_coverage' )
	);
	$args = array(
		'labels' => $labels,
		'hierarchical' => false,	    
		'show_ui' => true,
		'supports' => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt', 'comments' )
	);
	register_post_type( 'media_coverage', $args );
}  	    

add_action( 'init', 'register_jobs' );
function register_jobs() {
	$labels = array(
		'name' => _x( 'Jobs', 'jobs' ),
		'singular_name' => _x( 'Jobs', 'jobs' )
	);
	$args = array(
		'labels' => $labels,
		'hierarchical' => false,	    
		'show_ui' => true,
		'supports' => array( 'title', 'editor', 'author', 'thumbnail', 'excerpt', 'comments' )
	);
	register_post_type( 'jobs', $args );
}

function cp_blogs() {
	$labels = array(
		'name'               => _x( 'Blogs', 'post type general name' ),
		'singular_name'      => _x( 'Blog', 'post type singular name' ),
		'add_new'            => _x( 'Add New', 'Blog' ),
		'add_new_item'       => __( 'Add New Blog' ),
		'edit_item'          => __( 'Edit Blog' ),
		'new_item'           => __( 'New Blog' ),
		'all_items'          => __( 'All Blogs' ),
		'view_item'          => __( 'View Blogs' ),
		'search_items'       => __( 'Search Blogs' ),
		'not_found'          => __( 'No records found' ),
		'not_found_in_trash' => __( 'No records found in the Trash' ), 
		'parent_item_colon'  => '',
		'menu_name'          => 'Blogs'
	);
	$args = array(
		'labels'        => $labels,
		'description'   => 'Holds our products and product specific data',
		'public'        => true,
		'menu_position' => 5,
		'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'comments' ),
		'has_archive'   => true,
	);
	register_post_type( 'blogs', $args );	
}
add_action( 'init', 'cp_blogs' );



function cp_newsletter() {
	$labels = array(
		'name'               => _x( 'Newsletter', 'post type general name' ),
		'singular_name'      => _x( 'Newsletter', 'post type singular name' ),
		'add_new'            => _x( 'Add New', 'Newsletter' ),
		'add_new_item'       => __( 'Add New Newsletter' ),
		'edit_item'          => __( 'Edit Newsletter' ),
		'new_item'           => __( 'New Newsletter' ),
		'all_items'          => __( 'All Newsletter' ),
		'view_item'          => __( 'View Newsletter' ),
		'search_items'       => __( 'Search Newsletter' ),
		'not_found'          => __( 'No records found' ),
		'not_found_in_trash' => __( 'No records found in the Trash' ), 
		'parent_item_colon'  => '',
		'menu_name'          => 'Newsletter'
	);
	$args = array(
		'labels'        => $labels,
		'description'   => 'Holds our products and product specific data',
		'public'        => true,
		'menu_position' => 5,
		'supports'      => array( 'title', 'editor', 'thumbnail', 'excerpt', 'comments' ),
		'has_archive'   => true,
	);
	register_post_type( 'newsletter', $args );	
}
add_action( 'init', 'cp_newsletter' );


// Long Story and Short Story
function story() {
 
	// Set UI labels for Custom Post Type
		$labels = array(
			'name'                => _x( 'Story', 'Post Type General Name'),
			'singular_name'       => _x( 'Story', 'Post Type Singular Name'),
			'menu_name'           => __( 'Story'),
			'parent_item_colon'   => __( 'Parent Movie'),
			'all_items'           => __( 'All Story'),
			'view_item'           => __( 'View Story'),
			'add_new_item'        => __( 'Add New Story'),
			'add_new'             => __( 'Add New'),
			'edit_item'           => __( 'Edit Story'),
			'update_item'         => __( 'Update Story'),
			'search_items'        => __( 'Search Story'),
			'not_found'           => __( 'Not Found'),
			'not_found_in_trash'  => __( 'Not found in Trash'),
		);
		 
	// Set other options for Custom Post Type
		 
		$args = array(
			'label'               => __( 'Story'),
			'description'         => __( 'Story'),
			'labels'              => $labels,
			'supports'            => array( 'title', 'editor', 'excerpt', 'author', 'thumbnail', 'comments', 'revisions', 'custom-fields', ),
			'hierarchical'        => false,
			'public'              => true,
			'show_ui'             => true,
			'show_in_menu'        => true,
			'show_in_nav_menus'   => true,
			'show_in_admin_bar'   => true,
			'menu_position'       => 5,
			'can_export'          => true,
			'has_archive'         => true,
			'exclude_from_search' => false,
			'publicly_queryable'  => true,
			'capability_type'     => 'page',
			'taxonomies'          => array( 'category' ),
		);
		// Registering your Custom Post Type
		register_post_type( 'story', $args );
	}
	 
	add_action( 'init', 'story', 0 );