<?php

/**
 * Class WDFMInsert
 */
class WDFMInsert {
  /**
   * PLUGIN = 2 points to Contact Form Maker
   */
  const PLUGIN = 1;

  public static function form_maker_insert() {
    global $wpdb;
    $charset_collate = $wpdb->get_charset_collate();
    $formmaker = "CREATE TABLE IF NOT EXISTS `" . $wpdb->prefix . "formmaker` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `title` varchar(127) NOT NULL,
    `type` varchar(100) NOT NULL,
    `mail` longtext NOT NULL,
    `form_front` longtext NOT NULL,
    `theme` int(11) NOT NULL,
    `javascript` text NOT NULL,
    `submit_text` longtext NOT NULL,
    `url` varchar(200) NOT NULL,
    `submit_text_type` tinyint(4) NOT NULL,
    `script_mail` text NOT NULL,
    `script_mail_user` text NOT NULL,
    `counter` int(11) NOT NULL,
    `published` int(11) NOT NULL DEFAULT '1',
    `label_order` longtext NOT NULL,
    `label_order_current` longtext NOT NULL,
    `article_id` varchar(500) NOT NULL,
    `pagination` varchar(128) NOT NULL,
    `show_title` varchar(128) NOT NULL,
    `show_numbers` varchar(128) NOT NULL,
    `public_key` varchar(50) NOT NULL,
    `private_key` varchar(50) NOT NULL,
    `recaptcha_theme` varchar(20) NOT NULL,
    `paypal_mode` int(2) NOT NULL,
    `checkout_mode` varchar(20) NOT NULL,
    `paypal_email` varchar(50) NOT NULL,
    `payment_currency` varchar(20) NOT NULL,
    `tax` float NOT NULL,
    `form_fields` longtext NOT NULL,
    `savedb` tinyint(4) NOT NULL DEFAULT '1',
    `sendemail` tinyint(4) NOT NULL DEFAULT '1',
    `requiredmark` varchar(20) NOT NULL DEFAULT '*',
    `from_mail` varchar(128) NOT NULL,
    `from_name` varchar(128) NOT NULL,
    `reply_to` varchar(128) NOT NULL,
    `send_to` varchar(128) NOT NULL,
    `autogen_layout` tinyint(4) NOT NULL DEFAULT '1',
    `custom_front` longtext NOT NULL,
    `mail_from_user` varchar(128) NOT NULL,
    `mail_from_name_user` varchar(128) NOT NULL,
    `reply_to_user` varchar(128) NOT NULL,
    `condition` text NOT NULL,
    `mail_cc` varchar(128) NOT NULL,
    `mail_cc_user` varchar(128) NOT NULL,
    `mail_bcc` varchar(128) NOT NULL,
    `mail_bcc_user` varchar(128) NOT NULL,
    `mail_subject` varchar(128) NOT NULL,
    `mail_subject_user` varchar(128) NOT NULL,
    `mail_mode` tinyint(4) NOT NULL DEFAULT '1',
    `mail_mode_user` tinyint(4) NOT NULL DEFAULT '1',
    `mail_attachment` tinyint(4) NOT NULL DEFAULT '1',
    `mail_attachment_user` tinyint(4) NOT NULL DEFAULT '1',
    `user_id_wd` varchar(220) NOT NULL,
    `sortable` int(11) NOT NULL,
    `frontend_submit_fields` text NOT NULL,
    `frontend_submit_stat_fields` text NOT NULL,
    `mail_emptyfields` tinyint(4) NOT NULL DEFAULT '0',
    `mail_verify` tinyint(4) NOT NULL DEFAULT '0',
    `mail_verify_expiretime` float NOT NULL,
    `mail_verification_post_id` int(11) NOT NULL,
    `save_uploads` tinyint(4) NOT NULL DEFAULT '1',
    `header_title` varchar(255) NOT NULL,
		`header_description` text NOT NULL,
		`header_image_url` varchar(255) NOT NULL,
		`header_image_animation` varchar(200) NOT NULL,
		`header_hide_image` tinyint(4) NOT NULL DEFAULT '1',
		`header_hide` tinyint(4) NOT NULL DEFAULT '1',
		`jsversion` int(11) NOT NULL,
		`privacy` longtext NOT NULL,
    PRIMARY KEY (`id`)
  ) " . $charset_collate . ";";
    $wpdb->query($formmaker);
    self::install_demo_forms();
    $formmaker_display_options = "CREATE TABLE IF NOT EXISTS `" . $wpdb->prefix . "formmaker_display_options` (
		`id` int(11) NOT NULL AUTO_INCREMENT,
		`form_id` int(11) NOT NULL UNIQUE,
		`type` varchar(100) NOT NULL,
		`popover_animate_effect` varchar(255) NOT NULL,
		`popover_loading_delay` int(11) NOT NULL,
		`popover_frequency` int(4) NOT NULL,
		`topbar_position` tinyint(4) NOT NULL,
		`topbar_remain_top` tinyint(4) NOT NULL,
		`topbar_closing` tinyint(4) NOT NULL,
		`topbar_hide_duration` int(4) NOT NULL,
		`scrollbox_position` tinyint(4) NOT NULL,
		`scrollbox_trigger_point` float NOT NULL,
		`scrollbox_hide_duration` int(4) NOT NULL,
		`scrollbox_auto_hide` tinyint(4) NOT NULL,
		`scrollbox_closing` tinyint(4) NOT NULL DEFAULT '1',
		`scrollbox_minimize` tinyint(4) NOT NULL,
		`scrollbox_minimize_text` varchar(300) NOT NULL,
		`display_on` text NOT NULL,
		`posts_include` text NOT NULL,
		`pages_include` text NOT NULL,
		`display_on_categories` text NOT NULL,
		`current_categories` text NOT NULL,
		`scrollbox_loading_delay` tinyint(4) NOT NULL,
		`hide_mobile` tinyint(4) NOT NULL DEFAULT '1',
		`show_for_admin` tinyint(4) NOT NULL DEFAULT '1',
		PRIMARY KEY (`id`)
	) " . $charset_collate . ";";
    $wpdb->query($formmaker_display_options);

    $formmaker_groups = "CREATE TABLE IF NOT EXISTS `" . $wpdb->prefix . "formmaker_groups` (
        `id` int(11) NOT NULL AUTO_INCREMENT,
        PRIMARY KEY (`id`)
      ) " . $charset_collate . ";";
    $wpdb->query($formmaker_groups);

    $formmaker_submits = "CREATE TABLE IF NOT EXISTS `" . $wpdb->prefix . "formmaker_submits` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `form_id` int(11) NOT NULL,
    `element_label` varchar(128) NOT NULL,
    `element_value` longtext NOT NULL,
    `group_id` int(11) NOT NULL,
    `date` datetime NOT NULL,
    `ip` varchar(128) NOT NULL,
    `user_id_wd` int(11) NOT NULL,
    PRIMARY KEY (`id`)
  ) " . $charset_collate . ";";
    $wpdb->query($formmaker_submits);

    $formmaker_themes = "CREATE TABLE IF NOT EXISTS `" . $wpdb->prefix . "formmaker_themes` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `title` varchar(200) NOT NULL,
    `css` text NOT NULL,
    `default` tinyint(4) NOT NULL,
    `version` tinyint(4) NOT NULL,
    PRIMARY KEY (`id`)
  ) " . $charset_collate . ";";
    $wpdb->query($formmaker_themes);

    $formmaker_blocked = "CREATE TABLE IF NOT EXISTS `" . $wpdb->prefix . "formmaker_blocked` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `ip` varchar(128) NOT NULL,
    PRIMARY KEY (`id`)
  ) " . $charset_collate . ";";
    $wpdb->query($formmaker_blocked);

    $form_maker_theme_row = $wpdb->get_var("SELECT * FROM " . $wpdb->prefix . "formmaker_themes");
    if (!$form_maker_theme_row) {
	  $default = json_encode(array('AGPWidth' => '70', 'AGPSPWidth' => '30', 'HPAlign' => 'top', 'HTPWidth' => '40', 'HPTextAlign' => 'center', 'HTPFontSize' => '24', 'HDPFontSize' => '15', 'HIPAlign' => 'top', 'HIPWidth' => '80', 'GPWidth' => '100', 'GTPWidth' => '60', 'SPAlign' => 'left', 'PSAPAlign' => 'right', 'PPAPWidth' => '100%', 'CBPPosition' => 'absolute', 'CBPTop' => '10px', 'CBPRight' => '10px', 'PSAPBGColor' =>'#7f7f7f', 'PSAPPadding' => '8px', 'PSDPBGColor' => '#999999', 'PSDPPadding' => '4px 6px', 'PSDPMargin' => '0 0 10px 0', 'FPMargin' => '15px 0 0 0', 'IPHeight' =>'40', 'IPFontSize' => '16', 'IPPadding' => '6px 10px', 'IPBorderTop' => 'top', 'IPBorderRight' => 'right', 'IPBorderBottom' => 'bottom', 'IPBorderLeft' => 'left', 'IPBorderColor' => '#dfdfdf', 'IPBorderType' => 'solid', 'IPBorderWidth' => '1', 'IPBorderRadius' => '2', 'GPMLFontSize' => '12', 'GPMLFontWeight' => 'normal', 'OPRColor' => '' ));
      $wpdb->query('INSERT INTO `' . $wpdb->prefix . 'formmaker_themes` (`title`, `css`, `default`, `version`) VALUES ("Default Theme", \'' . $default .'\', 1, 2);');
      $wpdb->query('INSERT INTO `' . $wpdb->prefix . 'formmaker_themes` (`title`, `css`, `default`, `version`) VALUES ("Theme 1", \'{"GPFontFamily":"tahoma","AGPWidth":"100","AGPSPWidth":"30","AGPPadding":"","AGPMargin":"10px auto","AGPBorderColor":"#ffffff","AGPBorderType":"solid","AGPBorderWidth":"1","AGPBorderRadius":"0","AGPBoxShadow":"","HPAlign":"top","HPBGColor":"#96afab","HPWidth":"100","HTPWidth":"40","HPPadding":"10px 0","HPMargin":"","HPTextAlign":"center","HPBorderColor":"#b7b7b7","HPBorderType":"solid","HPBorderWidth":"1","HPBorderRadius":"0","HTPFontSize":"24","HTPWeight":"normal","HTPColor":"#ffffff","HDPFontSize":"15","HDPColor":"#607370","HIPAlign":"top","HIPWidth":"80","HIPHeight":"","GPBGColor":"","GPFontSize":"16","GPFontWeight":"normal","GPWidth":"100","GTPWidth":"60","GPAlign":"center","GPBackground":"","GPBackgroundRepeat":"no-repeat","GPBGPosition1":"","GPBGPosition2":"","GPBGSize1":"","GPBGSize2":"","GPColor":"#607370","GPPadding":"10px","GPMargin":"","GPBorderColor":"#ffffff","GPBorderType":"solid","GPBorderWidth":"1","GPBorderRadius":"0","GPMLFontSize":"14","GPMLFontWeight":"normal","GPMLColor":"#868686","GPMLPadding":"0px 5px 0px 0px","GPMLMargin":"0px","SEPBGColor":"","SEPPadding":"","SEPMargin":"","COPPadding":"15px 20px","COPMargin":"0px","FPWidth":"70","FPPadding":"15px 0 0 0","FPMargin":"0 auto","IPHeight":"40","IPFontSize":"14","IPFontWeight":"normal","IPBGColor":"#ffffff","IPColor":"#868686","IPPadding":"6px 10px","IPMargin":"0","IPBorderTop":"top","IPBorderRight":"right","IPBorderBottom":"bottom","IPBorderLeft":"left","IPBorderColor":"#dfdfdf","IPBorderType":"solid","IPBorderWidth":"1","IPBorderRadius":"0","IPBoxShadow":"","SBPAppearance":"none","SBPBackground":"images/themes/drop-downs/2.png","SBPBGRepeat":"no-repeat","SBPBGPos1":"95%","SBPBGPos2":"50%","SBPBGSize1":"8%","SBPBGSize2":"32%","SCPBGColor":"#ffffff","SCPWidth":"16","SCPHeight":"16","SCPBorderTop":"top","SCPBorderRight":"right","SCPBorderBottom":"bottom","SCPBorderLeft":"left","SCPBorderColor":"#868686","SCPBorderType":"solid","SCPBorderWidth":"1","SCPMargin":"0px 3px","SCPBorderRadius":"15","SCPBoxShadow":"","SCCPBGColor":"#868686","SCCPWidth":"6","SCCPHeight":"6","SCCPMargin":"5","SCCPBorderRadius":"10","MCPBGColor":"#ffffff","MCPWidth":"16","MCPHeight":"16","MCPBorderTop":"top","MCPBorderRight":"right","MCPBorderBottom":"bottom","MCPBorderLeft":"left","MCPBorderColor":"#868686","MCPBorderType":"solid","MCPBorderWidth":"1","MCPMargin":"0px 3px","MCPBorderRadius":"0","MCPBoxShadow":"","MCCPBGColor":"","MCCPBackground":"images/themes/checkboxes/1.png","MCCPBGRepeat":"no-repeat","MCCPBGPos1":"","MCCPBGPos2":"","MCCPWidth":"16","MCCPHeight":"16","MCCPMargin":"0","MCCPBorderRadius":"0","SPAlign":"left","SPBGColor":"#e74c3c","SPWidth":"","SPHeight":"","SPFontSize":"16","SPFontWeight":"normal","SPColor":"#ffffff","SPPadding":"5px 8px","SPMargin":"0 15px 0 0","SPBorderTop":"top","SPBorderRight":"right","SPBorderBottom":"bottom","SPBorderLeft":"left","SPBorderColor":"#e74c3c","SPBorderType":"solid","SPBorderWidth":"1","SPBorderRadius":"0","SPBoxShadow":"","SHPBGColor":"#701e16","SHPColor":"#ffffff","SHPBorderTop":"top","SHPBorderRight":"right","SHPBorderBottom":"bottom","SHPBorderLeft":"left","SHPBorderColor":"#701e16","SHPBorderType":"solid","SHPBorderWidth":"1","BPBGColor":"#96afab","BPWidth":"","BPHeight":"","BPFontSize":"16","BPFontWeight":"normal","BPColor":"#ffffff","BPPadding":"5px 8px","BPMargin":"0 15px 0 0","BPBorderTop":"top","BPBorderRight":"right","BPBorderBottom":"bottom","BPBorderLeft":"left","BPBorderColor":"#8a8a8a","BPBorderType":"solid","BPBorderWidth":"1","BPBorderRadius":"0","BPBoxShadow":"","BHPBGColor":"#5a7784","BHPColor":"#ffffff","BHPBorderTop":"top","BHPBorderRight":"right","BHPBorderBottom":"bottom","BHPBorderLeft":"left","BHPBorderColor":"#5a7784","BHPBorderType":"solid","BHPBorderWidth":"1","PSAPBGColor":"#e74c3c","PSAPFontSize":"16","PSAPFontWeight":"normal","PSAPColor":"#ffffff","PSAPHeight":"","PSAPLineHeight":"","PSAPPadding":"6px","PSAPMargin":"0 1px 0 0 ","PSAPBorderTop":"top","PSAPBorderRight":"right","PSAPBorderBottom":"bottom","PSAPBorderLeft":"left","PSAPBorderColor":"#e74c3c","PSAPBorderType":"solid","PSAPBorderWidth":"2","PSAPBorderRadius":"0","PSDPBGColor":"#ededed","PSDPFontSize":"14","PSDPFontWeight":"normal","PSDPColor":"#737373","PSDPHeight":"","PSDPLineHeight":"","PSDPPadding":"3px 5px","PSDPMargin":"0 1px 0 0 ","PSDPBorderTop":"top","PSDPBorderRight":"right","PSDPBorderBottom":"bottom","PSDPBorderLeft":"left","PSDPBorderColor":"#ededed","PSDPBorderType":"solid","PSDPBorderWidth":"2","PSDPBorderRadius":"0","PSAPAlign":"right","PSAPWidth":"","PPAPWidth":"100%","NBPBGColor":"","NBPWidth":"","NBPHeight":"","NBPLineHeight":"","NBPColor":"#607370","NBPPadding":"4px 10px","NBPMargin":"0px","NBPBorderColor":"#777777","NBPBorderType":"solid","NBPBorderWidth":"1","NBPBorderRadius":"0","NBPBoxShadow":"","NBHPBGColor":"","NBHPColor":"#96afab","NBHPBorderColor":"#787878","NBHPBorderType":"solid","NBHPBorderWidth":"1","PBPBGColor":"","PBPWidth":"100","PBPHeight":"","PBPLineHeight":"","PBPColor":"#607370","PBPPadding":"","PBPMargin":"0px","PBPBorderColor":"#777777","PBPBorderType":"solid","PBPBorderWidth":"1","PBPBorderRadius":"0","PBPBoxShadow":"","PBHPBGColor":"","PBHPColor":"#96afab","PBHPBorderColor":"#787878","PBHPBorderType":"solid","PBHPBorderWidth":"1","CBPPosition":"absolute","CBPTop":"10px","CBPRight":"10px","CBPBottom":"","CBPLeft":"","CBPBGColor":"","CBPFontSize":"20","CBPFontWeight":"normal","CBPColor":"#777777","CBPPadding":"0px","CBPMargin":"0px","CBPBorderColor":"#ffffff","CBPBorderType":"solid","CBPBorderWidth":"1","CBPBorderRadius":"0","CBHPBGColor":"","CBHPColor":"#e74c3c","CBHPBorderColor":"#737373","CBHPBorderType":"solid","CBHPBorderWidth":"1","MBPBGColor":"#96afab","MBPFontSize":"17","MBPFontWeight":"normal","MBPColor":"#ffffff","MBPTextAlign":"center","MBPPadding":"10px","MBPMargin":"","MBPBorderTop":"top","MBPBorderRight":"right","MBPBorderBottom":"bottom","MBPBorderLeft":"left","MBPBorderColor":"#96afab","MBPBorderType":"solid","MBPBorderWidth":"2","MBPBorderRadius":"0","MBHPBGColor":"#96afab","MBHPColor":"#607370","MBHPBorderTop":"top","MBHPBorderRight":"right","MBHPBorderBottom":"bottom","MBHPBorderLeft":"left","MBHPBorderColor":"#96afab","MBHPBorderType":"solid","MBHPBorderWidth":"2","OPDeInputColor":"#afafaf","OPFontStyle":"normal","OPRColor":"#ff1313","OPDPIcon":"images/themes/date-pickers/2.png","OPDPRepeat":"no-repeat","OPDPPos1":"0%","OPDPPos2":"10%","OPDPMargin":"3px 0 0 -23px","OPFBgUrl":"images/themes/file-uploads/2.png","OPFBGRepeat":"no-repeat","OPFPos1":"0%","OPFPos2":"10%","OPGWidth":"100","CUPCSS":""}\', 0, 2);');
      $wpdb->query('INSERT INTO `' . $wpdb->prefix . 'formmaker_themes` (`title`, `css`, `default`, `version`) VALUES ("Theme 2", \'{"GPFontFamily":"Roboto Condensed","AGPWidth":"100","AGPSPWidth":"30","AGPPadding":"","AGPMargin":"10px auto","AGPBorderColor":"#ffffff","AGPBorderType":"solid","AGPBorderWidth":"1","AGPBorderRadius":"0","AGPBoxShadow":"","HPAlign":"top","HPBGColor":"#16afbf","HPWidth":"100","HTPWidth":"40","HPPadding":"10px 10px","HPMargin":"","HPTextAlign":"center","HPBorderColor":"#b7b7b7","HPBorderType":"solid","HPBorderWidth":"1","HPBorderRadius":"0","HTPFontSize":"25","HTPWeight":"","HTPColor":"#ffffff","HDPFontSize":"16","HDPColor":"#387185","HIPAlign":"top","HIPWidth":"80","HIPHeight":"","GPBGColor":"#ededed","GPFontSize":"16","GPFontWeight":"normal","GPWidth":"100","GTPWidth":"60","GPAlign":"center","GPBackground":"","GPBackgroundRepeat":"no-repeat","GPBGPosition1":"","GPBGPosition2":"","GPBGSize1":"","GPBGSize2":"","GPColor":"#387185","GPPadding":"10px","GPMargin":"","GPBorderColor":"#ffffff","GPBorderType":"solid","GPBorderWidth":"1","GPBorderRadius":"0","GPMLFontSize":"14","GPMLFontWeight":"normal","GPMLColor":"#777777","GPMLPadding":"0px 5px 0px 0px","GPMLMargin":"0px","SEPBGColor":"#ededed","SEPPadding":"","SEPMargin":"","COPPadding":"10px","COPMargin":"0px","FPWidth":"70","FPPadding":"15px 0 0 0","FPMargin":"0 auto","IPHeight":"40","IPFontSize":"16","IPFontWeight":"normal","IPBGColor":"#ffffff","IPColor":"#777777","IPPadding":"5px 5px","IPMargin":"0px","IPBorderTop":"top","IPBorderRight":"right","IPBorderBottom":"bottom","IPBorderLeft":"left","IPBorderColor":"#dfdfdf","IPBorderType":"solid","IPBorderWidth":"1","IPBorderRadius":"0","IPBoxShadow":"","SBPAppearance":"none","SBPBackground":"images/themes/drop-downs/2.png","SBPBGRepeat":"no-repeat","SBPBGPos1":"95%","SBPBGPos2":"50%","SBPBGSize1":"8%","SBPBGSize2":"32%","SCPBGColor":"#ffffff","SCPWidth":"16","SCPHeight":"16","SCPBorderTop":"top","SCPBorderRight":"right","SCPBorderBottom":"bottom","SCPBorderLeft":"left","SCPBorderColor":"#777777","SCPBorderType":"solid","SCPBorderWidth":"1","SCPMargin":"0px 3px","SCPBorderRadius":"15","SCPBoxShadow":"","SCCPBGColor":"#777777","SCCPWidth":"6","SCCPHeight":"6","SCCPMargin":"5","SCCPBorderRadius":"10","MCPBGColor":"#ffffff","MCPWidth":"16","MCPHeight":"16","MCPBorderTop":"top","MCPBorderRight":"right","MCPBorderBottom":"bottom","MCPBorderLeft":"left","MCPBorderColor":"#777777","MCPBorderType":"solid","MCPBorderWidth":"1","MCPMargin":"0px 3px","MCPBorderRadius":"0","MCPBoxShadow":"","MCCPBGColor":"","MCCPBackground":"images/themes/checkboxes/1.png","MCCPBGRepeat":"no-repeat","MCCPBGPos1":"","MCCPBGPos2":"","MCCPWidth":"16","MCCPHeight":"16","MCCPMargin":"0","MCCPBorderRadius":"0","SPAlign":"right","SPBGColor":"#a3aa44","SPWidth":"","SPHeight":"","SPFontSize":"16","SPFontWeight":"normal","SPColor":"#ffffff","SPPadding":"8px 8px","SPMargin":"0 5px 0 0 ","SPBorderTop":"top","SPBorderRight":"right","SPBorderBottom":"bottom","SPBorderLeft":"left","SPBorderColor":"#a3aa44","SPBorderType":"solid","SPBorderWidth":"1","SPBorderRadius":"0","SPBoxShadow":"1px 1px 2px #ccc","SHPBGColor":"#c2d852","SHPColor":"#445d71","SHPBorderTop":"top","SHPBorderRight":"right","SHPBorderBottom":"bottom","SHPBorderLeft":"left","SHPBorderColor":"#c2d852","SHPBorderType":"solid","SHPBorderWidth":"1","BPBGColor":"#16afbf","BPWidth":"","BPHeight":"","BPFontSize":"16","BPFontWeight":"normal","BPColor":"#ffffff","BPPadding":"8px 8px","BPMargin":"0 15px 0 0 ","BPBorderTop":"top","BPBorderRight":"right","BPBorderBottom":"bottom","BPBorderLeft":"left","BPBorderColor":"#16afbf","BPBorderType":"solid","BPBorderWidth":"1","BPBorderRadius":"0","BPBoxShadow":"1px 1px 2px #ccc","BHPBGColor":"#435c71","BHPColor":"#ffffff","BHPBorderTop":"top","BHPBorderRight":"right","BHPBorderBottom":"bottom","BHPBorderLeft":"left","BHPBorderColor":"#435c71","BHPBorderType":"solid","BHPBorderWidth":"1","PSAPBGColor":"#a3aa44","PSAPFontSize":"16","PSAPFontWeight":"normal","PSAPColor":"#ffffff","PSAPHeight":"","PSAPLineHeight":"","PSAPPadding":"8px","PSAPMargin":"0 0 4px 0 ","PSAPBorderTop":"top","PSAPBorderRight":"right","PSAPBorderBottom":"bottom","PSAPBorderLeft":"left","PSAPBorderColor":"#a3aa44","PSAPBorderType":"solid","PSAPBorderWidth":"2","PSAPBorderRadius":"3","PSDPBGColor":"#16afbf","PSDPFontSize":"16","PSDPFontWeight":"normal","PSDPColor":"#ffffff","PSDPHeight":"","PSDPLineHeight":"","PSDPPadding":"4px 6px","PSDPMargin":"0 0 0 -3px","PSDPBorderTop":"top","PSDPBorderRight":"right","PSDPBorderBottom":"bottom","PSDPBorderLeft":"left","PSDPBorderColor":"#16afbf","PSDPBorderType":"solid","PSDPBorderWidth":"2","PSDPBorderRadius":"3","PSAPAlign":"right","PSAPWidth":"","PPAPWidth":"100%","NBPBGColor":"","NBPWidth":"","NBPHeight":"","NBPLineHeight":"","NBPColor":"#16afbf","NBPPadding":"4px 10px","NBPMargin":"0px","NBPBorderColor":"#777777","NBPBorderType":"solid","NBPBorderWidth":"1","NBPBorderRadius":"0","NBPBoxShadow":"","NBHPBGColor":"","NBHPColor":"#387185","NBHPBorderColor":"#787878","NBHPBorderType":"solid","NBHPBorderWidth":"1","PBPBGColor":"","PBPWidth":"100","PBPHeight":"","PBPLineHeight":"","PBPColor":"#9c9c9c","PBPPadding":"","PBPMargin":"0px","PBPBorderColor":"#777777","PBPBorderType":"solid","PBPBorderWidth":"1","PBPBorderRadius":"0","PBPBoxShadow":"","PBHPBGColor":"","PBHPColor":"#2d4d5f","PBHPBorderColor":"#787878","PBHPBorderType":"solid","PBHPBorderWidth":"1","CBPPosition":"absolute","CBPTop":"10px","CBPRight":"10px","CBPBottom":"","CBPLeft":"","CBPBGColor":"","CBPFontSize":"22","CBPFontWeight":"normal","CBPColor":"#387185","CBPPadding":"0px","CBPMargin":"0px","CBPBorderColor":"#ffffff","CBPBorderType":"solid","CBPBorderWidth":"1","CBPBorderRadius":"0","CBHPBGColor":"","CBHPColor":"#a3aa44","CBHPBorderColor":"#737373","CBHPBorderType":"solid","CBHPBorderWidth":"1","MBPBGColor":"#16afbf","MBPFontSize":"17","MBPFontWeight":"normal","MBPColor":"#ffffff","MBPTextAlign":"center","MBPPadding":"10px","MBPMargin":"","MBPBorderTop":"top","MBPBorderRight":"right","MBPBorderBottom":"bottom","MBPBorderLeft":"left","MBPBorderColor":"#387185","MBPBorderType":"solid","MBPBorderWidth":"2","MBPBorderRadius":"0","MBHPBGColor":"#ffffff","MBHPColor":"#16afbf","MBHPBorderTop":"top","MBHPBorderRight":"right","MBHPBorderBottom":"bottom","MBHPBorderLeft":"left","MBHPBorderColor":"#387185","MBHPBorderType":"solid","MBHPBorderWidth":"2","OPDeInputColor":"#afafaf","OPFontStyle":"normal","OPRColor":"#ff1313","OPDPIcon":"images/themes/date-pickers/2.png","OPDPRepeat":"no-repeat","OPDPPos1":"0%","OPDPPos2":"10%","OPDPMargin":"3px 0 0 -23px","OPFBgUrl":"images/themes/file-uploads/2.png","OPFBGRepeat":"no-repeat","OPFPos1":"0%","OPFPos2":"10%","OPGWidth":"100","CUPCSS":""}\', 0, 2);');
      $wpdb->query('INSERT INTO `' . $wpdb->prefix . 'formmaker_themes` (`title`, `css`, `default`, `version`) VALUES ("Theme 3", \'{"GPFontFamily":"Droid Sans","AGPWidth":"80","AGPSPWidth":"30","AGPPadding":"","AGPMargin":"10px auto","AGPBorderColor":"#ffffff","AGPBorderType":"solid","AGPBorderWidth":"1","AGPBorderRadius":"0","AGPBoxShadow":"","HPAlign":"top","HPBGColor":"#b7b7b7","HPWidth":"100","HTPWidth":"35","HPPadding":"10px 13px 25px","HPMargin":"","HPTextAlign":"center","HPBorderColor":"#b7b7b7","HPBorderType":"solid","HPBorderWidth":"1","HPBorderRadius":"0","HTPFontSize":"25","HTPWeight":"","HTPColor":"#ffffff","HDPFontSize":"16","HDPColor":"#354f5d","HIPAlign":"top","HIPWidth":"80","HIPHeight":"","GPBGColor":"#ededed","GPFontSize":"16","GPFontWeight":"normal","GPWidth":"100","GTPWidth":"65","GPAlign":"center","GPBackground":"","GPBackgroundRepeat":"no-repeat","GPBGPosition1":"","GPBGPosition2":"","GPBGSize1":"","GPBGSize2":"","GPColor":"#627781","GPPadding":"10px","GPMargin":"-25px 0 0 ","GPBorderColor":"#ffffff","GPBorderType":"solid","GPBorderWidth":"1","GPBorderRadius":"0","GPMLFontSize":"14","GPMLFontWeight":"normal","GPMLColor":"#627781","GPMLPadding":"0px 5px 0px 0px","GPMLMargin":"0px","SEPBGColor":"#f3f3f3","SEPPadding":"10px 15px","SEPMargin":"","COPPadding":"10px","COPMargin":"0px","FPWidth":"70","FPPadding":"15px 0 0 0","FPMargin":"0 auto","IPHeight":"40","IPFontSize":"16","IPFontWeight":"normal","IPBGColor":"#ffffff","IPColor":"#627781","IPPadding":"0px 5px","IPMargin":"0px","IPBorderTop":"top","IPBorderRight":"right","IPBorderBottom":"bottom","IPBorderLeft":"left","IPBorderColor":"#dfdfdf","IPBorderType":"solid","IPBorderWidth":"1","IPBorderRadius":"0","IPBoxShadow":"","SBPAppearance":"none","SBPBackground":"images/themes/drop-downs/2.png","SBPBGRepeat":"no-repeat","SBPBGPos1":"95%","SBPBGPos2":"50%","SBPBGSize1":"8%","SBPBGSize2":"32%","SCPBGColor":"#ffffff","SCPWidth":"16","SCPHeight":"16","SCPBorderTop":"top","SCPBorderRight":"right","SCPBorderBottom":"bottom","SCPBorderLeft":"left","SCPBorderColor":"#627781","SCPBorderType":"solid","SCPBorderWidth":"1","SCPMargin":"0px 3px","SCPBorderRadius":"15","SCPBoxShadow":"","SCCPBGColor":"#777777","SCCPWidth":"6","SCCPHeight":"6","SCCPMargin":"5","SCCPBorderRadius":"10","MCPBGColor":"#ffffff","MCPWidth":"16","MCPHeight":"16","MCPBorderTop":"top","MCPBorderRight":"right","MCPBorderBottom":"bottom","MCPBorderLeft":"left","MCPBorderColor":"#627781","MCPBorderType":"solid","MCPBorderWidth":"1","MCPMargin":"0px 3px","MCPBorderRadius":"0","MCPBoxShadow":"","MCCPBGColor":"","MCCPBackground":"images/themes/checkboxes/1.png","MCCPBGRepeat":"no-repeat","MCCPBGPos1":"","MCCPBGPos2":"","MCCPWidth":"16","MCCPHeight":"16","MCCPMargin":"0","MCCPBorderRadius":"0","SPAlign":"left","SPBGColor":"#676767","SPWidth":"","SPHeight":"40","SPFontSize":"16","SPFontWeight":"normal","SPColor":"#ffffff","SPPadding":"5px 8px","SPMargin":"0px","SPBorderTop":"top","SPBorderRight":"right","SPBorderBottom":"bottom","SPBorderLeft":"left","SPBorderColor":"#676767","SPBorderType":"solid","SPBorderWidth":"1","SPBorderRadius":"0","SPBoxShadow":"1px 1px 2px #ccc","SHPBGColor":"#ededed","SHPColor":"#676767","SHPBorderTop":"top","SHPBorderRight":"right","SHPBorderBottom":"bottom","SHPBorderLeft":"left","SHPBorderColor":"#676767","SHPBorderType":"solid","SHPBorderWidth":"1","BPBGColor":"#f3f3f3","BPWidth":"","BPHeight":"","BPFontSize":"14","BPFontWeight":"normal","BPColor":"#777777","BPPadding":"5px 8px","BPMargin":"0px","BPBorderTop":"top","BPBorderRight":"right","BPBorderBottom":"bottom","BPBorderLeft":"left","BPBorderColor":"#ededed","BPBorderType":"solid","BPBorderWidth":"1","BPBorderRadius":"0","BPBoxShadow":"1px 1px 2px #ccc","BHPBGColor":"#ededed","BHPColor":"#777777","BHPBorderTop":"top","BHPBorderRight":"right","BHPBorderBottom":"bottom","BHPBorderLeft":"left","BHPBorderColor":"#ededed","BHPBorderType":"solid","BHPBorderWidth":"1","PSAPBGColor":"#354f5d","PSAPFontSize":"16","PSAPFontWeight":"normal","PSAPColor":"#ffffff","PSAPHeight":"","PSAPLineHeight":"","PSAPPadding":"8px","PSAPMargin":"0 0 4px 0 ","PSAPBorderTop":"top","PSAPBorderRight":"right","PSAPBorderBottom":"bottom","PSAPBorderLeft":"left","PSAPBorderColor":"#354f5d","PSAPBorderType":"solid","PSAPBorderWidth":"2","PSAPBorderRadius":"3","PSDPBGColor":"#b7b7b7","PSDPFontSize":"16","PSDPFontWeight":"normal","PSDPColor":"#ffffff","PSDPHeight":"","PSDPLineHeight":"","PSDPPadding":"4px 6px","PSDPMargin":"0 0 0 -3px","PSDPBorderTop":"top","PSDPBorderRight":"right","PSDPBorderBottom":"bottom","PSDPBorderLeft":"left","PSDPBorderColor":"#b7b7b7","PSDPBorderType":"solid","PSDPBorderWidth":"2","PSDPBorderRadius":"3","PSAPAlign":"right","PSAPWidth":"","PPAPWidth":"100%","NBPBGColor":"","NBPWidth":"","NBPHeight":"","NBPLineHeight":"","NBPColor":"#838383","NBPPadding":"4px 10px","NBPMargin":"0px","NBPBorderColor":"#777777","NBPBorderType":"solid","NBPBorderWidth":"1","NBPBorderRadius":"0","NBPBoxShadow":"","NBHPBGColor":"","NBHPColor":"#387185","NBHPBorderColor":"#787878","NBHPBorderType":"solid","NBHPBorderWidth":"1","PBPBGColor":"","PBPWidth":"100","PBPHeight":"","PBPLineHeight":"","PBPColor":"#9c9c9c","PBPPadding":"","PBPMargin":"0px","PBPBorderColor":"#777777","PBPBorderType":"solid","PBPBorderWidth":"1","PBPBorderRadius":"0","PBPBoxShadow":"","PBHPBGColor":"","PBHPColor":"#2d4d5f","PBHPBorderColor":"#787878","PBHPBorderType":"solid","PBHPBorderWidth":"1","CBPPosition":"absolute","CBPTop":"10px","CBPRight":"20px","CBPBottom":"","CBPLeft":"","CBPBGColor":"","CBPFontSize":"18","CBPFontWeight":"normal","CBPColor":"#838383","CBPPadding":"3px 5px","CBPMargin":"0px","CBPBorderColor":"","CBPBorderType":"solid","CBPBorderWidth":"1","CBPBorderRadius":"30","CBHPBGColor":"","CBHPColor":"#ffffff","CBHPBorderColor":"#737373","CBHPBorderType":"solid","CBHPBorderWidth":"1","MBPBGColor":"#f3f3f3","MBPFontSize":"17","MBPFontWeight":"normal","MBPColor":"#354f5d","MBPTextAlign":"center","MBPPadding":"10px","MBPMargin":"","MBPBorderTop":"top","MBPBorderRight":"right","MBPBorderBottom":"bottom","MBPBorderLeft":"left","MBPBorderColor":"#354f5d","MBPBorderType":"solid","MBPBorderWidth":"2","MBPBorderRadius":"0","MBHPBGColor":"#b7b7b7","MBHPColor":"#354f5d","MBHPBorderTop":"top","MBHPBorderRight":"right","MBHPBorderBottom":"bottom","MBHPBorderLeft":"left","MBHPBorderColor":"#354f5d","MBHPBorderType":"solid","MBHPBorderWidth":"2","OPDeInputColor":"#afafaf","OPFontStyle":"normal","OPRColor":"#ff1313","OPDPIcon":"images/themes/date-pickers/2.png","OPDPRepeat":"no-repeat","OPDPPos1":"0%","OPDPPos2":"10%","OPDPMargin":"3px 0 0 -23px","OPFBgUrl":"images/themes/file-uploads/2.png","OPFBGRepeat":"no-repeat","OPFPos1":"0%","OPFPos2":"10%","OPGWidth":"100","CUPCSS":""}\', 0, 2);');
      $wpdb->query('INSERT INTO `' . $wpdb->prefix . 'formmaker_themes` (`title`, `css`, `default`, `version`) VALUES ("Theme 4", \'{"GPFontFamily":"Patrick Hand","AGPWidth":"100","AGPSPWidth":"30","AGPPadding":"","AGPMargin":"10px auto","AGPBorderTop":"top","AGPBorderRight":"right","AGPBorderBottom":"bottom","AGPBorderLeft":"left","AGPBorderColor":"#606060","AGPBorderType":"solid","AGPBorderWidth":"1","AGPBorderRadius":"0","AGPBoxShadow":"","HPAlign":"top","HPBGColor":"#ffffff","HPWidth":"100","HTPWidth":"30","HPPadding":"10px","HPMargin":"","HPTextAlign":"center","HPBorderColor":"#b7b7b7","HPBorderType":"solid","HPBorderWidth":"1","HPBorderRadius":"0","HTPFontSize":"26","HTPWeight":"","HTPColor":"#930912","HDPFontSize":"17","HDPColor":"#666666","HIPAlign":"left","HIPWidth":"80","HIPHeight":"","GPBGColor":"#d8d8d8","GPFontSize":"16","GPFontWeight":"bold","GPWidth":"100","GTPWidth":"70","GPAlign":"center","GPBackground":"","GPBackgroundRepeat":"no-repeat","GPBGPosition1":"","GPBGPosition2":"","GPBGSize1":"","GPBGSize2":"","GPColor":"#2d4d5f","GPPadding":"10px","GPMargin":"","GPBorderColor":"#ffffff","GPBorderType":"solid","GPBorderWidth":"1","GPBorderRadius":"0","GPMLFontSize":"14","GPMLFontWeight":"normal","GPMLColor":"#2d4d5f","GPMLPadding":"0px 5px 0px 0px","GPMLMargin":"0px","SEPBGColor":"#d8d8d8","SEPPadding":"","SEPMargin":"","COPPadding":"10px","COPMargin":"0px","FPWidth":"70","FPPadding":"15px 0 0 0","FPMargin":"0 auto","IPHeight":"30","IPFontSize":"14","IPFontWeight":"normal","IPBGColor":"#ffffff","IPColor":"#9c9c9c","IPPadding":"0px 5px","IPMargin":"0px","IPBorderTop":"top","IPBorderRight":"right","IPBorderBottom":"bottom","IPBorderLeft":"left","IPBorderColor":"#dfdfdf","IPBorderType":"solid","IPBorderWidth":"1","IPBorderRadius":"0","IPBoxShadow":"","SBPAppearance":"none","SBPBackground":"images/themes/drop-downs/2.png","SBPBGRepeat":"no-repeat","SBPBGPos1":"95%","SBPBGPos2":"50%","SBPBGSize1":"8%","SBPBGSize2":"32%","SCPBGColor":"#ffffff","SCPWidth":"16","SCPHeight":"16","SCPBorderTop":"top","SCPBorderRight":"right","SCPBorderBottom":"bottom","SCPBorderLeft":"left","SCPBorderColor":"#777777","SCPBorderType":"solid","SCPBorderWidth":"1","SCPMargin":"0px 3px","SCPBorderRadius":"15","SCPBoxShadow":"","SCCPBGColor":"#777777","SCCPWidth":"6","SCCPHeight":"6","SCCPMargin":"5","SCCPBorderRadius":"10","MCPBGColor":"#ffffff","MCPWidth":"16","MCPHeight":"16","MCPBorderTop":"top","MCPBorderRight":"right","MCPBorderBottom":"bottom","MCPBorderLeft":"left","MCPBorderColor":"#777777","MCPBorderType":"solid","MCPBorderWidth":"1","MCPMargin":"0px 3px","MCPBorderRadius":"0","MCPBoxShadow":"","MCCPBGColor":"","MCCPBackground":"images/themes/checkboxes/1.png","MCCPBGRepeat":"no-repeat","MCCPBGPos1":"","MCCPBGPos2":"","MCCPWidth":"16","MCCPHeight":"16","MCCPMargin":"0","MCCPBorderRadius":"0","SPAlign":"right","SPBGColor":"#930912","SPWidth":"","SPHeight":"","SPFontSize":"16","SPFontWeight":"normal","SPColor":"#e8e8e8","SPPadding":"5px 8px","SPMargin":"0 15px 0 0","SPBorderTop":"top","SPBorderRight":"right","SPBorderBottom":"bottom","SPBorderLeft":"left","SPBorderColor":"#930912","SPBorderType":"solid","SPBorderWidth":"1","SPBorderRadius":"0","SPBoxShadow":"1px 1px 2px #ccc","SHPBGColor":"#51030b","SHPColor":"#ffffff","SHPBorderTop":"top","SHPBorderRight":"right","SHPBorderBottom":"bottom","SHPBorderLeft":"left","SHPBorderColor":"#51030b","SHPBorderType":"solid","SHPBorderWidth":"1","BPBGColor":"#666666","BPWidth":"","BPHeight":"","BPFontSize":"16","BPFontWeight":"normal","BPColor":"#ffffff","BPPadding":"5px 8px","BPMargin":"0 15px 0 0","BPBorderTop":"top","BPBorderRight":"right","BPBorderBottom":"bottom","BPBorderLeft":"left","BPBorderColor":"#666666","BPBorderType":"solid","BPBorderWidth":"1","BPBorderRadius":"0","BPBoxShadow":"1px 1px 2px #ccc","BHPBGColor":"#2d4d5f","BHPColor":"#ffffff","BHPBorderTop":"top","BHPBorderRight":"right","BHPBorderBottom":"bottom","BHPBorderLeft":"left","BHPBorderColor":"#2d4d5f","BHPBorderType":"solid","BHPBorderWidth":"1","PSAPBGColor":"#930912","PSAPFontSize":"16","PSAPFontWeight":"normal","PSAPColor":"#ffffff","PSAPHeight":"","PSAPLineHeight":"","PSAPPadding":"8px","PSAPMargin":"0 0 4px 0 ","PSAPBorderTop":"top","PSAPBorderRight":"right","PSAPBorderBottom":"bottom","PSAPBorderLeft":"left","PSAPBorderColor":"#930912","PSAPBorderType":"solid","PSAPBorderWidth":"2","PSAPBorderRadius":"3","PSDPBGColor":"#2d4d5f","PSDPFontSize":"16","PSDPFontWeight":"normal","PSDPColor":"#ffffff","PSDPHeight":"","PSDPLineHeight":"","PSDPPadding":"4px 6px","PSDPMargin":"0 0 0 -3px","PSDPBorderTop":"top","PSDPBorderRight":"right","PSDPBorderBottom":"bottom","PSDPBorderLeft":"left","PSDPBorderColor":"#2d4d5f","PSDPBorderType":"solid","PSDPBorderWidth":"2","PSDPBorderRadius":"3","PSAPAlign":"right","PSAPWidth":"","PPAPWidth":"100%","NBPBGColor":"","NBPWidth":"","NBPHeight":"","NBPLineHeight":"","NBPColor":"#666666","NBPPadding":"4px 10px","NBPMargin":"0px","NBPBorderColor":"#777777","NBPBorderType":"solid","NBPBorderWidth":"1","NBPBorderRadius":"0","NBPBoxShadow":"","NBHPBGColor":"","NBHPColor":"#930912","NBHPBorderColor":"#787878","NBHPBorderType":"solid","NBHPBorderWidth":"1","PBPBGColor":"","PBPWidth":"100","PBPHeight":"","PBPLineHeight":"","PBPColor":"#666666","PBPPadding":"","PBPMargin":"0px","PBPBorderColor":"#777777","PBPBorderType":"solid","PBPBorderWidth":"1","PBPBorderRadius":"0","PBPBoxShadow":"","PBHPBGColor":"","PBHPColor":"#930912","PBHPBorderColor":"#787878","PBHPBorderType":"solid","PBHPBorderWidth":"1","CBPPosition":"absolute","CBPTop":"25px","CBPRight":"20px","CBPBottom":"","CBPLeft":"","CBPBGColor":"#ffffff","CBPFontSize":"18","CBPFontWeight":"normal","CBPColor":"#930912","CBPPadding":"","CBPMargin":"0px","CBPBorderTop":"top","CBPBorderRight":"right","CBPBorderBottom":"bottom","CBPBorderLeft":"left","CBPBorderColor":"#606060","CBPBorderType":"solid","CBPBorderWidth":"1","CBPBorderRadius":"15","CBHPBGColor":"#ffffff","CBHPColor":"#2d4d5f","CBHPBorderTop":"top","CBHPBorderRight":"right","CBHPBorderBottom":"bottom","CBHPBorderLeft":"left","CBHPBorderColor":"#606060","CBHPBorderType":"solid","CBHPBorderWidth":"1","MBPBGColor":"#ffffff","MBPFontSize":"17","MBPFontWeight":"normal","MBPColor":"#930912","MBPTextAlign":"center","MBPPadding":"10px","MBPMargin":"","MBPBorderTop":"top","MBPBorderRight":"right","MBPBorderBottom":"bottom","MBPBorderLeft":"left","MBPBorderColor":"#606060","MBPBorderType":"solid","MBPBorderWidth":"2","MBPBorderRadius":"0","MBHPBGColor":"#ffffff","MBHPColor":"#666666","MBHPBorderTop":"top","MBHPBorderRight":"right","MBHPBorderBottom":"bottom","MBHPBorderLeft":"left","MBHPBorderColor":"#930912","MBHPBorderType":"solid","MBHPBorderWidth":"2","OPDeInputColor":"#afafaf","OPFontStyle":"normal","OPRColor":"#ff1313","OPDPIcon":"images/themes/date-pickers/2.png","OPDPRepeat":"no-repeat","OPDPPos1":"0%","OPDPPos2":"10%","OPDPMargin":"3px 0 0 -23px","OPFBgUrl":"images/themes/file-uploads/2.png","OPFBGRepeat":"no-repeat","OPFPos1":"0%","OPFPos2":"10%","OPGWidth":"100","CUPCSS":""}\', 0, 2);');
      $wpdb->query('INSERT INTO `' . $wpdb->prefix . 'formmaker_themes` (`title`, `css`, `default`, `version`) VALUES ("Theme 5", \'{"GPFontFamily":"cursive","AGPWidth":"100","AGPSPWidth":"40","AGPPadding":"","AGPMargin":"10px auto","AGPBorderColor":"#ffffff","AGPBorderType":"solid","AGPBorderWidth":"1","AGPBorderRadius":"0","AGPBoxShadow":"","HPAlign":"top","HPBGColor":"#aee2de","HPWidth":"100","HTPWidth":"40","HPPadding":"10px","HPMargin":"","HPTextAlign":"center","HPBorderColor":"#b7b7b7","HPBorderType":"solid","HPBorderWidth":"1","HPBorderRadius":"0","HTPFontSize":"19","HTPWeight":"normal","HTPColor":"#042325","HDPFontSize":"13","HDPColor":"#518a88","HIPAlign":"left","HIPWidth":"80","HIPHeight":"","GPBGColor":"#214555","GPFontSize":"15","GPFontWeight":"normal","GPWidth":"100","GTPWidth":"60","GPAlign":"center","GPBackground":"","GPBackgroundRepeat":"no-repeat","GPBGPosition1":"","GPBGPosition2":"","GPBGSize1":"","GPBGSize2":"","GPColor":"#d4d4d4","GPPadding":"10px 20px","GPMargin":"","GPBorderColor":"#ffffff","GPBorderType":"solid","GPBorderWidth":"1","GPBorderRadius":"0","GPMLFontSize":"14","GPMLFontWeight":"normal","GPMLColor":"#d4d4d4","GPMLPadding":"0px 5px 0px 0px","GPMLMargin":"0px","SEPBGColor":"#214555","SEPPadding":"","SEPMargin":"","COPPadding":"10px","COPMargin":"0px","FPWidth":"70","FPPadding":"15px 0 0 0","FPMargin":"0 auto","IPHeight":"40","IPFontSize":"16","IPFontWeight":"normal","IPBGColor":"#ffffff","IPColor":"#518a88","IPPadding":"5px 5px","IPMargin":"0px","IPBorderTop":"top","IPBorderRight":"right","IPBorderBottom":"bottom","IPBorderLeft":"left","IPBorderColor":"#dfdfdf","IPBorderType":"solid","IPBorderWidth":"1","IPBorderRadius":"0","IPBoxShadow":"","SBPAppearance":"none","SBPBackground":"images/themes/drop-downs/2.png","SBPBGRepeat":"no-repeat","SBPBGPos1":"95%","SBPBGPos2":"50%","SBPBGSize1":"8%","SBPBGSize2":"32%","SCPBGColor":"#ffffff","SCPWidth":"16","SCPHeight":"16","SCPBorderTop":"top","SCPBorderRight":"right","SCPBorderBottom":"bottom","SCPBorderLeft":"left","SCPBorderColor":"#518a88","SCPBorderType":"solid","SCPBorderWidth":"1","SCPMargin":"0px 3px","SCPBorderRadius":"15","SCPBoxShadow":"","SCCPBGColor":"#518a88","SCCPWidth":"6","SCCPHeight":"6","SCCPMargin":"5","SCCPBorderRadius":"10","MCPBGColor":"#ffffff","MCPWidth":"16","MCPHeight":"16","MCPBorderTop":"top","MCPBorderRight":"right","MCPBorderBottom":"bottom","MCPBorderLeft":"left","MCPBorderColor":"#518a88","MCPBorderType":"solid","MCPBorderWidth":"1","MCPMargin":"0px 3px","MCPBorderRadius":"0","MCPBoxShadow":"","MCCPBGColor":"","MCCPBackground":"images/themes/checkboxes/1.png","MCCPBGRepeat":"no-repeat","MCCPBGPos1":"","MCCPBGPos2":"","MCCPWidth":"16","MCCPHeight":"16","MCCPMargin":"0","MCCPBorderRadius":"0","SPAlign":"left","SPBGColor":"#f46322","SPWidth":"130","SPHeight":"40","SPFontSize":"14","SPFontWeight":"normal","SPColor":"#ffffff","SPPadding":"0px 5px","SPMargin":"0 15px 0 0","SPBorderTop":"top","SPBorderRight":"right","SPBorderBottom":"bottom","SPBorderLeft":"left","SPBorderColor":"#f46322","SPBorderType":"solid","SPBorderWidth":"1","SPBorderRadius":"0","SPBoxShadow":"","SHPBGColor":"#f46322","SHPColor":"#ffffff","SHPBorderTop":"top","SHPBorderRight":"right","SHPBorderBottom":"bottom","SHPBorderLeft":"left","SHPBorderColor":"#f46322","SHPBorderType":"solid","SHPBorderWidth":"1","BPBGColor":"#bababa","BPWidth":"","BPHeight":"40","BPFontSize":"14","BPFontWeight":"normal","BPColor":"#454545","BPPadding":"0px 5px","BPMargin":"0 15px 0 0","BPBorderTop":"top","BPBorderRight":"right","BPBorderBottom":"bottom","BPBorderLeft":"left","BPBorderColor":"#bababa","BPBorderType":"solid","BPBorderWidth":"1","BPBorderRadius":"0","BPBoxShadow":"","BHPBGColor":"#bababa","BHPColor":"#454545","BHPBorderTop":"top","BHPBorderRight":"right","BHPBorderBottom":"bottom","BHPBorderLeft":"left","BHPBorderColor":"#bababa","BHPBorderType":"solid","BHPBorderWidth":"1","PSAPBGColor":"#f46322","PSAPFontSize":"14","PSAPFontWeight":"normal","PSAPColor":"#ffffff","PSAPHeight":"","PSAPLineHeight":"","PSAPPadding":"8px","PSAPMargin":"0","PSAPBorderColor":"","PSAPBorderType":"solid","PSAPBorderWidth":"2","PSAPBorderRadius":"3","PSDPBGColor":"#bababa","PSDPFontSize":"13","PSDPFontWeight":"normal","PSDPColor":"#518a88","PSDPHeight":"","PSDPLineHeight":"","PSDPPadding":"4px 6px","PSDPMargin":"0 0 0 -3px","PSDPBorderColor":"#a3a3a3","PSDPBorderType":"solid","PSDPBorderWidth":"2","PSDPBorderRadius":"3","PSAPAlign":"left","PSAPWidth":"","PPAPWidth":"100%","NBPBGColor":"","NBPWidth":"","NBPHeight":"","NBPLineHeight":"","NBPColor":"#f46322","NBPPadding":"4px 10px","NBPMargin":"0px","NBPBorderColor":"#777777","NBPBorderType":"solid","NBPBorderWidth":"1","NBPBorderRadius":"0","NBPBoxShadow":"","NBHPBGColor":"","NBHPColor":"#d4d4d4","NBHPBorderColor":"#787878","NBHPBorderType":"solid","NBHPBorderWidth":"1","PBPBGColor":"","PBPWidth":"100","PBPHeight":"","PBPLineHeight":"","PBPColor":"#d4d4d4","PBPPadding":"","PBPMargin":"0px","PBPBorderColor":"#777777","PBPBorderType":"solid","PBPBorderWidth":"1","PBPBorderRadius":"0","PBPBoxShadow":"","PBHPBGColor":"","PBHPColor":"#f46322","PBHPBorderColor":"#787878","PBHPBorderType":"solid","PBHPBorderWidth":"1","CBPPosition":"absolute","CBPTop":"10px","CBPRight":"0px","CBPBottom":"","CBPLeft":"","CBPBGColor":"","CBPFontSize":"18","CBPFontWeight":"normal","CBPColor":"#f46322","CBPPadding":"0px","CBPMargin":"0px","CBPBorderColor":"#ffffff","CBPBorderType":"solid","CBPBorderWidth":"1","CBPBorderRadius":"0","CBHPBGColor":"","CBHPColor":"#214555","CBHPBorderColor":"#737373","CBHPBorderType":"solid","CBHPBorderWidth":"1","MBPBGColor":"#aee2de","MBPFontSize":"15","MBPFontWeight":"normal","MBPColor":"#000000","MBPTextAlign":"center","MBPPadding":"10px","MBPMargin":"","MBPBorderTop":"top","MBPBorderRight":"right","MBPBorderBottom":"bottom","MBPBorderLeft":"left","MBPBorderColor":"#518a88","MBPBorderType":"solid","MBPBorderWidth":"2","MBPBorderRadius":"0","MBHPBGColor":"#518a88","MBHPColor":"#ffffff","MBHPBorderTop":"top","MBHPBorderRight":"right","MBHPBorderBottom":"bottom","MBHPBorderLeft":"left","MBHPBorderColor":"#518a88","MBHPBorderType":"solid","MBHPBorderWidth":"2","OPDeInputColor":"#afafaf","OPFontStyle":"normal","OPRColor":"#ff1313","OPDPIcon":"images/themes/date-pickers/2.png","OPDPRepeat":"no-repeat","OPDPPos1":"0%","OPDPPos2":"10%","OPDPMargin":"3px 0 0 -23px","OPFBgUrl":"images/themes/file-uploads/2.png","OPFBGRepeat":"no-repeat","OPFPos1":"0%","OPFPos2":"10%","OPGWidth":"100","CUPCSS":""}\', 0, 2);');
      $wpdb->query('INSERT INTO `' . $wpdb->prefix . 'formmaker_themes` (`title`, `css`, `default`, `version`) VALUES ("Theme 6", \'{"GPFontFamily":"PT Sans","AGPWidth":"100","AGPSPWidth":"35","AGPPadding":"","AGPMargin":"10px auto","AGPBorderColor":"#ffffff","AGPBorderType":"solid","AGPBorderWidth":"1","AGPBorderRadius":"0","AGPBoxShadow":"","HPAlign":"top","HPBGColor":"#ffffff","HPWidth":"100","HTPWidth":"40","HPPadding":"10px","HPMargin":"","HPTextAlign":"center","HPBorderColor":"#b7b7b7","HPBorderType":"solid","HPBorderWidth":"1","HPBorderRadius":"0","HTPFontSize":"27","HTPWeight":"bold","HTPColor":"#1d6d69","HDPFontSize":"15","HDPColor":"#808080","HIPAlign":"left","HIPWidth":"80","HIPHeight":"","GPBGColor":"#3a9391","GPFontSize":"15","GPFontWeight":"normal","GPWidth":"100","GTPWidth":"60","GPAlign":"center","GPBackground":"","GPBackgroundRepeat":"no-repeat","GPBGPosition1":"","GPBGPosition2":"","GPBGSize1":"","GPBGSize2":"","GPColor":"#ffffff","GPPadding":"10px","GPMargin":"","GPBorderColor":"#ffffff","GPBorderType":"solid","GPBorderWidth":"1","GPBorderRadius":"0","GPMLFontSize":"14","GPMLFontWeight":"normal","GPMLColor":"#ffffff","GPMLPadding":"0px 5px 0px 0px","GPMLMargin":"0px","SEPBGColor":"#3a9391","SEPPadding":"","SEPMargin":"","COPPadding":"10px","COPMargin":"0px","FPWidth":"80","FPPadding":"15px 0 0 0","FPMargin":"0 auto","IPHeight":"26","IPFontSize":"13","IPFontWeight":"normal","IPBGColor":"#ffffff","IPColor":"#a0a0a0","IPPadding":"0px 5px","IPMargin":"0px","IPBorderTop":"top","IPBorderRight":"right","IPBorderBottom":"bottom","IPBorderLeft":"left","IPBorderColor":"#d6d6d6","IPBorderType":"solid","IPBorderWidth":"1","IPBorderRadius":"0","IPBoxShadow":"","SBPAppearance":"none","SBPBackground":"images/themes/drop-downs/2.png","SBPBGRepeat":"no-repeat","SBPBGPos1":"95%","SBPBGPos2":"50%","SBPBGSize1":"8%","SBPBGSize2":"32%","SCPBGColor":"","SCPWidth":"14","SCPHeight":"14","SCPBorderTop":"top","SCPBorderRight":"right","SCPBorderBottom":"bottom","SCPBorderLeft":"left","SCPBorderColor":"#ffffff","SCPBorderType":"solid","SCPBorderWidth":"1","SCPMargin":"0px 3px","SCPBorderRadius":"15","SCPBoxShadow":"","SCCPBGColor":"#ffffff","SCCPWidth":"8","SCCPHeight":"8","SCCPMargin":"3","SCCPBorderRadius":"10","MCPBGColor":"","MCPWidth":"14","MCPHeight":"14","MCPBorderTop":"top","MCPBorderRight":"right","MCPBorderBottom":"bottom","MCPBorderLeft":"left","MCPBorderColor":"#ffffff","MCPBorderType":"solid","MCPBorderWidth":"1","MCPMargin":"0px 3px","MCPBorderRadius":"0","MCPBoxShadow":"","MCCPBGColor":"#ffffff","MCCPBackground":"","MCCPBGRepeat":"no-repeat","MCCPBGPos1":"","MCCPBGPos2":"","MCCPWidth":"10","MCCPHeight":"10","MCCPMargin":"2","MCCPBorderRadius":"0","SPAlign":"right","SPBGColor":"#ffb33a","SPWidth":"","SPHeight":"","SPFontSize":"15","SPFontWeight":"normal","SPColor":"#ffffff","SPPadding":"6px 10px","SPMargin":"0 15px 0 0","SPBorderColor":"#1d6d69","SPBorderType":"solid","SPBorderWidth":"1","SPBorderRadius":"0","SPBoxShadow":"2px 2px 2px #1d6d69","SHPBGColor":"#f60c5b","SHPColor":"#ffffff","SHPBorderColor":"#ffffff","SHPBorderType":"solid","SHPBorderWidth":"1","BPBGColor":"#1d6d69","BPWidth":"","BPHeight":"","BPFontSize":"15","BPFontWeight":"normal","BPColor":"#ffffff","BPPadding":"6px 10px","BPMargin":"0 15px 0 0","BPBorderColor":"#357773","BPBorderType":"solid","BPBorderWidth":"1","BPBorderRadius":"0","BPBoxShadow":"2px 2px 2px #1d6d69","BHPBGColor":"#35a098","BHPColor":"#ffffff","BHPBorderColor":"#ffffff","BHPBorderType":"solid","BHPBorderWidth":"1","PSAPBGColor":"#ffb33a","PSAPFontSize":"16","PSAPFontWeight":"normal","PSAPColor":"#ffffff","PSAPHeight":"","PSAPLineHeight":"","PSAPPadding":"8px","PSAPMargin":"0 0 4px 0 ","PSAPBorderTop":"top","PSAPBorderRight":"right","PSAPBorderBottom":"bottom","PSAPBorderLeft":"left","PSAPBorderColor":"#ffb33a","PSAPBorderType":"solid","PSAPBorderWidth":"2","PSAPBorderRadius":"3","PSDPBGColor":"#1d6d69","PSDPFontSize":"16","PSDPFontWeight":"normal","PSDPColor":"#ffffff","PSDPHeight":"","PSDPLineHeight":"","PSDPPadding":"4px 6px","PSDPMargin":"0 0 0 -3px","PSDPBorderTop":"top","PSDPBorderRight":"right","PSDPBorderBottom":"bottom","PSDPBorderLeft":"left","PSDPBorderColor":"#1d6d69","PSDPBorderType":"solid","PSDPBorderWidth":"2","PSDPBorderRadius":"3","PSAPAlign":"right","PSAPWidth":"","PPAPWidth":"100%","NBPBGColor":"","NBPWidth":"","NBPHeight":"","NBPLineHeight":"","NBPColor":"#ffffff","NBPPadding":"4px 10px","NBPMargin":"0px","NBPBorderColor":"#777777","NBPBorderType":"solid","NBPBorderWidth":"1","NBPBorderRadius":"0","NBPBoxShadow":"","NBHPBGColor":"","NBHPColor":"#018c8b","NBHPBorderColor":"#787878","NBHPBorderType":"solid","NBHPBorderWidth":"1","PBPBGColor":"","PBPWidth":"100","PBPHeight":"","PBPLineHeight":"","PBPColor":"#ffffff","PBPPadding":"","PBPMargin":"0px","PBPBorderColor":"#777777","PBPBorderType":"solid","PBPBorderWidth":"1","PBPBorderRadius":"0","PBPBoxShadow":"","PBHPBGColor":"","PBHPColor":"#d82534","PBHPBorderColor":"#787878","PBHPBorderType":"solid","PBHPBorderWidth":"1","CBPPosition":"absolute","CBPTop":"10px","CBPRight":"10px","CBPBottom":"","CBPLeft":"","CBPBGColor":"","CBPFontSize":"16","CBPFontWeight":"lighter","CBPColor":"#ffb33a","CBPPadding":"0px","CBPMargin":"0px","CBPBorderColor":"#ffffff","CBPBorderType":"solid","CBPBorderWidth":"1","CBPBorderRadius":"0","CBHPBGColor":"","CBHPColor":"#f60c5b","CBHPBorderColor":"#ffffff","CBHPBorderType":"solid","CBHPBorderWidth":"1","MBPBGColor":"#1d6d69","MBPFontSize":"16","MBPFontWeight":"normal","MBPColor":"#ffffff","MBPTextAlign":"center","MBPPadding":"10px","MBPMargin":"","MBPBorderTop":"top","MBPBorderRight":"right","MBPBorderBottom":"bottom","MBPBorderLeft":"left","MBPBorderColor":"#1d6d69","MBPBorderType":"solid","MBPBorderWidth":"2","MBPBorderRadius":"0","MBHPBGColor":"#ffffff","MBHPColor":"#1d6d69","MBHPBorderTop":"top","MBHPBorderRight":"right","MBHPBorderBottom":"bottom","MBHPBorderLeft":"left","MBHPBorderColor":"#1d6d69","MBHPBorderType":"solid","MBHPBorderWidth":"2","OPDeInputColor":"#afafaf","OPFontStyle":"normal","OPRColor":"#ffffff","OPDPIcon":"images/themes/date-pickers/2.png","OPDPRepeat":"no-repeat","OPDPPos1":"0%","OPDPPos2":"10%","OPDPMargin":"3px 0 0 -23px","OPFBgUrl":"images/themes/file-uploads/2.png","OPFBGRepeat":"no-repeat","OPFPos1":"0%","OPFPos2":"10%","OPGWidth":"100","CUPCSS":""}\', 0, 2);');
      $wpdb->query('INSERT INTO `' . $wpdb->prefix . 'formmaker_themes` (`title`, `css`, `default`, `version`) VALUES ("Theme 7", \'{"GPFontFamily":"PT Sans","AGPWidth":"100","AGPSPWidth":"35","AGPPadding":"","AGPMargin":"10px auto","AGPBorderColor":"#ffffff","AGPBorderType":"solid","AGPBorderWidth":"1","AGPBorderRadius":"0","AGPBoxShadow":"","HPAlign":"top","HPBGColor":"#ffffff","HPWidth":"100","HTPWidth":"40","HPPadding":"10px 0","HPMargin":"","HPTextAlign":"center","HPBorderColor":"#b7b7b7","HPBorderType":"solid","HPBorderWidth":"1","HPBorderRadius":"0","HTPFontSize":"27","HTPWeight":"bold","HTPColor":"#3596d4","HDPFontSize":"15","HDPColor":"#808080","HIPAlign":"left","HIPWidth":"80","HIPHeight":"","GPBGColor":"#2d4d5f","GPFontSize":"15","GPFontWeight":"normal","GPWidth":"100","GTPWidth":"60","GPAlign":"center","GPBackground":"","GPBackgroundRepeat":"no-repeat","GPBGPosition1":"","GPBGPosition2":"","GPBGSize1":"","GPBGSize2":"","GPColor":"#ffffff","GPPadding":"10px","GPMargin":"","GPBorderColor":"#ffffff","GPBorderType":"solid","GPBorderWidth":"1","GPBorderRadius":"0","GPMLFontSize":"14","GPMLFontWeight":"normal","GPMLColor":"#ffffff","GPMLPadding":"0px 5px 0px 0px","GPMLMargin":"0px","SEPBGColor":"#2d4d5f","SEPPadding":"","SEPMargin":"","COPPadding":"10px","COPMargin":"0px","FPWidth":"80","FPPadding":"15px 0 0 0","FPMargin":"0 auto","IPHeight":"26","IPFontSize":"13","IPFontWeight":"normal","IPBGColor":"#ffffff","IPColor":"#a0a0a0","IPPadding":"0px 5px","IPMargin":"0px","IPBorderTop":"top","IPBorderRight":"right","IPBorderBottom":"bottom","IPBorderLeft":"left","IPBorderColor":"#d6d6d6","IPBorderType":"solid","IPBorderWidth":"1","IPBorderRadius":"0","IPBoxShadow":"","SBPAppearance":"none","SBPBackground":"images/themes/drop-downs/2.png","SBPBGRepeat":"no-repeat","SBPBGPos1":"95%","SBPBGPos2":"50%","SBPBGSize1":"8%","SBPBGSize2":"32%","SCPBGColor":"","SCPWidth":"14","SCPHeight":"14","SCPBorderTop":"top","SCPBorderRight":"right","SCPBorderBottom":"bottom","SCPBorderLeft":"left","SCPBorderColor":"#ffffff","SCPBorderType":"solid","SCPBorderWidth":"1","SCPMargin":"0px 3px","SCPBorderRadius":"15","SCPBoxShadow":"","SCCPBGColor":"#ffffff","SCCPWidth":"8","SCCPHeight":"8","SCCPMargin":"3","SCCPBorderRadius":"10","MCPBGColor":"","MCPWidth":"14","MCPHeight":"14","MCPBorderTop":"top","MCPBorderRight":"right","MCPBorderBottom":"bottom","MCPBorderLeft":"left","MCPBorderColor":"#ffffff","MCPBorderType":"solid","MCPBorderWidth":"1","MCPMargin":"0px 3px","MCPBorderRadius":"0","MCPBoxShadow":"","MCCPBGColor":"#ffffff","MCCPBackground":"","MCCPBGRepeat":"no-repeat","MCCPBGPos1":"","MCCPBGPos2":"","MCCPWidth":"10","MCCPHeight":"10","MCCPMargin":"2","MCCPBorderRadius":"0","SPAlign":"right","SPBGColor":"#ffb33a","SPWidth":"","SPHeight":"","SPFontSize":"15","SPFontWeight":"normal","SPColor":"#ffffff","SPPadding":"6px 10px","SPMargin":"0 15px 0 0 ","SPBorderColor":"#ffffff","SPBorderType":"solid","SPBorderWidth":"1","SPBorderRadius":"0","SPBoxShadow":"2px 2px 2px #1f3c4c","SHPBGColor":"#ba9911","SHPColor":"#ffffff","SHPBorderColor":"#ffffff","SHPBorderType":"solid","SHPBorderWidth":"1","BPBGColor":"#44acf0","BPWidth":"","BPHeight":"","BPFontSize":"15","BPFontWeight":"normal","BPColor":"#ffffff","BPPadding":"6px 10px","BPMargin":"0 15px 0 0 ","BPBorderColor":"#ffffff","BPBorderType":"solid","BPBorderWidth":"1","BPBorderRadius":"0","BPBoxShadow":"2px 2px 2px #1f3c4c","BHPBGColor":"#44acf0","BHPColor":"#ffffff","BHPBorderColor":"#ffffff","BHPBorderType":"solid","BHPBorderWidth":"1","PSAPBGColor":"#44acf0","PSAPFontSize":"16","PSAPFontWeight":"normal","PSAPColor":"#ffffff","PSAPHeight":"","PSAPLineHeight":"","PSAPPadding":"8px","PSAPMargin":"0","PSAPBorderTop":"top","PSAPBorderRight":"right","PSAPBorderBottom":"bottom","PSAPBorderLeft":"left","PSAPBorderColor":"#44acf0","PSAPBorderType":"solid","PSAPBorderWidth":"2","PSAPBorderRadius":"3","PSDPBGColor":"#ffffff","PSDPFontSize":"16","PSDPFontWeight":"normal","PSDPColor":"#808080","PSDPHeight":"","PSDPLineHeight":"","PSDPPadding":"4px 6px","PSDPMargin":"0 0 0 -3px","PSDPBorderTop":"top","PSDPBorderRight":"right","PSDPBorderBottom":"bottom","PSDPBorderLeft":"left","PSDPBorderColor":"#808080","PSDPBorderType":"solid","PSDPBorderWidth":"1","PSDPBorderRadius":"3","PSAPAlign":"right","PSAPWidth":"","PPAPWidth":"100%","NBPBGColor":"","NBPWidth":"","NBPHeight":"","NBPLineHeight":"","NBPColor":"#ffffff","NBPPadding":"4px 10px","NBPMargin":"0px","NBPBorderColor":"#777777","NBPBorderType":"solid","NBPBorderWidth":"1","NBPBorderRadius":"0","NBPBoxShadow":"","NBHPBGColor":"","NBHPColor":"#ba9911","NBHPBorderColor":"#787878","NBHPBorderType":"solid","NBHPBorderWidth":"1","PBPBGColor":"","PBPWidth":"100","PBPHeight":"","PBPLineHeight":"","PBPColor":"#ffffff","PBPPadding":"","PBPMargin":"0px","PBPBorderColor":"#777777","PBPBorderType":"solid","PBPBorderWidth":"1","PBPBorderRadius":"0","PBPBoxShadow":"","PBHPBGColor":"","PBHPColor":"#ba9911","PBHPBorderColor":"#787878","PBHPBorderType":"solid","PBHPBorderWidth":"1","CBPPosition":"absolute","CBPTop":"10px","CBPRight":"10px","CBPBottom":"","CBPLeft":"","CBPBGColor":"","CBPFontSize":"16","CBPFontWeight":"lighter","CBPColor":"#808080","CBPPadding":"0px","CBPMargin":"0px","CBPBorderColor":"#ffffff","CBPBorderType":"solid","CBPBorderWidth":"1","CBPBorderRadius":"0","CBHPBGColor":"","CBHPColor":"#ffb33a","CBHPBorderColor":"#ffffff","CBHPBorderType":"solid","CBHPBorderWidth":"1","MBPBGColor":"#ffffff","MBPFontSize":"16","MBPFontWeight":"normal","MBPColor":"#3596d4","MBPTextAlign":"center","MBPPadding":"10px","MBPMargin":"","MBPBorderTop":"top","MBPBorderRight":"right","MBPBorderBottom":"bottom","MBPBorderLeft":"left","MBPBorderColor":"#2d4d5f","MBPBorderType":"solid","MBPBorderWidth":"2","MBPBorderRadius":"0","MBHPBGColor":"#3596d4","MBHPColor":"#ffffff","MBHPBorderTop":"top","MBHPBorderRight":"right","MBHPBorderBottom":"bottom","MBHPBorderLeft":"left","MBHPBorderColor":"#2d4d5f","MBHPBorderType":"solid","MBHPBorderWidth":"2","OPDeInputColor":"#afafaf","OPFontStyle":"normal","OPRColor":"#ffb33a","OPDPIcon":"images/themes/date-pickers/2.png","OPDPRepeat":"no-repeat","OPDPPos1":"0%","OPDPPos2":"10%","OPDPMargin":"3px 0 0 -23px","OPFBgUrl":"images/themes/file-uploads/2.png","OPFBGRepeat":"no-repeat","OPFPos1":"0%","OPFPos2":"10%","OPGWidth":"100","CUPCSS":""}\', 0, 2);');
      $wpdb->query('INSERT INTO `' . $wpdb->prefix . 'formmaker_themes` (`title`, `css`, `default`, `version`) VALUES ("Theme 8", \'{"GPFontFamily":"PT Sans","AGPWidth":"100","AGPSPWidth":"35","AGPPadding":"","AGPMargin":"10px auto","AGPBorderColor":"#ffffff","AGPBorderType":"solid","AGPBorderWidth":"1","AGPBorderRadius":"0","AGPBoxShadow":"","HPAlign":"top","HPBGColor":"#435c71","HPWidth":"100","HTPWidth":"40","HPPadding":"20px","HPMargin":"","HPTextAlign":"center","HPBorderColor":"#b7b7b7","HPBorderType":"solid","HPBorderWidth":"1","HPBorderRadius":"0","HTPFontSize":"30","HTPWeight":"bold","HTPColor":"#e6c41b","HDPFontSize":"15","HDPColor":"#ffffff","HIPAlign":"right","HIPWidth":"40","HIPHeight":"26","GPBGColor":"#f8f8f8","GPFontSize":"15","GPFontWeight":"bold","GPWidth":"100","GTPWidth":"60","GPAlign":"center","GPBackground":"","GPBackgroundRepeat":"no-repeat","GPBGPosition1":"","GPBGPosition2":"","GPBGSize1":"","GPBGSize2":"","GPColor":"#3b3b3b","GPPadding":"10px","GPMargin":"","GPBorderColor":"#ffffff","GPBorderType":"solid","GPBorderWidth":"1","GPBorderRadius":"0","GPMLFontSize":"11","GPMLFontWeight":"normal","GPMLColor":"#3b3b3b","GPMLPadding":"0px 5px 0px 0px","GPMLMargin":"0px","SEPBGColor":"#f8f8f8","SEPPadding":"","SEPMargin":"","COPPadding":"10px","COPMargin":"0px","FPWidth":"80","FPPadding":"15px 0 0 0","FPMargin":"0 auto","IPHeight":"40","IPFontSize":"13","IPFontWeight":"normal","IPBGColor":"#ffffff","IPColor":"#6e6e6e","IPPadding":"6px 10px","IPMargin":"0px","IPBorderTop":"top","IPBorderRight":"right","IPBorderBottom":"bottom","IPBorderLeft":"left","IPBorderColor":"#989898","IPBorderType":"solid","IPBorderWidth":"1","IPBorderRadius":"0","IPBoxShadow":"","SBPAppearance":"none","SBPBackground":"images/themes/drop-downs/3.png","SBPBGRepeat":"no-repeat","SBPBGPos1":"95%","SBPBGPos2":"50%","SBPBGSize1":"8%","SBPBGSize2":"32%","SCPBGColor":"","SCPWidth":"14","SCPHeight":"14","SCPBorderTop":"top","SCPBorderRight":"right","SCPBorderBottom":"bottom","SCPBorderLeft":"left","SCPBorderColor":"#989898","SCPBorderType":"solid","SCPBorderWidth":"1","SCPMargin":"0px 3px","SCPBorderRadius":"15","SCPBoxShadow":"","SCCPBGColor":"#989898","SCCPWidth":"6","SCCPHeight":"6","SCCPMargin":"4","SCCPBorderRadius":"10","MCPBGColor":"","MCPWidth":"14","MCPHeight":"14","MCPBorderTop":"top","MCPBorderRight":"right","MCPBorderBottom":"bottom","MCPBorderLeft":"left","MCPBorderColor":"#989898","MCPBorderType":"solid","MCPBorderWidth":"1","MCPMargin":"0px 3px","MCPBorderRadius":"0","MCPBoxShadow":"","MCCPBGColor":"","MCCPBackground":"images/themes/checkboxes/3.png","MCCPBGRepeat":"no-repeat","MCCPBGPos1":"","MCCPBGPos2":"","MCCPWidth":"16","MCCPHeight":"16","MCCPMargin":"0 0 2px 0","MCCPBorderRadius":"0","SPAlign":"left","SPBGColor":"#f05e22","SPWidth":"","SPHeight":"","SPFontSize":"15","SPFontWeight":"normal","SPColor":"#ffffff","SPPadding":"6px 10px","SPMargin":"0 15px 0 0 ","SPBorderColor":"#9eaab1","SPBorderType":"solid","SPBorderWidth":"1","SPBorderRadius":"0","SPBoxShadow":"2px 2px 2px #9eaab1","SHPBGColor":"#d82534","SHPColor":"#ffffff","SHPBorderColor":"#ffffff","SHPBorderType":"solid","SHPBorderWidth":"1","BPBGColor":"#f1cb15","BPWidth":"","BPHeight":"","BPFontSize":"15","BPFontWeight":"normal","BPColor":"#424242","BPPadding":"6px 10px","BPMargin":"0 15px 0 0 ","BPBorderColor":"#ffffff","BPBorderType":"solid","BPBorderWidth":"1","BPBorderRadius":"0","BPBoxShadow":"2px 2px 2px #9eaab1","BHPBGColor":"#435c71","BHPColor":"#e6c41b","BHPBorderColor":"#ffffff","BHPBorderType":"solid","BHPBorderWidth":"1","PSAPBGColor":"#f05e22","PSAPFontSize":"16","PSAPFontWeight":"normal","PSAPColor":"#ffffff","PSAPHeight":"","PSAPLineHeight":"","PSAPPadding":"8px","PSAPMargin":"0","PSAPBorderTop":"top","PSAPBorderRight":"right","PSAPBorderBottom":"bottom","PSAPBorderLeft":"left","PSAPBorderColor":"#f05e22","PSAPBorderType":"solid","PSAPBorderWidth":"2","PSAPBorderRadius":"3","PSDPBGColor":"#ffffff","PSDPFontSize":"16","PSDPFontWeight":"bold","PSDPColor":"#435c71","PSDPHeight":"","PSDPLineHeight":"","PSDPPadding":"4px 6px","PSDPMargin":"0 0 0 -3px","PSDPBorderTop":"top","PSDPBorderRight":"right","PSDPBorderBottom":"bottom","PSDPBorderLeft":"left","PSDPBorderColor":"#435c71","PSDPBorderType":"solid","PSDPBorderWidth":"1","PSDPBorderRadius":"3","PSAPAlign":"right","PSAPWidth":"","PPAPWidth":"100%","NBPBGColor":"","NBPWidth":"","NBPHeight":"","NBPLineHeight":"","NBPColor":"#3b3b3b","NBPPadding":"4px 10px","NBPMargin":"0px","NBPBorderColor":"#777777","NBPBorderType":"solid","NBPBorderWidth":"1","NBPBorderRadius":"0","NBPBoxShadow":"","NBHPBGColor":"","NBHPColor":"#d82534","NBHPBorderColor":"#787878","NBHPBorderType":"solid","NBHPBorderWidth":"1","PBPBGColor":"","PBPWidth":"100","PBPHeight":"","PBPLineHeight":"","PBPColor":"#3b3b3b","PBPPadding":"","PBPMargin":"0px","PBPBorderColor":"#777777","PBPBorderType":"solid","PBPBorderWidth":"1","PBPBorderRadius":"0","PBPBoxShadow":"","PBHPBGColor":"","PBHPColor":"#d82534","PBHPBorderColor":"#787878","PBHPBorderType":"solid","PBHPBorderWidth":"1","CBPPosition":"absolute","CBPTop":"10px","CBPRight":"10px","CBPBottom":"","CBPLeft":"","CBPBGColor":"","CBPFontSize":"16","CBPFontWeight":"lighter","CBPColor":"#e6c41b","CBPPadding":"0px","CBPMargin":"0px","CBPBorderColor":"#ffffff","CBPBorderType":"solid","CBPBorderWidth":"1","CBPBorderRadius":"0","CBHPBGColor":"","CBHPColor":"#d82534","CBHPBorderColor":"#ffffff","CBHPBorderType":"solid","CBHPBorderWidth":"1","MBPBGColor":"#435c71","MBPFontSize":"16","MBPFontWeight":"normal","MBPColor":"#e6c41b","MBPTextAlign":"center","MBPPadding":"10px","MBPMargin":"","MBPBorderTop":"top","MBPBorderRight":"right","MBPBorderBottom":"bottom","MBPBorderLeft":"left","MBPBorderColor":"#435c71","MBPBorderType":"solid","MBPBorderWidth":"2","MBPBorderRadius":"0","MBHPBGColor":"#ffffff","MBHPColor":"#e6c41b","MBHPBorderTop":"top","MBHPBorderRight":"right","MBHPBorderBottom":"bottom","MBHPBorderLeft":"left","MBHPBorderColor":"#435c71","MBHPBorderType":"solid","MBHPBorderWidth":"2","OPDeInputColor":"#afafaf","OPFontStyle":"normal","OPRColor":"#f05e22","OPDPIcon":"images/themes/date-pickers/2.png","OPDPRepeat":"no-repeat","OPDPPos1":"0%","OPDPPos2":"10%","OPDPMargin":"3px 0 0 -23px","OPFBgUrl":"images/themes/file-uploads/2.png","OPFBGRepeat":"no-repeat","OPFPos1":"0%","OPFPos2":"10%","OPGWidth":"100","CUPCSS":""}\', 0, 2);');
      $wpdb->query('INSERT INTO `' . $wpdb->prefix . 'formmaker_themes` (`title`, `css`, `default`, `version`) VALUES ("Theme 9", \'{"GPFontFamily":"Open Sans Condensed","AGPWidth":"100","AGPSPWidth":"35","AGPPadding":"","AGPMargin":"10px auto","AGPBorderColor":"#ffffff","AGPBorderType":"solid","AGPBorderWidth":"1","AGPBorderRadius":"0","AGPBoxShadow":"","HPAlign":"left","HPBGColor":"#4d4d4d","HPWidth":"50","HTPWidth":"40","HPPadding":"10px","HPMargin":"","HPTextAlign":"center","HPBorderColor":"#b7b7b7","HPBorderType":"solid","HPBorderWidth":"1","HPBorderRadius":"0","HTPFontSize":"26","HTPWeight":"bold","HTPColor":"#ffffff","HDPFontSize":"14","HDPColor":"#b95d3c","HIPAlign":"top","HIPWidth":"80","HIPHeight":"","GPBGColor":"#f8f8f8","GPFontSize":"15","GPFontWeight":"bold","GPWidth":"50","GTPWidth":"60","GPAlign":"center","GPBackground":"","GPBackgroundRepeat":"no-repeat","GPBGPosition1":"","GPBGPosition2":"","GPBGSize1":"","GPBGSize2":"","GPColor":"#3b3b3b","GPPadding":"10px","GPMargin":"","GPBorderColor":"#ffffff","GPBorderType":"solid","GPBorderWidth":"1","GPBorderRadius":"0","GPMLFontSize":"14","GPMLFontWeight":"normal","GPMLColor":"#3b3b3b","GPMLPadding":"0px 5px 0px 0px","GPMLMargin":"0px","SEPBGColor":"#f8f8f8","SEPPadding":"","SEPMargin":"","COPPadding":"10px","COPMargin":"0px","FPWidth":"80","FPPadding":"15px 0 0 0","FPMargin":"0 auto","IPHeight":"26","IPFontSize":"13","IPFontWeight":"normal","IPBGColor":"#ffffff","IPColor":"#6e6e6e","IPPadding":"0px 5px","IPMargin":"0px","IPBorderTop":"top","IPBorderRight":"right","IPBorderBottom":"bottom","IPBorderLeft":"left","IPBorderColor":"#989898","IPBorderType":"solid","IPBorderWidth":"1","IPBorderRadius":"0","IPBoxShadow":"","SBPAppearance":"none","SBPBackground":"images/themes/drop-downs/3.png","SBPBGRepeat":"no-repeat","SBPBGPos1":"95%","SBPBGPos2":"50%","SBPBGSize1":"8%","SBPBGSize2":"32%","SCPBGColor":"","SCPWidth":"14","SCPHeight":"14","SCPBorderTop":"top","SCPBorderRight":"right","SCPBorderBottom":"bottom","SCPBorderLeft":"left","SCPBorderColor":"#989898","SCPBorderType":"solid","SCPBorderWidth":"1","SCPMargin":"0px 3px","SCPBorderRadius":"15","SCPBoxShadow":"","SCCPBGColor":"#989898","SCCPWidth":"6","SCCPHeight":"6","SCCPMargin":"4","SCCPBorderRadius":"10","MCPBGColor":"","MCPWidth":"14","MCPHeight":"14","MCPBorderTop":"top","MCPBorderRight":"right","MCPBorderBottom":"bottom","MCPBorderLeft":"left","MCPBorderColor":"#989898","MCPBorderType":"solid","MCPBorderWidth":"1","MCPMargin":"0px 3px","MCPBorderRadius":"0","MCPBoxShadow":"","MCCPBGColor":"","MCCPBackground":"images/themes/checkboxes/3.png","MCCPBGRepeat":"no-repeat","MCCPBGPos1":"","MCCPBGPos2":"","MCCPWidth":"16","MCCPHeight":"16","MCCPMargin":"0 0 2px 0","MCCPBorderRadius":"0","SPAlign":"right","SPBGColor":"#f05e22","SPWidth":"","SPHeight":"","SPFontSize":"15","SPFontWeight":"normal","SPColor":"#ffffff","SPPadding":"6px 10px","SPMargin":"","SPBorderColor":"#9eaab1","SPBorderType":"solid","SPBorderWidth":"1","SPBorderRadius":"0","SPBoxShadow":"2px 2px 2px #9eaab1","SHPBGColor":"#d82534","SHPColor":"#ffffff","SHPBorderColor":"#ffffff","SHPBorderType":"solid","SHPBorderWidth":"1","BPBGColor":"#f1cb15","BPWidth":"","BPHeight":"","BPFontSize":"15","BPFontWeight":"normal","BPColor":"#424242","BPPadding":"6px 10px","BPMargin":"0 15px 0 0 ","BPBorderColor":"#ffffff","BPBorderType":"solid","BPBorderWidth":"1","BPBorderRadius":"0","BPBoxShadow":"2px 2px 2px #9eaab1","BHPBGColor":"#435c71","BHPColor":"#e6c41b","BHPBorderColor":"#ffffff","BHPBorderType":"solid","BHPBorderWidth":"1","PSAPBGColor":"#f05e22","PSAPFontSize":"16","PSAPFontWeight":"normal","PSAPColor":"#ffffff","PSAPHeight":"","PSAPLineHeight":"","PSAPPadding":"8px","PSAPMargin":"0","PSAPBorderColor":"","PSAPBorderType":"solid","PSAPBorderWidth":"2","PSAPBorderRadius":"3","PSDPBGColor":"#ffffff","PSDPFontSize":"16","PSDPFontWeight":"bold","PSDPColor":"#435c71","PSDPHeight":"","PSDPLineHeight":"","PSDPPadding":"4px 6px","PSDPMargin":"0 0 0 -3px","PSDPBorderTop":"top","PSDPBorderRight":"right","PSDPBorderBottom":"bottom","PSDPBorderLeft":"left","PSDPBorderColor":"#435c71","PSDPBorderType":"solid","PSDPBorderWidth":"1","PSDPBorderRadius":"3","PSAPAlign":"right","PSAPWidth":"","PPAPWidth":"100%","NBPBGColor":"","NBPWidth":"","NBPHeight":"","NBPLineHeight":"","NBPColor":"#3b3b3b","NBPPadding":"4px 10px","NBPMargin":"0px","NBPBorderColor":"#777777","NBPBorderType":"solid","NBPBorderWidth":"1","NBPBorderRadius":"0","NBPBoxShadow":"","NBHPBGColor":"","NBHPColor":"#d82534","NBHPBorderColor":"#787878","NBHPBorderType":"solid","NBHPBorderWidth":"1","PBPBGColor":"","PBPWidth":"100","PBPHeight":"","PBPLineHeight":"","PBPColor":"#3b3b3b","PBPPadding":"","PBPMargin":"0px","PBPBorderColor":"#777777","PBPBorderType":"solid","PBPBorderWidth":"1","PBPBorderRadius":"0","PBPBoxShadow":"","PBHPBGColor":"","PBHPColor":"#d82534","PBHPBorderColor":"#787878","PBHPBorderType":"solid","PBHPBorderWidth":"1","CBPPosition":"absolute","CBPTop":"10px","CBPRight":"10px","CBPBottom":"","CBPLeft":"","CBPBGColor":"","CBPFontSize":"16","CBPFontWeight":"lighter","CBPColor":"#e6c41b","CBPPadding":"0px","CBPMargin":"0px","CBPBorderColor":"#ffffff","CBPBorderType":"solid","CBPBorderWidth":"1","CBPBorderRadius":"0","CBHPBGColor":"","CBHPColor":"#d82534","CBHPBorderColor":"#ffffff","CBHPBorderType":"solid","CBHPBorderWidth":"1","MBPBGColor":"#4d4d4d","MBPFontSize":"16","MBPFontWeight":"normal","MBPColor":"#ffffff","MBPTextAlign":"center","MBPPadding":"10px","MBPMargin":"","MBPBorderTop":"top","MBPBorderRight":"right","MBPBorderBottom":"bottom","MBPBorderLeft":"left","MBPBorderColor":"#4d4d4d","MBPBorderType":"solid","MBPBorderWidth":"2","MBPBorderRadius":"0","MBHPBGColor":"#ffffff","MBHPColor":"#f05e22","MBHPBorderTop":"top","MBHPBorderRight":"right","MBHPBorderBottom":"bottom","MBHPBorderLeft":"left","MBHPBorderColor":"#f05e22","MBHPBorderType":"solid","MBHPBorderWidth":"2","OPDeInputColor":"#afafaf","OPFontStyle":"normal","OPRColor":"#f05e22","OPDPIcon":"images/themes/date-pickers/2.png","OPDPRepeat":"no-repeat","OPDPPos1":"0%","OPDPPos2":"10%","OPDPMargin":"3px 0 0 -23px","OPFBgUrl":"images/themes/file-uploads/2.png","OPFBGRepeat":"no-repeat","OPFPos1":"0%","OPFPos2":"10%","OPGWidth":"100","CUPCSS":""}\', 0, 2);');
      $wpdb->query('INSERT INTO `' . $wpdb->prefix . 'formmaker_themes` (`title`, `css`, `default`, `version`) VALUES ("Theme 10", \'{"GPFontFamily":"arial","AGPWidth":"100","AGPSPWidth":"35","AGPPadding":"","AGPMargin":"10px auto","AGPBorderTop":"top","AGPBorderRight":"right","AGPBorderBottom":"bottom","AGPBorderLeft":"left","AGPBorderColor":"#00bff3","AGPBorderType":"solid","AGPBorderWidth":"1","AGPBorderRadius":"0","AGPBoxShadow":"","HPAlign":"top","HPBGColor":"#00bff3","HPWidth":"100","HTPWidth":"30","HPPadding":"10px","HPMargin":"","HPTextAlign":"left","HPBorderColor":"#b7b7b7","HPBorderType":"solid","HPBorderWidth":"1","HPBorderRadius":"0","HTPFontSize":"25","HTPWeight":"bold","HTPColor":"#ffffff","HDPFontSize":"14","HDPColor":"#ffffff","HIPAlign":"left","HIPWidth":"41","HIPHeight":"31","GPBGColor":"#ffffff","GPFontSize":"15","GPFontWeight":"normal","GPWidth":"100","GTPWidth":"100","GPAlign":"left","GPBackground":"","GPBackgroundRepeat":"no-repeat","GPBGPosition1":"","GPBGPosition2":"","GPBGSize1":"","GPBGSize2":"","GPColor":"#494949","GPPadding":"15px 15px","GPMargin":"","GPBorderColor":"#ffffff","GPBorderType":"solid","GPBorderWidth":"1","GPBorderRadius":"0","GPMLFontSize":"14","GPMLFontWeight":"normal","GPMLColor":"#494949","GPMLPadding":"0px 5px 0px 0px","GPMLMargin":"0px","SEPBGColor":"#ffffff","SEPPadding":"","SEPMargin":"","COPPadding":"10px 20px 10px 10px","COPMargin":"0px","FPWidth":"80","FPPadding":"15px 0 0 0","FPMargin":"0 auto","IPHeight":"30","IPFontSize":"13","IPFontWeight":"normal","IPBGColor":"#ffffff","IPColor":"#6e6e6e","IPPadding":"6px 6px","IPMargin":"0px","IPBorderTop":"top","IPBorderRight":"right","IPBorderBottom":"bottom","IPBorderLeft":"left","IPBorderColor":"#00bff3","IPBorderType":"solid","IPBorderWidth":"1","IPBorderRadius":"0","IPBoxShadow":"","SBPAppearance":"none","SBPBackground":"images/themes/drop-downs/3.png","SBPBGRepeat":"no-repeat","SBPBGPos1":"95%","SBPBGPos2":"50%","SBPBGSize1":"8%","SBPBGSize2":"32%","SCPBGColor":"","SCPWidth":"14","SCPHeight":"14","SCPBorderTop":"top","SCPBorderRight":"right","SCPBorderBottom":"bottom","SCPBorderLeft":"left","SCPBorderColor":"#00bff3","SCPBorderType":"solid","SCPBorderWidth":"1","SCPMargin":"0px 3px","SCPBorderRadius":"15","SCPBoxShadow":"","SCCPBGColor":"#989898","SCCPWidth":"6","SCCPHeight":"6","SCCPMargin":"4","SCCPBorderRadius":"10","MCPBGColor":"","MCPWidth":"14","MCPHeight":"14","MCPBorderTop":"top","MCPBorderRight":"right","MCPBorderBottom":"bottom","MCPBorderLeft":"left","MCPBorderColor":"#00bff3","MCPBorderType":"solid","MCPBorderWidth":"1","MCPMargin":"0px 3px","MCPBorderRadius":"0","MCPBoxShadow":"","MCCPBGColor":"","MCCPBackground":"images/themes/checkboxes/3.png","MCCPBGRepeat":"no-repeat","MCCPBGPos1":"","MCCPBGPos2":"","MCCPWidth":"16","MCCPHeight":"16","MCCPMargin":"0 0 2px 0","MCCPBorderRadius":"0","SPAlign":"right","SPBGColor":"#000000","SPWidth":"","SPHeight":"","SPFontSize":"15","SPFontWeight":"normal","SPColor":"#ffffff","SPPadding":"5px 10px","SPMargin":"","SPBorderColor":"#b0b5b8","SPBorderType":"solid","SPBorderWidth":"1","SPBorderRadius":"6","SPBoxShadow":"2px 2px 2px #b0b5b8","SHPBGColor":"#000000","SHPColor":"#ffffff","SHPBorderColor":"#ffffff","SHPBorderType":"solid","SHPBorderWidth":"1","BPBGColor":"#dfc97a","BPWidth":"","BPHeight":"","BPFontSize":"15","BPFontWeight":"normal","BPColor":"#272727","BPPadding":"15px 20px","BPMargin":"0 15px 0 0 ","BPBorderColor":"#ffffff","BPBorderType":"solid","BPBorderWidth":"1","BPBorderRadius":"0","BPBoxShadow":"2px 2px 2px #b0b5b8","BHPBGColor":"#2d4d5f","BHPColor":"#ffffff","BHPBorderColor":"#ffffff","BHPBorderType":"solid","BHPBorderWidth":"1","PSAPBGColor":"#139e92","PSAPFontSize":"16","PSAPFontWeight":"normal","PSAPColor":"#ffffff","PSAPHeight":"","PSAPLineHeight":"","PSAPPadding":"8px","PSAPMargin":"0","PSAPBorderColor":"","PSAPBorderType":"solid","PSAPBorderWidth":"2","PSAPBorderRadius":"3","PSDPBGColor":"#f8f8f8","PSDPFontSize":"16","PSDPFontWeight":"normal","PSDPColor":"#272727","PSDPHeight":"","PSDPLineHeight":"","PSDPPadding":"4px 6px","PSDPMargin":"0 0 0 -3px","PSDPBorderTop":"top","PSDPBorderRight":"right","PSDPBorderBottom":"bottom","PSDPBorderLeft":"left","PSDPBorderColor":"#dfc97a","PSDPBorderType":"solid","PSDPBorderWidth":"1","PSDPBorderRadius":"3","PSAPAlign":"right","PSAPWidth":"","PPAPWidth":"100%","NBPBGColor":"","NBPWidth":"","NBPHeight":"","NBPLineHeight":"","NBPColor":"#3b3b3b","NBPPadding":"4px 10px","NBPMargin":"0px","NBPBorderColor":"#777777","NBPBorderType":"solid","NBPBorderWidth":"1","NBPBorderRadius":"0","NBPBoxShadow":"","NBHPBGColor":"","NBHPColor":"#137065","NBHPBorderColor":"#787878","NBHPBorderType":"solid","NBHPBorderWidth":"1","PBPBGColor":"","PBPWidth":"100","PBPHeight":"","PBPLineHeight":"","PBPColor":"#3b3b3b","PBPPadding":"","PBPMargin":"0px","PBPBorderColor":"#777777","PBPBorderType":"solid","PBPBorderWidth":"1","PBPBorderRadius":"0","PBPBoxShadow":"","PBHPBGColor":"","PBHPColor":"#137065","PBHPBorderColor":"#787878","PBHPBorderType":"solid","PBHPBorderWidth":"1","CBPPosition":"absolute","CBPTop":"10px","CBPRight":"10px","CBPBottom":"","CBPLeft":"","CBPBGColor":"","CBPFontSize":"16","CBPFontWeight":"lighter","CBPColor":"#757575","CBPPadding":"0px","CBPMargin":"0px","CBPBorderColor":"#ffffff","CBPBorderType":"solid","CBPBorderWidth":"1","CBPBorderRadius":"0","CBHPBGColor":"","CBHPColor":"#139e92","CBHPBorderColor":"#ffffff","CBHPBorderType":"solid","CBHPBorderWidth":"1","MBPBGColor":"#139e92","MBPFontSize":"16","MBPFontWeight":"normal","MBPColor":"#ffffff","MBPTextAlign":"center","MBPPadding":"10px","MBPMargin":"","MBPBorderTop":"top","MBPBorderRight":"right","MBPBorderBottom":"bottom","MBPBorderLeft":"left","MBPBorderColor":"#139e92","MBPBorderType":"solid","MBPBorderWidth":"2","MBPBorderRadius":"0","MBHPBGColor":"#ffffff","MBHPColor":"#137065","MBHPBorderTop":"top","MBHPBorderRight":"right","MBHPBorderBottom":"bottom","MBHPBorderLeft":"left","MBHPBorderColor":"#137065","MBHPBorderType":"solid","MBHPBorderWidth":"2","OPDeInputColor":"#afafaf","OPFontStyle":"normal","OPRColor":"#f82c2c","OPDPIcon":"images/themes/date-pickers/2.png","OPDPRepeat":"no-repeat","OPDPPos1":"0%","OPDPPos2":"10%","OPDPMargin":"3px 0 0 -23px","OPFBgUrl":"images/themes/file-uploads/2.png","OPFBGRepeat":"no-repeat","OPFPos1":"0%","OPFPos2":"10%","OPGWidth":"100","CUPCSS":"div[type=\\\\"type_section_break\\\\"] {\\\\r\\\\n  display: none !important;\\\\r\\\\n}\\\\r\\\\ndiv[wdid=\\\\"12\\\\"] {\\\\r\\\\n    border: 1px solid #00bff3;\\\\r\\\\n    padding: 10px 30px 0px;\\\\r\\\\n}\\\\r\\\\ninput.time_box {\\\\r\\\\n  width: 40px;\\\\r\\\\n}"}\', 0, 2);');
      $wpdb->query('INSERT INTO `' . $wpdb->prefix . 'formmaker_themes` (`title`, `css`, `default`, `version`) VALUES ("Theme 11", \'{"GPFontFamily":"Roboto","AGPWidth":"100","AGPSPWidth":"40","AGPPadding":"","AGPMargin":"10px auto","AGPBorderColor":"#ffffff","AGPBorderType":"solid","AGPBorderWidth":"1","AGPBorderRadius":"0","AGPBoxShadow":"","HPAlign":"top","HPBGColor":"#f2ecde","HPWidth":"100","HTPWidth":"40","HPPadding":"10px 15px","HPMargin":"","HPTextAlign":"left","HPBorderTop":"top","HPBorderColor":"#7a134b","HPBorderType":"solid","HPBorderWidth":"4","HPBorderRadius":"0","HTPFontSize":"19","HTPWeight":"bold","HTPColor":"#042325","HDPFontSize":"14","HDPColor":"#8a877f","HIPAlign":"right","HIPWidth":"80","HIPHeight":"","GPBGColor":"#d8d5c6","GPFontSize":"14","GPFontWeight":"normal","GPWidth":"100","GTPWidth":"60","GPAlign":"center","GPBackground":"","GPBackgroundRepeat":"no-repeat","GPBGPosition1":"","GPBGPosition2":"","GPBGSize1":"","GPBGSize2":"","GPColor":"#37352f","GPPadding":"10px","GPMargin":"","GPBorderColor":"#ffffff","GPBorderType":"solid","GPBorderWidth":"1","GPBorderRadius":"0","GPMLFontSize":"14","GPMLFontWeight":"normal","GPMLColor":"#37352f","GPMLPadding":"0px 5px 0px 0px","GPMLMargin":"0px","SEPBGColor":"#d8d5c6","SEPPadding":"","SEPMargin":"","COPPadding":"10px","COPMargin":"0px","FPWidth":"70","FPPadding":"15px 0 0 0","FPMargin":"0 auto","IPHeight":"28","IPFontSize":"13","IPFontWeight":"normal","IPBGColor":"#b7b3a7","IPColor":"#ffffff","IPPadding":"0px 5px","IPMargin":"0px","IPBorderTop":"top","IPBorderRight":"right","IPBorderBottom":"bottom","IPBorderLeft":"left","IPBorderColor":"#b7b3a7","IPBorderType":"solid","IPBorderWidth":"1","IPBorderRadius":"0","IPBoxShadow":"","SBPAppearance":"none","SBPBackground":"images/themes/drop-downs/2.png","SBPBGRepeat":"no-repeat","SBPBGPos1":"95%","SBPBGPos2":"50%","SBPBGSize1":"8%","SBPBGSize2":"32%","SCPBGColor":"#ffffff","SCPWidth":"14","SCPHeight":"14","SCPBorderTop":"top","SCPBorderRight":"right","SCPBorderBottom":"bottom","SCPBorderLeft":"left","SCPBorderColor":"#7a134b","SCPBorderType":"solid","SCPBorderWidth":"1","SCPMargin":"0px 3px","SCPBorderRadius":"15","SCPBoxShadow":"","SCCPBGColor":"#7a134b","SCCPWidth":"6","SCCPHeight":"6","SCCPMargin":"4","SCCPBorderRadius":"10","MCPBGColor":"#ffffff","MCPWidth":"12","MCPHeight":"12","MCPBorderTop":"top","MCPBorderRight":"right","MCPBorderBottom":"bottom","MCPBorderLeft":"left","MCPBorderColor":"#7a134b","MCPBorderType":"solid","MCPBorderWidth":"1","MCPMargin":"0px 3px","MCPBorderRadius":"0","MCPBoxShadow":"","MCCPBGColor":"#7a134b","MCCPBackground":"","MCCPBGRepeat":"no-repeat","MCCPBGPos1":"","MCCPBGPos2":"","MCCPWidth":"8","MCCPHeight":"8","MCCPMargin":"2","MCCPBorderRadius":"0","SPAlign":"left","SPBGColor":"#7a134b","SPWidth":"130","SPHeight":"28","SPFontSize":"14","SPFontWeight":"normal","SPColor":"#ffffff","SPPadding":"0px 5px","SPMargin":"0 10px 0 0","SPBorderTop":"top","SPBorderRight":"right","SPBorderBottom":"bottom","SPBorderLeft":"left","SPBorderColor":"#7a134b","SPBorderType":"solid","SPBorderWidth":"1","SPBorderRadius":"0","SPBoxShadow":"","SHPBGColor":"#630538","SHPColor":"#ffffff","SHPBorderTop":"top","SHPBorderRight":"right","SHPBorderBottom":"bottom","SHPBorderLeft":"left","SHPBorderColor":"#630538","SHPBorderType":"solid","SHPBorderWidth":"1","BPBGColor":"#f2ecde","BPWidth":"60","BPHeight":"28","BPFontSize":"14","BPFontWeight":"normal","BPColor":"#37352f","BPPadding":"0px 5px","BPMargin":"0 15px 0 0","BPBorderTop":"top","BPBorderRight":"right","BPBorderBottom":"bottom","BPBorderLeft":"left","BPBorderColor":"#f2ecde","BPBorderType":"solid","BPBorderWidth":"1","BPBorderRadius":"0","BPBoxShadow":"","BHPBGColor":"#f2ecde","BHPColor":"#37352f","BHPBorderTop":"top","BHPBorderRight":"right","BHPBorderBottom":"bottom","BHPBorderLeft":"left","BHPBorderColor":"#f2ecde","BHPBorderType":"solid","BHPBorderWidth":"1","PSAPBGColor":"#7a134b","PSAPFontSize":"14","PSAPFontWeight":"normal","PSAPColor":"#ffffff","PSAPHeight":"","PSAPLineHeight":"","PSAPPadding":"8px","PSAPMargin":"0 0 -2px  0","PSAPBorderTop":"top","PSAPBorderRight":"right","PSAPBorderLeft":"left","PSAPBorderColor":"#7a134b","PSAPBorderType":"solid","PSAPBorderWidth":"3","PSAPBorderRadius":"0","PSDPBGColor":"#f2ecde","PSDPFontSize":"14","PSDPFontWeight":"normal","PSDPColor":"#000000","PSDPHeight":"","PSDPLineHeight":"","PSDPPadding":"8px","PSDPMargin":"0 0 0 -3px","PSDPBorderColor":"#a3a3a3","PSDPBorderType":"solid","PSDPBorderWidth":"2","PSDPBorderRadius":"","PSAPAlign":"left","PSAPWidth":"","PPAPWidth":"100%","NBPBGColor":"","NBPWidth":"","NBPHeight":"","NBPLineHeight":"","NBPColor":"#7a134b","NBPPadding":"4px 10px","NBPMargin":"0px","NBPBorderColor":"#777777","NBPBorderType":"solid","NBPBorderWidth":"1","NBPBorderRadius":"0","NBPBoxShadow":"","NBHPBGColor":"","NBHPColor":"#630538","NBHPBorderColor":"#787878","NBHPBorderType":"solid","NBHPBorderWidth":"1","PBPBGColor":"","PBPWidth":"100","PBPHeight":"","PBPLineHeight":"","PBPColor":"#7a134b","PBPPadding":"","PBPMargin":"0px","PBPBorderColor":"#777777","PBPBorderType":"solid","PBPBorderWidth":"1","PBPBorderRadius":"0","PBPBoxShadow":"","PBHPBGColor":"","PBHPColor":"#630538","PBHPBorderColor":"#787878","PBHPBorderType":"solid","PBHPBorderWidth":"1","CBPPosition":"absolute","CBPTop":"10px","CBPRight":"6px","CBPBottom":"","CBPLeft":"","CBPBGColor":"","CBPFontSize":"18","CBPFontWeight":"normal","CBPColor":"#7a134b","CBPPadding":"0px","CBPMargin":"0px","CBPBorderColor":"#ffffff","CBPBorderType":"solid","CBPBorderWidth":"1","CBPBorderRadius":"0","CBHPBGColor":"","CBHPColor":"#630538","CBHPBorderColor":"#737373","CBHPBorderType":"solid","CBHPBorderWidth":"1","MBPBGColor":"#f2ecde","MBPFontSize":"15","MBPFontWeight":"normal","MBPColor":"#000000","MBPTextAlign":"center","MBPPadding":"10px","MBPMargin":"","MBPBorderTop":"top","MBPBorderColor":"#7a134b","MBPBorderType":"solid","MBPBorderWidth":"2","MBPBorderRadius":"0","MBHPBGColor":"#f2ecde","MBHPColor":"#7a134b","MBHPBorderTop":"top","MBHPBorderColor":"#7a134b","MBHPBorderType":"solid","MBHPBorderWidth":"2","OPDeInputColor":"#ffffff","OPFontStyle":"normal","OPRColor":"#ff1313","OPDPIcon":"images/themes/date-pickers/2.png","OPDPRepeat":"no-repeat","OPDPPos1":"0%","OPDPPos2":"10%","OPDPMargin":"3px 0 0 -23px","OPFBgUrl":"images/themes/file-uploads/2.png","OPFBGRepeat":"no-repeat","OPFPos1":"0%","OPFPos2":"10%","OPGWidth":"100","CUPCSS":""}\', 0, 2);');
      $wpdb->query('INSERT INTO `' . $wpdb->prefix . 'formmaker_themes` (`title`, `css`, `default`, `version`) VALUES ("Theme 12", \'{"GPFontFamily":"trebuchet ms","AGPWidth":"100","AGPSPWidth":"40","AGPPadding":"","AGPMargin":"10px auto","AGPBorderColor":"#ffffff","AGPBorderType":"solid","AGPBorderWidth":"1","AGPBorderRadius":"0","AGPBoxShadow":"","HPAlign":"top","HPBGColor":"#5d98b1","HPWidth":"100","HTPWidth":"40","HPPadding":"10px 15px","HPMargin":"","HPTextAlign":"left","HPBorderTop":"top","HPBorderColor":"#ffffff","HPBorderType":"solid","HPBorderWidth":"5","HPBorderRadius":"0","HTPFontSize":"22","HTPWeight":"bold","HTPColor":"#ffffff","HDPFontSize":"14","HDPColor":"#ffffff","HIPAlign":"left","HIPWidth":"80","HIPHeight":"","GPBGColor":"#36748e","GPFontSize":"15","GPFontWeight":"normal","GPWidth":"100","GTPWidth":"60","GPAlign":"center","GPBackground":"","GPBackgroundRepeat":"no-repeat","GPBGPosition1":"","GPBGPosition2":"","GPBGSize1":"","GPBGSize2":"","GPColor":"#ffffff","GPPadding":"10px","GPMargin":"","GPBorderColor":"#ffffff","GPBorderType":"solid","GPBorderWidth":"1","GPBorderRadius":"0","GPMLFontSize":"14","GPMLFontWeight":"normal","GPMLColor":"#ffffff","GPMLPadding":"0px 5px 0px 0px","GPMLMargin":"0px","SEPBGColor":"#36748e","SEPPadding":"","SEPMargin":"","COPPadding":"10px","COPMargin":"0px","FPWidth":"70","FPPadding":"15px 0 0 0","FPMargin":"0 auto","IPHeight":"28","IPFontSize":"13","IPFontWeight":"normal","IPBGColor":"#204a5c","IPColor":"#ffffff","IPPadding":"0px 5px","IPMargin":"0px","IPBorderTop":"top","IPBorderRight":"right","IPBorderBottom":"bottom","IPBorderLeft":"left","IPBorderColor":"#204a5c","IPBorderType":"solid","IPBorderWidth":"1","IPBorderRadius":"0","IPBoxShadow":"","SBPAppearance":"none","SBPBackground":"images/themes/drop-downs/2.png","SBPBGRepeat":"no-repeat","SBPBGPos1":"95%","SBPBGPos2":"50%","SBPBGSize1":"8%","SBPBGSize2":"32%","SCPBGColor":"#204a5c","SCPWidth":"14","SCPHeight":"14","SCPBorderTop":"top","SCPBorderRight":"right","SCPBorderBottom":"bottom","SCPBorderLeft":"left","SCPBorderColor":"#204a5c","SCPBorderType":"solid","SCPBorderWidth":"1","SCPMargin":"0px 3px","SCPBorderRadius":"15","SCPBoxShadow":"","SCCPBGColor":"#ffffff","SCCPWidth":"6","SCCPHeight":"6","SCCPMargin":"4","SCCPBorderRadius":"10","MCPBGColor":"#204a5c","MCPWidth":"12","MCPHeight":"12","MCPBorderTop":"top","MCPBorderRight":"right","MCPBorderBottom":"bottom","MCPBorderLeft":"left","MCPBorderColor":"#204a5c","MCPBorderType":"solid","MCPBorderWidth":"1","MCPMargin":"0px 3px","MCPBorderRadius":"0","MCPBoxShadow":"","MCCPBGColor":"#ffffff","MCCPBackground":"","MCCPBGRepeat":"no-repeat","MCCPBGPos1":"","MCCPBGPos2":"","MCCPWidth":"8","MCCPHeight":"8","MCCPMargin":"2","MCCPBorderRadius":"0","SPAlign":"left","SPBGColor":"#1e6466","SPWidth":"130","SPHeight":"28","SPFontSize":"14","SPFontWeight":"normal","SPColor":"#ffffff","SPPadding":"0px 5px","SPMargin":"0 10px 0 0","SPBorderTop":"top","SPBorderRight":"right","SPBorderBottom":"bottom","SPBorderLeft":"left","SPBorderColor":"#1e6466","SPBorderType":"solid","SPBorderWidth":"1","SPBorderRadius":"0","SPBoxShadow":"","SHPBGColor":"#268285","SHPColor":"#ffffff","SHPBorderTop":"top","SHPBorderRight":"right","SHPBorderBottom":"bottom","SHPBorderLeft":"left","SHPBorderColor":"#268285","SHPBorderType":"solid","SHPBorderWidth":"1","BPBGColor":"#d4d4d4","BPWidth":"60","BPHeight":"28","BPFontSize":"15","BPFontWeight":"normal","BPColor":"#11393a","BPPadding":"0px 5px","BPMargin":"0 15px 0 0","BPBorderTop":"top","BPBorderRight":"right","BPBorderBottom":"bottom","BPBorderLeft":"left","BPBorderColor":"#d4d4d4","BPBorderType":"solid","BPBorderWidth":"1","BPBorderRadius":"0","BPBoxShadow":"","BHPBGColor":"#f2ecde","BHPColor":"#37352f","BHPBorderTop":"top","BHPBorderRight":"right","BHPBorderBottom":"bottom","BHPBorderLeft":"left","BHPBorderColor":"#f2ecde","BHPBorderType":"solid","BHPBorderWidth":"1","PSAPBGColor":"#268285","PSAPFontSize":"14","PSAPFontWeight":"bold","PSAPColor":"#ffffff","PSAPHeight":"","PSAPLineHeight":"","PSAPPadding":"10px","PSAPMargin":"0","PSAPBorderColor":"","PSAPBorderType":"solid","PSAPBorderWidth":"4","PSAPBorderRadius":"0","PSDPBGColor":"#d4d4d4","PSDPFontSize":"14","PSDPFontWeight":"normal","PSDPColor":"#100e0e","PSDPHeight":"","PSDPLineHeight":"","PSDPPadding":"8px","PSDPMargin":"0 0 0 -3px","PSDPBorderColor":"#a3a3a3","PSDPBorderType":"solid","PSDPBorderWidth":"2","PSDPBorderRadius":"","PSAPAlign":"center","PSAPWidth":"","PPAPWidth":"100%","NBPBGColor":"","NBPWidth":"","NBPHeight":"","NBPLineHeight":"","NBPColor":"#132d39","NBPPadding":"4px 10px","NBPMargin":"0px","NBPBorderColor":"#777777","NBPBorderType":"solid","NBPBorderWidth":"1","NBPBorderRadius":"0","NBPBoxShadow":"","NBHPBGColor":"","NBHPColor":"#132d39","NBHPBorderColor":"#787878","NBHPBorderType":"solid","NBHPBorderWidth":"1","PBPBGColor":"","PBPWidth":"100","PBPHeight":"","PBPLineHeight":"","PBPColor":"#132d39","PBPPadding":"","PBPMargin":"0px","PBPBorderColor":"#777777","PBPBorderType":"solid","PBPBorderWidth":"1","PBPBorderRadius":"0","PBPBoxShadow":"","PBHPBGColor":"","PBHPColor":"#132d39","PBHPBorderColor":"#787878","PBHPBorderType":"solid","PBHPBorderWidth":"1","CBPPosition":"absolute","CBPTop":"15px","CBPRight":"6px","CBPBottom":"","CBPLeft":"","CBPBGColor":"","CBPFontSize":"18","CBPFontWeight":"normal","CBPColor":"#1e6466","CBPPadding":"0px","CBPMargin":"0px","CBPBorderColor":"#ffffff","CBPBorderType":"solid","CBPBorderWidth":"1","CBPBorderRadius":"0","CBHPBGColor":"","CBHPColor":"#204a5c","CBHPBorderColor":"#737373","CBHPBorderType":"solid","CBHPBorderWidth":"1","MBPBGColor":"#204a5c","MBPFontSize":"15","MBPFontWeight":"normal","MBPColor":"#ffffff","MBPTextAlign":"center","MBPPadding":"10px","MBPMargin":"","MBPBorderTop":"top","MBPBorderRight":"right","MBPBorderBottom":"bottom","MBPBorderLeft":"left","MBPBorderColor":"#204a5c","MBPBorderType":"solid","MBPBorderWidth":"2","MBPBorderRadius":"0","MBHPBGColor":"#5d98b1","MBHPColor":"#ffffff","MBHPBorderTop":"top","MBHPBorderRight":"right","MBHPBorderBottom":"bottom","MBHPBorderLeft":"left","MBHPBorderColor":"#5d98b1","MBHPBorderType":"solid","MBHPBorderWidth":"2","OPDeInputColor":"#ffffff","OPFontStyle":"normal","OPRColor":"#ff1313","OPDPIcon":"images/themes/date-pickers/5.png","OPDPRepeat":"no-repeat","OPDPPos1":"0%","OPDPPos2":"10%","OPDPMargin":"3px 0 0 -23px","OPFBgUrl":"images/themes/file-uploads/2.png","OPFBGRepeat":"no-repeat","OPFPos1":"0%","OPFPos2":"10%","OPGWidth":"100","CUPCSS":""}\', 0, 2);');
      $wpdb->query('INSERT INTO `' . $wpdb->prefix . 'formmaker_themes` (`title`, `css`, `default`, `version`) VALUES ("Theme 13", \'{"GPFontFamily":"tahoma","AGPWidth":"100","AGPSPWidth":"20","AGPPadding":"","AGPMargin":"10px auto","AGPBorderColor":"#ffffff","AGPBorderType":"solid","AGPBorderWidth":"1","AGPBorderRadius":"0","AGPBoxShadow":"","HPAlign":"top","HPBGColor":"#43aeab","HPWidth":"100","HTPWidth":"40","HPPadding":"20px 0","HPMargin":"0","HPTextAlign":"center","HPBorderColor":"#b7b7b7","HPBorderType":"solid","HPBorderWidth":"1","HPBorderRadius":"0","HTPFontSize":"20","HTPWeight":"normal","HTPColor":"#ffffff","HDPFontSize":"13","HDPColor":"#ffffff","HIPAlign":"top","HIPWidth":"80","HIPHeight":"","GPBGColor":"#ffffff","GPFontSize":"15","GPFontWeight":"normal","GPWidth":"100","GTPWidth":"60","GPAlign":"center","GPBackground":"","GPBackgroundRepeat":"no-repeat","GPBGPosition1":"","GPBGPosition2":"","GPBGSize1":"","GPBGSize2":"","GPColor":"#676767","GPPadding":"10px 0","GPMargin":"","GPBorderColor":"#ffffff","GPBorderType":"solid","GPBorderWidth":"1","GPBorderRadius":"0","GPMLFontSize":"14","GPMLFontWeight":"normal","GPMLColor":"#9c9c9c","GPMLPadding":"0px 5px 0px 0px","GPMLMargin":"0px","SEPBGColor":"#ffffff","SEPPadding":"","SEPMargin":"","COPPadding":"15px 20px","COPMargin":"0px","FPWidth":"70","FPPadding":"15px 0 0 0","FPMargin":"0 auto","IPHeight":"28","IPFontSize":"14","IPFontWeight":"normal","IPBGColor":"#e4e4e4","IPColor":"#9a9a9a","IPPadding":"0px 5px","IPMargin":"0px","IPBorderTop":"top","IPBorderRight":"right","IPBorderBottom":"bottom","IPBorderLeft":"left","IPBorderColor":"#e4e4e4","IPBorderType":"solid","IPBorderWidth":"1","IPBorderRadius":"0","IPBoxShadow":"","SBPAppearance":"none","SBPBackground":"images/themes/drop-downs/2.png","SBPBGRepeat":"no-repeat","SBPBGPos1":"95%","SBPBGPos2":"50%","SBPBGSize1":"8%","SBPBGSize2":"32%","SCPBGColor":"#ffffff","SCPWidth":"16","SCPHeight":"16","SCPBorderTop":"top","SCPBorderRight":"right","SCPBorderBottom":"bottom","SCPBorderLeft":"left","SCPBorderColor":"#868686","SCPBorderType":"solid","SCPBorderWidth":"1","SCPMargin":"0px 3px","SCPBorderRadius":"15","SCPBoxShadow":"","SCCPBGColor":"#868686","SCCPWidth":"6","SCCPHeight":"6","SCCPMargin":"5","SCCPBorderRadius":"10","MCPBGColor":"#ffffff","MCPWidth":"16","MCPHeight":"16","MCPBorderTop":"top","MCPBorderRight":"right","MCPBorderBottom":"bottom","MCPBorderLeft":"left","MCPBorderColor":"#868686","MCPBorderType":"solid","MCPBorderWidth":"1","MCPMargin":"0px 3px","MCPBorderRadius":"0","MCPBoxShadow":"","MCCPBGColor":"","MCCPBackground":"images/themes/checkboxes/1.png","MCCPBGRepeat":"no-repeat","MCCPBGPos1":"","MCCPBGPos2":"","MCCPWidth":"16","MCCPHeight":"16","MCCPMargin":"0","MCCPBorderRadius":"0","SPAlign":"left","SPBGColor":"#f38989","SPWidth":"","SPHeight":"","SPFontSize":"16","SPFontWeight":"normal","SPColor":"#ffffff","SPPadding":"5px 8px","SPMargin":"0","SPBorderTop":"top","SPBorderRight":"right","SPBorderBottom":"bottom","SPBorderLeft":"left","SPBorderColor":"#f38989","SPBorderType":"solid","SPBorderWidth":"1","SPBorderRadius":"0","SPBoxShadow":"","SHPBGColor":"#c17777","SHPColor":"#ffffff","SHPBorderTop":"top","SHPBorderRight":"right","SHPBorderBottom":"bottom","SHPBorderLeft":"left","SHPBorderColor":"#c17777","SHPBorderType":"solid","SHPBorderWidth":"1","BPBGColor":"#ffffff","BPWidth":"","BPHeight":"","BPFontSize":"16","BPFontWeight":"normal","BPColor":"#8c8c8c","BPPadding":"5px 8px","BPMargin":"0 15px 0 0","BPBorderTop":"top","BPBorderRight":"right","BPBorderBottom":"bottom","BPBorderLeft":"left","BPBorderColor":"#43aeab","BPBorderType":"solid","BPBorderWidth":"1","BPBorderRadius":"0","BPBoxShadow":"","BHPBGColor":"#43aeab","BHPColor":"#ffffff","BHPBorderTop":"top","BHPBorderRight":"right","BHPBorderBottom":"bottom","BHPBorderLeft":"left","BHPBorderColor":"#787878","BHPBorderType":"solid","BHPBorderWidth":"1","PSAPBGColor":"#f38989","PSAPFontSize":"16","PSAPFontWeight":"normal","PSAPColor":"#ffffff","PSAPHeight":"","PSAPLineHeight":"","PSAPPadding":"6px","PSAPMargin":"0 0 4px 0 ","PSAPBorderTop":"top","PSAPBorderRight":"right","PSAPBorderBottom":"bottom","PSAPBorderLeft":"left","PSAPBorderColor":"#f38989","PSAPBorderType":"solid","PSAPBorderWidth":"2","PSAPBorderRadius":"0","PSDPBGColor":"#a5a5a5","PSDPFontSize":"16","PSDPFontWeight":"normal","PSDPColor":"#ffffff","PSDPHeight":"","PSDPLineHeight":"","PSDPPadding":"2px 4px","PSDPMargin":"0 0 0 -3px","PSDPBorderTop":"top","PSDPBorderRight":"right","PSDPBorderBottom":"bottom","PSDPBorderLeft":"left","PSDPBorderColor":"#a3a3a3","PSDPBorderType":"solid","PSDPBorderWidth":"2","PSDPBorderRadius":"0","PSAPAlign":"right","PSAPWidth":"","PPAPWidth":"100%","NBPBGColor":"","NBPWidth":"","NBPHeight":"","NBPLineHeight":"","NBPColor":"#43aeab","NBPPadding":"4px 10px","NBPMargin":"0px","NBPBorderColor":"#777777","NBPBorderType":"solid","NBPBorderWidth":"1","NBPBorderRadius":"0","NBPBoxShadow":"","NBHPBGColor":"","NBHPColor":"#777777","NBHPBorderColor":"#787878","NBHPBorderType":"solid","NBHPBorderWidth":"1","PBPBGColor":"","PBPWidth":"100","PBPHeight":"","PBPLineHeight":"","PBPColor":"#43aeab","PBPPadding":"","PBPMargin":"0px","PBPBorderColor":"#777777","PBPBorderType":"solid","PBPBorderWidth":"1","PBPBorderRadius":"0","PBPBoxShadow":"","PBHPBGColor":"","PBHPColor":"#777777","PBHPBorderColor":"#787878","PBHPBorderType":"solid","PBHPBorderWidth":"1","CBPPosition":"absolute","CBPTop":"10px","CBPRight":"10px","CBPBottom":"","CBPLeft":"","CBPBGColor":"","CBPFontSize":"18","CBPFontWeight":"normal","CBPColor":"#ffffff","CBPPadding":"0px","CBPMargin":"0px","CBPBorderColor":"#ffffff","CBPBorderType":"solid","CBPBorderWidth":"1","CBPBorderRadius":"0","CBHPBGColor":"","CBHPColor":"#f38989","CBHPBorderColor":"#737373","CBHPBorderType":"solid","CBHPBorderWidth":"1","MBPBGColor":"#b7b7b7","MBPFontSize":"17","MBPFontWeight":"normal","MBPColor":"#ffffff","MBPTextAlign":"center","MBPPadding":"10px","MBPMargin":"","MBPBorderTop":"top","MBPBorderRight":"right","MBPBorderBottom":"bottom","MBPBorderLeft":"left","MBPBorderColor":"#8f8f8f","MBPBorderType":"solid","MBPBorderWidth":"2","MBPBorderRadius":"0","MBHPBGColor":"#ffffff","MBHPColor":"#8f8f8f","MBHPBorderTop":"top","MBHPBorderRight":"right","MBHPBorderBottom":"bottom","MBHPBorderLeft":"left","MBHPBorderColor":"#8f8f8f","MBHPBorderType":"solid","MBHPBorderWidth":"2","OPDeInputColor":"#aeaeae","OPFontStyle":"normal","OPRColor":"#cf1515","OPDPIcon":"images/themes/date-pickers/5.png","OPDPRepeat":"no-repeat","OPDPPos1":"0%","OPDPPos2":"10%","OPDPMargin":"3px 0 0 -23px","OPFBgUrl":"images/themes/file-uploads/2.png","OPFBGRepeat":"no-repeat","OPFPos1":"0%","OPFPos2":"10%","OPGWidth":"100","CUPCSS":".mwd-header-text { padding: 15px 15px 0; }"}\', 0, 2);');
      $wpdb->query('INSERT INTO `' . $wpdb->prefix . 'formmaker_themes` (`title`, `css`, `default`, `version`) VALUES ("Theme 14", \'{"GPFontFamily":"tahoma","AGPWidth":"100","AGPSPWidth":"40","AGPPadding":"","AGPMargin":"10px auto","AGPBorderColor":"#ffffff","AGPBorderType":"solid","AGPBorderWidth":"1","AGPBorderRadius":"0","AGPBoxShadow":"","HPAlign":"top","HPBGColor":"#386f74","HPWidth":"100","HTPWidth":"26","HPPadding":"0 20px","HPMargin":"","HPTextAlign":"center","HPBorderColor":"#b7b7b7","HPBorderType":"solid","HPBorderWidth":"1","HPBorderRadius":"0","HTPFontSize":"19","HTPWeight":"normal","HTPColor":"#ffffff","HDPFontSize":"13","HDPColor":"#ffffff","HIPAlign":"left","HIPWidth":"40","HIPHeight":"","GPBGColor":"#5dbac2","GPFontSize":"15","GPFontWeight":"normal","GPWidth":"100","GTPWidth":"74","GPAlign":"center","GPBackground":"","GPBackgroundRepeat":"no-repeat","GPBGPosition1":"","GPBGPosition2":"","GPBGSize1":"","GPBGSize2":"","GPColor":"#ffffff","GPPadding":"0","GPMargin":"","GPBorderColor":"#ffffff","GPBorderType":"solid","GPBorderWidth":"1","GPBorderRadius":"0","GPMLFontSize":"14","GPMLFontWeight":"normal","GPMLColor":"#ffffff","GPMLPadding":"0px 5px 0px 0px","GPMLMargin":"0px","SEPBGColor":"#5dbac2","SEPPadding":"","SEPMargin":"","COPPadding":"15px 20px","COPMargin":"0px","FPWidth":"70","FPPadding":"15px 0 0 0","FPMargin":"0 auto","IPHeight":"28","IPFontSize":"13","IPFontWeight":"normal","IPBGColor":"#ffffff","IPColor":"#868686","IPPadding":"0px 5px","IPMargin":"0px","IPBorderTop":"top","IPBorderRight":"right","IPBorderBottom":"bottom","IPBorderLeft":"left","IPBorderColor":"#ffffff","IPBorderType":"solid","IPBorderWidth":"1","IPBorderRadius":"0","IPBoxShadow":"","SBPAppearance":"none","SBPBackground":"images/themes/drop-downs/2.png","SBPBGRepeat":"no-repeat","SBPBGPos1":"95%","SBPBGPos2":"50%","SBPBGSize1":"8%","SBPBGSize2":"32%","SCPBGColor":"#ffffff","SCPWidth":"16","SCPHeight":"16","SCPBorderTop":"top","SCPBorderRight":"right","SCPBorderBottom":"bottom","SCPBorderLeft":"left","SCPBorderColor":"#868686","SCPBorderType":"solid","SCPBorderWidth":"1","SCPMargin":"0px 3px","SCPBorderRadius":"15","SCPBoxShadow":"","SCCPBGColor":"#868686","SCCPWidth":"6","SCCPHeight":"6","SCCPMargin":"5","SCCPBorderRadius":"10","MCPBGColor":"#ffffff","MCPWidth":"16","MCPHeight":"16","MCPBorderTop":"top","MCPBorderRight":"right","MCPBorderBottom":"bottom","MCPBorderLeft":"left","MCPBorderColor":"#868686","MCPBorderType":"solid","MCPBorderWidth":"1","MCPMargin":"0px 3px","MCPBorderRadius":"0","MCPBoxShadow":"","MCCPBGColor":"","MCCPBackground":"images/themes/checkboxes/1.png","MCCPBGRepeat":"no-repeat","MCCPBGPos1":"","MCCPBGPos2":"","MCCPWidth":"16","MCCPHeight":"16","MCCPMargin":"0","MCCPBorderRadius":"0","SPAlign":"right","SPBGColor":"#f6c37a","SPWidth":"","SPHeight":"","SPFontSize":"14","SPFontWeight":"normal","SPColor":"#ffffff","SPPadding":"5px 15px","SPMargin":"0 15px 0 0","SPBorderBottom":"bottom","SPBorderColor":"#ffffff","SPBorderType":"solid","SPBorderWidth":"3","SPBorderRadius":"0","SPBoxShadow":"","SHPBGColor":"#f4b459","SHPColor":"#ffffff","SHPBorderBottom":"bottom","SHPBorderColor":"#ffffff","SHPBorderType":"solid","SHPBorderWidth":"3","BPBGColor":"#5dbac2","BPWidth":"","BPHeight":"","BPFontSize":"14","BPFontWeight":"normal","BPColor":"#ffffff","BPPadding":"5px 8px","BPMargin":"0 15px 0 0","BPBorderColor":"#ffffff","BPBorderType":"solid","BPBorderWidth":"3","BPBorderRadius":"0","BPBoxShadow":"","BHPBGColor":"#5dbac2","BHPColor":"#ffffff","BHPBorderColor":"#ffffff","BHPBorderType":"solid","BHPBorderWidth":"1","PSAPBGColor":"#e74c3c","PSAPFontSize":"16","PSAPFontWeight":"normal","PSAPColor":"#ffffff","PSAPHeight":"","PSAPLineHeight":"","PSAPPadding":"8px","PSAPMargin":"0 0 4px 0 ","PSAPBorderTop":"top","PSAPBorderRight":"right","PSAPBorderBottom":"bottom","PSAPBorderLeft":"left","PSAPBorderColor":"#e74c3c","PSAPBorderType":"solid","PSAPBorderWidth":"2","PSAPBorderRadius":"3","PSDPBGColor":"#a5a5a5","PSDPFontSize":"16","PSDPFontWeight":"normal","PSDPColor":"#ffffff","PSDPHeight":"","PSDPLineHeight":"","PSDPPadding":"4px 6px","PSDPMargin":"0 0 0 -3px","PSDPBorderTop":"top","PSDPBorderRight":"right","PSDPBorderBottom":"bottom","PSDPBorderLeft":"left","PSDPBorderColor":"#a3a3a3","PSDPBorderType":"solid","PSDPBorderWidth":"2","PSDPBorderRadius":"3","PSAPAlign":"right","PSAPWidth":"","PPAPWidth":"100%","NBPBGColor":"","NBPWidth":"","NBPHeight":"","NBPLineHeight":"","NBPColor":"#e74c3c","NBPPadding":"4px 10px","NBPMargin":"0px","NBPBorderColor":"#777777","NBPBorderType":"solid","NBPBorderWidth":"1","NBPBorderRadius":"0","NBPBoxShadow":"","NBHPBGColor":"","NBHPColor":"#2d4d5f","NBHPBorderColor":"#787878","NBHPBorderType":"solid","NBHPBorderWidth":"1","PBPBGColor":"","PBPWidth":"100","PBPHeight":"","PBPLineHeight":"","PBPColor":"#9c9c9c","PBPPadding":"","PBPMargin":"0px","PBPBorderColor":"#777777","PBPBorderType":"solid","PBPBorderWidth":"1","PBPBorderRadius":"0","PBPBoxShadow":"","PBHPBGColor":"","PBHPColor":"#2d4d5f","PBHPBorderColor":"#787878","PBHPBorderType":"solid","PBHPBorderWidth":"1","CBPPosition":"absolute","CBPTop":"22px","CBPRight":"10px","CBPBottom":"","CBPLeft":"","CBPBGColor":"","CBPFontSize":"20","CBPFontWeight":"normal","CBPColor":"#ffffff","CBPPadding":"0px","CBPMargin":"0px","CBPBorderColor":"#f6c37a","CBPBorderType":"solid","CBPBorderWidth":"1","CBPBorderRadius":"0","CBHPBGColor":"","CBHPColor":"#f6c37a","CBHPBorderColor":"#737373","CBHPBorderType":"solid","CBHPBorderWidth":"1","MBPBGColor":"#386f74","MBPFontSize":"15","MBPFontWeight":"normal","MBPColor":"#ffffff","MBPTextAlign":"center","MBPPadding":"10px","MBPMargin":"","MBPBorderTop":"top","MBPBorderRight":"right","MBPBorderBottom":"bottom","MBPBorderLeft":"left","MBPBorderColor":"#386f74","MBPBorderType":"solid","MBPBorderWidth":"2","MBPBorderRadius":"0","MBHPBGColor":"#5dbac2","MBHPColor":"#ffffff","MBHPBorderTop":"top","MBHPBorderRight":"right","MBHPBorderBottom":"bottom","MBHPBorderLeft":"left","MBHPBorderColor":"#5dbac2","MBHPBorderType":"solid","MBHPBorderWidth":"2","OPDeInputColor":"#afafaf","OPFontStyle":"normal","OPRColor":"#386f74","OPDPIcon":"images/themes/date-pickers/2.png","OPDPRepeat":"no-repeat","OPDPPos1":"0%","OPDPPos2":"10%","OPDPMargin":"3px 0 0 -23px","OPFBgUrl":"images/themes/file-uploads/2.png","OPFBGRepeat":"no-repeat","OPFPos1":"0%","OPFPos2":"10%","OPGWidth":"100","CUPCSS":""}\', 0, 2);');
    }

    $formmaker_views = "CREATE TABLE IF NOT EXISTS `" . $wpdb->prefix . "formmaker_views` (
    `form_id` int(11) NOT NULL,
    `views` int(50) NOT NULL,
    PRIMARY KEY (`form_id`)
  ) " . $charset_collate . ";";
    $wpdb->query($formmaker_views);

    $formmaker_sessions = "CREATE TABLE IF NOT EXISTS `" . $wpdb->prefix . "formmaker_sessions` (
    `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
    `form_id` int(20) NOT NULL,
    `group_id` int(20) NOT NULL,
    `ip` varchar(20) NOT NULL,
    `ord_date` datetime NOT NULL,
    `ord_last_modified` datetime NOT NULL,
    `status` varchar(50) NOT NULL,
    `full_name` varchar(100) NOT NULL,
    `email` varchar(50) NOT NULL,
    `phone` varchar(50) NOT NULL,
    `mobile_phone` varchar(255) NOT NULL,
    `fax` varchar(255) NOT NULL,
    `address` varchar(300) NOT NULL,
    `paypal_info` text NOT NULL,
    `without_paypal_info` text NOT NULL,
    `ipn` varchar(20) NOT NULL,
    `checkout_method` varchar(20) NOT NULL,
    `tax` float NOT NULL,
    `shipping` float NOT NULL,
    `shipping_type` varchar(200) NOT NULL,
    `read` int(11) NOT NULL,
    `total` float NOT NULL,
    `currency` varchar(24) NOT NULL,
    PRIMARY KEY (`id`)
  ) " . $charset_collate . ";";
    $wpdb->query($formmaker_sessions);

    $formmaker_query = "CREATE TABLE IF NOT EXISTS `" . $wpdb->prefix . "formmaker_query` (
    `id` int(11) NOT NULL AUTO_INCREMENT,
    `form_id` int(11) NOT NULL,
    `query` text NOT NULL,
    `details` text NOT NULL,
    PRIMARY KEY (`id`)
  ) " . $charset_collate . ";";
    $wpdb->query($formmaker_query);

    $formmaker_backup = "CREATE TABLE IF NOT EXISTS `" . $wpdb->prefix . "formmaker_backup` (
	  `backup_id` int(11) NOT NULL AUTO_INCREMENT,
	  `cur` int(1) NOT NULL,
	  `id` int(11) NOT NULL,
	  `title` varchar(127) NOT NULL,
    `type` varchar(100) NOT NULL,
	  `mail` varchar(128) NOT NULL,
	  `form_front` longtext NOT NULL,
	  `theme` int(11) NOT NULL,
	  `javascript` text NOT NULL,
	  `submit_text` longtext NOT NULL,
	  `url` varchar(200) NOT NULL,
	  `submit_text_type` tinyint(4) NOT NULL,
	  `script_mail` text NOT NULL,
	  `script_mail_user` text NOT NULL,
	  `counter` int(11) NOT NULL,
	  `published` int(11) NOT NULL DEFAULT '1',
	  `label_order` longtext NOT NULL,
	  `label_order_current` longtext NOT NULL,
	  `article_id` varchar(500) NOT NULL,
	  `pagination` varchar(128) NOT NULL,
	  `show_title` varchar(128) NOT NULL,
	  `show_numbers` varchar(128) NOT NULL,
	  `public_key` varchar(50) NOT NULL,
	  `private_key` varchar(50) NOT NULL,
	  `recaptcha_theme` varchar(20) NOT NULL,
	  `paypal_mode` int(2) NOT NULL,
	  `checkout_mode` varchar(20) NOT NULL,
	  `paypal_email` varchar(50) NOT NULL,
	  `payment_currency` varchar(20) NOT NULL,
	  `tax` float NOT NULL,
	  `form_fields` longtext NOT NULL,
	  `savedb` tinyint(4) NOT NULL DEFAULT '1',
	  `sendemail` tinyint(4) NOT NULL DEFAULT '1',
	  `requiredmark` varchar(20) NOT NULL DEFAULT '*',
	  `from_mail` varchar(128) NOT NULL,
	  `from_name` varchar(128) NOT NULL,
	  `reply_to` varchar(128) NOT NULL,
	  `send_to` varchar(128) NOT NULL,
	  `autogen_layout` tinyint(4) NOT NULL DEFAULT '1',
	  `custom_front` longtext NOT NULL,
	  `mail_from_user` varchar(128) NOT NULL,
	  `mail_from_name_user` varchar(128) NOT NULL,
	  `reply_to_user` varchar(128) NOT NULL,
	  `condition` text NOT NULL,
	  `mail_cc` varchar(128) NOT NULL,
	  `mail_cc_user` varchar(128) NOT NULL,
	  `mail_bcc` varchar(128) NOT NULL,
	  `mail_bcc_user` varchar(128) NOT NULL,
	  `mail_subject` varchar(128) NOT NULL,
	  `mail_subject_user` varchar(128) NOT NULL,
	  `mail_mode` tinyint(4) NOT NULL DEFAULT '1',
	  `mail_mode_user` tinyint(4) NOT NULL DEFAULT '1',
	  `mail_attachment` tinyint(4) NOT NULL DEFAULT '1',
	  `mail_attachment_user` tinyint(4) NOT NULL DEFAULT '1',
	  `user_id_wd` varchar(220) NOT NULL,
	  `sortable` int(11) NOT NULL,
	  `frontend_submit_fields` text NOT NULL,
	  `frontend_submit_stat_fields` text NOT NULL,
	  `mail_emptyfields` tinyint(4) NOT NULL DEFAULT '0',
	  `mail_verify` tinyint(4) NOT NULL DEFAULT '0',
	  `mail_verify_expiretime` float NOT NULL,
	  `mail_verification_post_id` int(11) NOT NULL,
	  `save_uploads` tinyint(4) NOT NULL DEFAULT '1',
    `header_title` varchar(255) NOT NULL,
		`header_description` text NOT NULL,
		`header_image_url` varchar(255) NOT NULL,
		`header_image_animation` varchar(200) NOT NULL,
		`header_hide_image` tinyint(4) NOT NULL DEFAULT '1',
		`header_hide` tinyint(4) NOT NULL DEFAULT '1',
		`privacy` longtext NOT NULL,
	  `date` int(10) NOT NULL,
	  PRIMARY KEY (`backup_id`)
	) " . $charset_collate . ";";
    $wpdb->query($formmaker_backup);
    return;
  }

  public static function install_demo_forms() {
    global $wpdb;
    $form_maker_row = $wpdb->get_var('SELECT * FROM ' . $wpdb->prefix . 'formmaker' . (!WDFMInstance(self::PLUGIN)->is_free ? '' : ' WHERE id' . (WDFMInstance(self::PLUGIN)->is_free == 1 ? ' NOT ' : ' ') . 'IN (' . (get_option('contact_form_forms', '') != '' ? get_option('contact_form_forms') : 0) . ')'));
    if ( !$form_maker_row ) {
      $insert_form_id = array();
		  $wpdb->query("INSERT INTO `" . $wpdb->prefix . "formmaker` (`id`, `title`, `type`, `mail`, `form_front`, `theme`, `javascript`, `submit_text`, `url`, `submit_text_type`, `script_mail`, `script_mail_user`, `counter`, `published`, `label_order`, `label_order_current`, `article_id`, `pagination`, `show_title`, `show_numbers`, `public_key`, `private_key`, `recaptcha_theme`, `paypal_mode`, `checkout_mode`, `paypal_email`, `payment_currency`, `tax`, `form_fields`, `savedb`, `sendemail`, `requiredmark`, `from_mail`, `from_name`, `reply_to`, `send_to`, `autogen_layout`, `custom_front`, `mail_from_user`, `mail_from_name_user`, `reply_to_user`, `condition`, `mail_cc`, `mail_cc_user`, `mail_bcc`, `mail_bcc_user`, `mail_subject`, `mail_subject_user`, `mail_mode`, `mail_mode_user`, `mail_attachment`, `mail_attachment_user`, `user_id_wd`, `sortable`, `frontend_submit_fields`, `frontend_submit_stat_fields`, `mail_emptyfields`, `mail_verify`, `mail_verify_expiretime`, `mail_verification_post_id`, `save_uploads`, `header_title`, `header_description`, `header_image_url`, `header_image_animation`, `header_hide_image`, `header_hide`, `jsversion`, `privacy`) VALUES (NULL, 'Contact Us', 'embedded', '{adminemail}', '<div class=\"wdform-page-and-images fm-form-builder\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"true\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column\"><div wdid=\"2\" class=\"wdform_row\">%2 - Name%</div></div><div class=\"wdform_column\"><div wdid=\"3\" class=\"wdform_row\">%3 - Email%</div></div><div class=\"wdform_column\"><div wdid=\"4\" class=\"wdform_row\">%4 - Subject%</div></div><div class=\"wdform_column\"><div wdid=\"5\" class=\"wdform_row\">%5 - Message%</div></div><div class=\"wdform_column\"><div wdid=\"1\" class=\"wdform_row\">%1 - type_submit_reset_1%</div></div></div><div valign=\"top\" class=\"wdform_footer wd-width-100\"><div class=\"wd-width-100\"><div class=\"wd-width-100 wd-table\" style=\"padding-top:10px;\"><div class=\"wd-table-group\"><div id=\"form_id_temppage_nav1\" class=\"wd-table-row\"></div></div></div></div></div></div></div>', 1, '// Occurs before the form is loaded\r\nfunction before_load() {	\r\n}	\r\n// Occurs just before submitting  the form\r\nfunction before_submit() {\r\n	// IMPORTANT! If you want to interrupt (stop) the submitting of the form, this function should return true. You don\'t need to return any value if you don\'t want to stop the submission.\r\n}	\r\n// Occurs just before resetting the form\r\nfunction before_reset() {	\r\n}\r\n// Occurs after form is submitted and reloaded\r\nfunction after_submit() {\r\n  \r\n}', '', '', 1, '{all}', '{all}', 6, 1, '2#**id**#Name#**label**#type_text#****#3#**id**#Email#**label**#type_submitter_mail#****#4#**id**#Subject#**label**#type_text#****#5#**id**#Message#**label**#type_textarea#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#2_elementform_id_temp#**id**#type_submit_reset_1#**label**#type_submit_reset#****#', '2#**id**#Name#**label**#type_text#****#3#**id**#Email#**label**#type_submitter_mail#****#4#**id**#Subject#**label**#type_text#****#5#**id**#Message#**label**#type_textarea#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#', '0', 'none', '', '1', '', '', '', 0, 'testmode', '', '', 0, '2*:*id*:*type_text*:*type*:*Name*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:*no*:*w_readonly*:**:*w_class*:**:*new_field*:*3*:*id*:*type_submitter_mail*:*type*:*Email*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:*no*:*w_verification*:*Email confirmation*:*w_verification_label*:**:*w_verification_placeholder*:*no*:*w_autofill*:**:*new_field*:*4*:*id*:*type_text*:*type*:*Subject*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:*no*:*w_readonly*:**:*w_class*:**:*new_field*:*5*:*id*:*type_textarea*:*type*:*Message*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size_w*:*100*:*w_size_h*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*1*:*id*:*type_submit_reset*:*type*:*type_submit_reset_1*:*w_field_label*:*Submit*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*false*:*w_act*:**:*new_field*:*', 1, 1, '*', '{adminemail}', '', '', '', 1, '', '{adminemail}', '', '', '', '', '', '', '', '', '', 1, 1, 1, 1, 'administrator,', 0, '', '', 0, 0, 0, 0, 1, 'Contact Us', 'You may contact us by filling in this form any time you need professional support or have any questions. You can also fill in the form to leave your comments or feedback.', '', 'none', 0, 1, 0, '');");
      $insert_form_id[] = $wpdb->insert_id;
		  $wpdb->query("INSERT INTO `" . $wpdb->prefix . "formmaker` (`id`, `title`, `type`, `mail`, `form_front`, `theme`, `javascript`, `submit_text`, `url`, `submit_text_type`, `script_mail`, `script_mail_user`, `counter`, `published`, `label_order`, `label_order_current`, `article_id`, `pagination`, `show_title`, `show_numbers`, `public_key`, `private_key`, `recaptcha_theme`, `paypal_mode`, `checkout_mode`, `paypal_email`, `payment_currency`, `tax`, `form_fields`, `savedb`, `sendemail`, `requiredmark`, `from_mail`, `from_name`, `reply_to`, `send_to`, `autogen_layout`, `custom_front`, `mail_from_user`, `mail_from_name_user`, `reply_to_user`, `condition`, `mail_cc`, `mail_cc_user`, `mail_bcc`, `mail_bcc_user`, `mail_subject`, `mail_subject_user`, `mail_mode`, `mail_mode_user`, `mail_attachment`, `mail_attachment_user`, `user_id_wd`, `sortable`, `frontend_submit_fields`, `frontend_submit_stat_fields`, `mail_emptyfields`, `mail_verify`, `mail_verify_expiretime`, `mail_verification_post_id`, `save_uploads`, `header_title`, `header_description`, `header_image_url`, `header_image_animation`, `header_hide_image`, `header_hide`, `jsversion`, `privacy`) VALUES (NULL, 'Client List Form', 'embedded', '{adminemail}', '<div class=\"wdform-page-and-images fm-form-builder\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"true\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column\"><div wdid=\"2\" class=\"wdform_row\">%2 - First Name%</div></div><div class=\"wdform_column\"><div wdid=\"3\" class=\"wdform_row\">%3 - Last Name%</div></div><div class=\"wdform_column\"><div wdid=\"4\" class=\"wdform_row\">%4 - Email%</div></div><div class=\"wdform_column\"><div wdid=\"5\" class=\"wdform_row\">%5 - Phone%</div></div><div class=\"wdform_column\"><div wdid=\"6\" class=\"wdform_row\">%6 - Website%</div></div><div class=\"wdform_column\"><div wdid=\"7\" class=\"wdform_row\">%7 - Address%</div></div><div class=\"wdform_column\"><div wdid=\"1\" class=\"wdform_row\">%1 - type_submit_reset_1%</div></div></div><div valign=\"top\" class=\"wdform_footer wd-width-100\"><div class=\"wd-width-100\"><div class=\"wd-width-100 wd-table\" style=\"padding-top:10px;\"><div class=\"wd-table-group\"><div id=\"form_id_temppage_nav1\" class=\"wd-table-row\"></div></div></div></div></div></div></div>', 1, '// Occurs before the form is loaded\r\nfunction before_load() {	\r\n}	\r\n// Occurs just before submitting  the form\r\nfunction before_submit() {\r\n	// IMPORTANT! If you want to interrupt (stop) the submitting of the form, this function should return true. You don\'t need to return any value if you don\'t want to stop the submission.\r\n}	\r\n// Occurs just before resetting the form\r\nfunction before_reset() {	\r\n}// Occurs after form is submitted and reloaded\r\nfunction after_submit() {\r\n  \r\n}', '', '', 1, '{all}', '{all}', 13, 1, '2#**id**#First Name#**label**#type_text#****#3#**id**#Last Name#**label**#type_text#****#4#**id**#Email#**label**#type_submitter_mail#****#5#**id**#Phone#**label**#type_text#****#6#**id**#Website#**label**#type_text#****#7#**id**#Street Address#**label**#type_address#****#8#**id**#Street Address Line 2#**label**#type_address#****#9#**id**#City#**label**#type_address#****#10#**id**#State / Province / Region#**label**#type_address#****#11#**id**#Postal / Zip Code#**label**#type_address#****#12#**id**#Country#**label**#type_address#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#7_street1form_id_temp#**id**#type_submit_reset_1#**label**#type_submit_reset#****#', '2#**id**#First Name#**label**#type_text#****#3#**id**#Last Name#**label**#type_text#****#4#**id**#Email#**label**#type_submitter_mail#****#5#**id**#Phone#**label**#type_text#****#6#**id**#Website#**label**#type_text#****#7#**id**#Street Address#**label**#type_address#****#8#**id**#Street Address Line 2#**label**#type_address#****#9#**id**#City#**label**#type_address#****#10#**id**#State / Province / Region#**label**#type_address#****#11#**id**#Postal / Zip Code#**label**#type_address#****#12#**id**#Country#**label**#type_address#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#', '0', 'none', '', '1', '', '', '', 0, 'testmode', '', '', 0, '2*:*id*:*type_text*:*type*:*First Name*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:*no*:*w_readonly*:**:*w_class*:**:*new_field*:*3*:*id*:*type_text*:*type*:*Last Name*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:*no*:*w_readonly*:**:*w_class*:**:*new_field*:*4*:*id*:*type_submitter_mail*:*type*:*Email*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:*no*:*w_verification*:*Email confirmation*:*w_verification_label*:**:*w_verification_placeholder*:*no*:*w_autofill*:**:*new_field*:*5*:*id*:*type_text*:*type*:*Phone*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:*no*:*w_readonly*:**:*w_class*:**:*new_field*:*6*:*id*:*type_text*:*type*:*Website*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:*http://example.com*:*w_title*:*no*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:*no*:*w_readonly*:**:*w_class*:**:*new_field*:*7*:*id*:*type_address*:*type*:*Address*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:*Street Address***Street Address Line 2***City***State / Province / Region***Postal / Zip Code***Country*:*w_mini_labels*:*no***no***no***no***no***no***no*:*w_disabled_fields*:*no*:*w_required*:*wdform_address*:*w_class*:**:*new_field*:*1*:*id*:*type_submit_reset*:*type*:*type_submit_reset_1*:*w_field_label*:*Submit*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*false*:*w_act*:**:*new_field*:*', 1, 1, '*', '{adminemail}', '', '', '', 1, '', '{adminemail}', '', '', '', '', '', '', '', '', '', 1, 1, 1, 1, 'administrator,', 0, '', '', 0, 0, 0, 0, 1, '', '', '', 'none', 0, 1, 0, '');");
      $insert_form_id[] = $wpdb->insert_id;

      if ( WDFMInstance(self::PLUGIN)->is_free != 2 ) {
		  $wpdb->query("INSERT INTO `" . $wpdb->prefix . "formmaker` (`id`, `title`, `type`, `mail`, `form_front`, `theme`, `javascript`, `submit_text`, `url`, `submit_text_type`, `script_mail`, `script_mail_user`, `counter`, `published`, `label_order`, `label_order_current`, `article_id`, `pagination`, `show_title`, `show_numbers`, `public_key`, `private_key`, `recaptcha_theme`, `paypal_mode`, `checkout_mode`, `paypal_email`, `payment_currency`, `tax`, `form_fields`, `savedb`, `sendemail`, `requiredmark`, `from_mail`, `from_name`, `reply_to`, `send_to`, `autogen_layout`, `custom_front`, `mail_from_user`, `mail_from_name_user`, `reply_to_user`, `condition`, `mail_cc`, `mail_cc_user`, `mail_bcc`, `mail_bcc_user`, `mail_subject`, `mail_subject_user`, `mail_mode`, `mail_mode_user`, `mail_attachment`, `mail_attachment_user`, `user_id_wd`, `sortable`, `frontend_submit_fields`, `frontend_submit_stat_fields`, `mail_emptyfields`, `mail_verify`, `mail_verify_expiretime`, `mail_verification_post_id`, `save_uploads`, `header_title`, `header_description`, `header_image_url`, `header_image_animation`, `header_hide_image`, `header_hide`, `jsversion`, `privacy`) VALUES (NULL, 'Feedback Form', 'embedded', '{adminemail}', '<div class=\"wdform-page-and-images fm-form-builder\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"true\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column\"><div wdid=\"3\" class=\"wdform_row\">%3 - Name%</div></div><div class=\"wdform_column\"><div wdid=\"4\" class=\"wdform_row\">%4 - Email%</div></div><div class=\"wdform_column\"><div wdid=\"5\" class=\"wdform_row\" style=\"position: relative; left: 0px; top: 0px;\">%5 - CMS%</div></div><div class=\"wdform_column\"><div wdid=\"6\" class=\"wdform_row\">%6 - Extension%</div></div><div class=\"wdform_column\"><div wdid=\"7\" class=\"wdform_row\">%7 - Plugin%</div></div><div class=\"wdform_column\"><div wdid=\"2\" class=\"wdform_row\" style=\"position: relative; left: 0px; top: 0px;\">%2 - Subject%</div></div><div class=\"wdform_column\"><div wdid=\"8\" class=\"wdform_row\">%8 - Message%</div></div><div class=\"wdform_column\"><div wdid=\"1\" class=\"wdform_row\">%1 - type_submit_reset_1%</div></div></div><div valign=\"top\" class=\"wdform_footer wd-width-100\"><div class=\"wd-width-100\"><div class=\"wd-width-100 wd-table\" style=\"padding-top:10px;\"><div class=\"wd-table-group\"><div id=\"form_id_temppage_nav1\" class=\"wd-table-row\"></div></div></div></div></div></div></div>', 3, '// Occurs before the form is loaded\r\nfunction before_load() {	\r\n}	\r\n// Occurs just before submitting  the form\r\nfunction before_submit() {\r\n	// IMPORTANT! If you want to interrupt (stop) the submitting of the form, this function should return true. You don\'t need to return any value if you don\'t want to stop the submission.\r\n}	\r\n// Occurs just before resetting the form\r\nfunction before_reset() {	\r\n}// Occurs after form is submitted and reloaded\r\nfunction after_submit() {\r\n  \r\n}', '', '', 1, '{all}', '{all}', 9, 1, '3#**id**#Name#**label**#type_name#****#4#**id**#Email#**label**#type_submitter_mail#****#5#**id**#CMS#**label**#type_radio#****#6#**id**#Extension#**label**#type_own_select#****#7#**id**#Plugin#**label**#type_own_select#****#2#**id**#Subject#**label**#type_text#****#8#**id**#Message#**label**#type_textarea#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#2_elementform_id_temp#**id**#Text#**label**#type_text#****#', '3#**id**#Name#**label**#type_name#****#4#**id**#Email#**label**#type_submitter_mail#****#5#**id**#CMS#**label**#type_radio#****#6#**id**#Extension#**label**#type_own_select#****#7#**id**#Plugin#**label**#type_own_select#****#2#**id**#Subject#**label**#type_text#****#8#**id**#Message#**label**#type_textarea#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#', '0', 'none', '', '1', '', '', '', 0, '0', '', 'USD', 0, '3*:*id*:*type_name*:*type*:*Name*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:***********:*w_first_val*:*First***Last*******:*w_title*:*Title*********Middle*:*w_mini_labels*:**:*w_size*:*normal*:*w_name_format*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:*no***no*:*w_name_fields*:*no*:*w_autofill*:**:*new_field*:*4*:*id*:*type_submitter_mail*:*type*:*Email*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:*no*:*w_verification*:*Email confirmation*:*w_verification_label*:**:*w_verification_placeholder*:*no*:*w_autofill*:**:*new_field*:*5*:*id*:*type_radio*:*type*:*CMS*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*right*:*w_field_option_pos*:*no*:*w_hide_label*:*hor*:*w_flow*:*Joomla!***Wordpress*:*w_choices*:*false***false*:*w_choices_checked*:*1*:*w_rowcol*:*yes*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:*no*:*w_value_disabled*:*Joomla!***Wordpress*:*w_choices_value*:*****:*w_choices_params*:**:*w_class*:**:*new_field*:*6*:*id*:*type_own_select*:*type*:*Extension*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:*Select extension***Form Maker***Gallery WD***Spider Calendar*:*w_choices*:*true***false***false***false*:*w_choices_checked*:*true***false***false***false*:*w_choices_disabled*:*yes*:*w_required*:*no*:*w_value_disabled*:****Form Maker***Gallery WD***Spider Calendar*:*w_choices_value*:***********:*w_choices_params*:*wdform_select*:*w_class*:**:*new_field*:*7*:*id*:*type_own_select*:*type*:*Plugin*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:*Select plugin***Form Maker***Photo Gallery***Ecommerce WD*:*w_choices*:*true***false***false***false*:*w_choices_checked*:*true***false***false***false*:*w_choices_disabled*:*yes*:*w_required*:*no*:*w_value_disabled*:****Form Maker***Photo Gallery***Ecommerce WD*:*w_choices_value*:***********:*w_choices_params*:*wdform_select*:*w_class*:**:*new_field*:*2*:*id*:*type_text*:*type*:*Subject*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_regExp_status*:**:*w_regExp_value*:**:*w_regExp_common*:**:*w_regExp_arg*:*Incorrect Value*:*w_regExp_alert*:*no*:*w_unique*:*no*:*w_readonly*:**:*w_class*:**:*new_field*:*8*:*id*:*type_textarea*:*type*:*Message*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size_w*:*100*:*w_size_h*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*1*:*id*:*type_submit_reset*:*type*:*type_submit_reset_1*:*w_field_label*:*Submit*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*true*:*w_act*:**:*new_field*:*', 1, 1, '*', '{adminemail}', '', '', '', 1, '', '{adminemail}', '', '', '1*:*show_hide*:*6*:*field_label*:*and*:*all_any*:*5***==***Joomla!*:*next_condition*:**:*new_condition*:*1*:*show_hide*:*7*:*field_label*:*and*:*all_any*:*5***==***Wordpress*:*next_condition*:**:*new_condition*:*', '', '', '', '', '', '', 1, 1, 1, 1, 'administrator,', 0, '', '', 0, 0, 0, 0, 1, 'Feedback Form', 'You may contact us by filling in this form any time you need professional support or have any questions. You can also fill in the form to leave your comments or feedback.', '" .  WDFMInstance(self::PLUGIN)->plugin_url . "/images/demo/2.png', 'flash', 0, 1, 0, '');");
      $insert_form_id[] = $wpdb->insert_id;
		  $wpdb->query("INSERT INTO `" . $wpdb->prefix . "formmaker` (`id`, `title`, `type`, `mail`, `form_front`, `theme`, `javascript`, `submit_text`, `url`, `submit_text_type`, `script_mail`, `script_mail_user`, `counter`, `published`, `label_order`, `label_order_current`, `article_id`, `pagination`, `show_title`, `show_numbers`, `public_key`, `private_key`, `recaptcha_theme`, `paypal_mode`, `checkout_mode`, `paypal_email`, `payment_currency`, `tax`, `form_fields`, `savedb`, `sendemail`, `requiredmark`, `from_mail`, `from_name`, `reply_to`, `send_to`, `autogen_layout`, `custom_front`, `mail_from_user`, `mail_from_name_user`, `reply_to_user`, `condition`, `mail_cc`, `mail_cc_user`, `mail_bcc`, `mail_bcc_user`, `mail_subject`, `mail_subject_user`, `mail_mode`, `mail_mode_user`, `mail_attachment`, `mail_attachment_user`, `user_id_wd`, `sortable`, `frontend_submit_fields`, `frontend_submit_stat_fields`, `mail_emptyfields`, `mail_verify`, `mail_verify_expiretime`, `mail_verification_post_id`, `save_uploads`, `header_title`, `header_description`, `header_image_url`, `header_image_animation`, `header_hide_image`, `header_hide`, `jsversion`, `privacy`) VALUES (NULL, 'Business Demographic Survey', 'embedded', '{adminemail}', '<div class=\"wdform-page-and-images fm-form-builder\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"true\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column\"><div wdid=\"2\" class=\"wdform_row\">%2 - What is your employment status?%</div></div><div class=\"wdform_column\"><div wdid=\"3\" class=\"wdform_row\">%3 - What is your level of education?%</div></div><div class=\"wdform_column\"><div wdid=\"4\" class=\"wdform_row\">%4 - In which industry do you work?%</div></div><div class=\"wdform_column\"><div wdid=\"6\" class=\"wdform_row\">%6 - What is the annual revenue of your company?%</div></div><div class=\"wdform_column\"><div wdid=\"5\" class=\"wdform_row\">%5 - Enter characters for verification.%</div></div><div class=\"wdform_column\"><div wdid=\"1\" class=\"wdform_row\">%1 - type_submit_reset_1%</div></div></div><div valign=\"top\" class=\"wdform_footer wd-width-100\"><div class=\"wd-width-100\"><div class=\"wd-width-100 wd-table\" style=\"padding-top:10px;\"><div class=\"wd-table-group\"><div id=\"form_id_temppage_nav1\" class=\"wd-table-row\"></div></div></div></div></div></div></div>', 4, '// Occurs before the form is loaded\r\nfunction before_load() {	\r\n}	\r\n// Occurs just before submitting  the form\r\nfunction before_submit() {\r\n	// IMPORTANT! If you want to interrupt (stop) the submitting of the form, this function should return true. You don\'t need to return any value if you don\'t want to stop the submission.\r\n}	\r\n// Occurs just before resetting the form\r\nfunction before_reset() {	\r\n}// Occurs after form is submitted and reloaded\r\nfunction after_submit() {\r\n  \r\n}', '', '', 1, '{all}', '{all}', 7, 1, '2#**id**#What is your employment status?#**label**#type_radio#****#3#**id**#What is your level of education?#**label**#type_radio#****#4#**id**#In which industry do you work?#**label**#type_own_select#****#6#**id**#What is the annual revenue of your company?#**label**#type_radio#****#5#**id**#Enter characters for verification.#**label**#type_captcha#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#6_elementform_id_temp0#**id**#What is your employment status?#**label**#type_radio#****#6_elementform_id_temp1#**id**#What is your level of education?#**label**#type_radio#****#6_elementform_id_temp2#**id**#In which industry do you work?#**label**#type_own_select#****#6_elementform_id_temp3#**id**#Enter characters for verification.#**label**#type_captcha#****#6_elementform_id_temp4#**id**#type_submit_reset_1#**label**#type_submit_reset#****#6_elementform_id_temp5#**id**#type_submit_reset_1#**label**#type_submit_reset#****#', '2#**id**#What is your employment status?#**label**#type_radio#****#3#**id**#What is your level of education?#**label**#type_radio#****#4#**id**#In which industry do you work?#**label**#type_own_select#****#6#**id**#What is the annual revenue of your company?#**label**#type_radio#****#5#**id**#Enter characters for verification.#**label**#type_captcha#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#', '0', 'none', '', '1', '', '', '', 0, 'testmode', '', '', 0, '2*:*id*:*type_radio*:*type*:*What is your employment status?*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*right*:*w_field_option_pos*:*no*:*w_hide_label*:*ver*:*w_flow*:*Employed full time***Trade or Vocational degree***Not employed, but looking for work***Not employed and not looking for work***Retired***Student***Homemaker***Prefer not to answer*:*w_choices*:*false***false***false***false***false***false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:*no*:*w_value_disabled*:*Employed full time***Trade or Vocational degree***Not employed, but looking for work***Not employed and not looking for work***Retired***Student***Homemaker***Prefer not to answer*:*w_choices_value*:***********************:*w_choices_params*:**:*w_class*:**:*new_field*:*3*:*id*:*type_radio*:*type*:*What is your level of education?*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*right*:*w_field_option_pos*:*no*:*w_hide_label*:*ver*:*w_flow*:*Some high school***High school graduate or equivalent***Trade or Vocational Degree***Some college***Associate degree***Bachelor\'s degree***Graduate or Professional degree***Prefer not to answer*:*w_choices*:*false***false***false***false***false***false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:*no*:*w_value_disabled*:*Some high school***High school graduate or equivalent***Trade or Vocational Degree***Some college***Associate degree***Bachelor\'s degree***Graduate or Professional degree***Prefer not to answer*:*w_choices_value*:***********************:*w_choices_params*:**:*w_class*:**:*new_field*:*4*:*id*:*type_own_select*:*type*:*In which industry do you work?*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:*Select industry***Agriculture***Engineering***Information Technologies***Media***Local Business*:*w_choices*:*true***false***false***false***false***false*:*w_choices_checked*:*true***false***false***false***false***false*:*w_choices_disabled*:*no*:*w_required*:*no*:*w_value_disabled*:****Agriculture***Engineering***Information Technologies***Media***Local Business*:*w_choices_value*:*****************:*w_choices_params*:*wdform_select*:*w_class*:**:*new_field*:*6*:*id*:*type_radio*:*type*:*What is the annual revenue of your company?*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*right*:*w_field_option_pos*:*no*:*w_hide_label*:*ver*:*w_flow*:*Under $10,000***$10,001 to $50,000***$50,001 to $100,000***$100,001 to $500,000***$500,001 to $1 Million***$1 Million to $10 Million***$10 Million to $50 Million***$50 Million to $100 Million***Over $100 Million*:*w_choices*:*false***false***false***false***false***false***false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:*no*:*w_value_disabled*:*Under $10,000***$10,001 to $50,000***$50,001 to $100,000***$100,001 to $500,000***$500,001 to $1 Million***$1 Million to $10 Million***$10 Million to $50 Million***$50 Million to $100 Million***Over $100 Million*:*w_choices_value*:**************************:*w_choices_params*:**:*w_class*:**:*new_field*:*5*:*id*:*type_captcha*:*type*:*Enter characters for verification.*:*w_field_label*:**:*w_field_label_size*:*left*:*w_field_label_pos*:*yes*:*w_hide_label*:*6*:*w_digit*:**:*w_class*:**:*new_field*:*1*:*id*:*type_submit_reset*:*type*:*type_submit_reset_1*:*w_field_label*:*Submit*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*false*:*w_act*:**:*new_field*:*', 1, 1, '*', '{adminemail}', '', '', '', 1, '', '{adminemail}', '', '', '', '', '', '', '', '', '', 1, 1, 1, 1, 'administrator,', 0, '', '', 0, 0, 0, 0, 1, 'Business Demographic Survey', 'Thank you for joining our business demographic survey. Please give us your feedback by filling in the information bellow.', '', 'none', 1, 1, 0, '');");
      $insert_form_id[] = $wpdb->insert_id;
		  $wpdb->query("INSERT INTO `" . $wpdb->prefix . "formmaker` (`id`, `title`, `type`, `mail`, `form_front`, `theme`, `javascript`, `submit_text`, `url`, `submit_text_type`, `script_mail`, `script_mail_user`, `counter`, `published`, `label_order`, `label_order_current`, `article_id`, `pagination`, `show_title`, `show_numbers`, `public_key`, `private_key`, `recaptcha_theme`, `paypal_mode`, `checkout_mode`, `paypal_email`, `payment_currency`, `tax`, `form_fields`, `savedb`, `sendemail`, `requiredmark`, `from_mail`, `from_name`, `reply_to`, `send_to`, `autogen_layout`, `custom_front`, `mail_from_user`, `mail_from_name_user`, `reply_to_user`, `condition`, `mail_cc`, `mail_cc_user`, `mail_bcc`, `mail_bcc_user`, `mail_subject`, `mail_subject_user`, `mail_mode`, `mail_mode_user`, `mail_attachment`, `mail_attachment_user`, `user_id_wd`, `sortable`, `frontend_submit_fields`, `frontend_submit_stat_fields`, `mail_emptyfields`, `mail_verify`, `mail_verify_expiretime`, `mail_verification_post_id`, `save_uploads`, `header_title`, `header_description`, `header_image_url`, `header_image_animation`, `header_hide_image`, `header_hide`, `jsversion`, `privacy`) VALUES (NULL, 'Cupcake Order Form', 'embedded', '{adminemail}', '<div class=\"wdform-page-and-images fm-form-builder\"><div id=\"form_id_tempform_view1\" class=\"wdform_page\" page_title=\"Untitled page\" next_title=\"Next\" next_type=\"text\" next_class=\"wdform-page-button\" next_checkable=\"true\" previous_title=\"Previous\" previous_type=\"text\" previous_class=\"wdform-page-button\" previous_checkable=\"false\"><div class=\"wdform_section\"><div class=\"wdform_column\"><div wdid=\"2\" class=\"wdform_row\">%2 - Name%</div></div><div class=\"wdform_column\"><div wdid=\"3\" class=\"wdform_row\">%3 - Email%</div></div><div class=\"wdform_column\"><div wdid=\"4\" class=\"wdform_row\">%4 - Date%</div></div><div class=\"wdform_column\"><div wdid=\"5\" class=\"wdform_row\">%5 - Cupcakes Flavors (1 doz. minimum)%</div></div><div class=\"wdform_column\"><div wdid=\"6\" class=\"wdform_row\">%6 - Quantity%</div></div><div class=\"wdform_column\"><div wdid=\"7\" class=\"wdform_row\">%7 - Details (if any)%</div></div><div class=\"wdform_column\"><div wdid=\"1\" class=\"wdform_row\">%1 - type_submit_reset_1%</div></div></div><div valign=\"top\" class=\"wdform_footer wd-width-100\"><div class=\"wd-width-100\"><div class=\"wd-width-100 wd-table\" style=\"padding-top:10px;\"><div class=\"wd-table-group\"><div id=\"form_id_temppage_nav1\" class=\"wd-table-row\"></div></div></div></div></div></div></div>', 6, '// Occurs before the form is loaded\r\nfunction before_load() {	\r\n}	\r\n// Occurs just before submitting  the form\r\nfunction before_submit() {\r\n	// IMPORTANT! If you want to interrupt (stop) the submitting of the form, this function should return true. You don\'t need to return any value if you don\'t want to stop the submission.\r\n}	\r\n// Occurs just before resetting the form\r\nfunction before_reset() {	\r\n}// Occurs after form is submitted and reloaded\r\nfunction after_submit() {\r\n  \r\n}', '', '', 1, '{all}', '{all}', 8, 1, '2#**id**#Name#**label**#type_name#****#3#**id**#Email#**label**#type_submitter_mail#****#4#**id**#Date#**label**#type_date_new#****#5#**id**#Cupcakes Flavors (1 doz. minimum)#**label**#type_radio#****#6#**id**#Quantity#**label**#type_spinner#****#7#**id**#Details (if any)#**label**#type_textarea#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#5_elementform_id_temp0#**id**#Name#**label**#type_name#****#5_elementform_id_temp1#**id**#Email#**label**#type_submitter_mail#****#5_elementform_id_temp2#**id**#Date#**label**#type_date_new#****#5_elementform_id_temp3#**id**#Name:*   Email:* Date* Cupcakes Flavors (1 doz. minimum)#**label**#type_radio#****#5_elementform_id_temp4#**id**#Quantity#**label**#type_spinner#****#5_elementform_id_temp5#**id**#Details (if any)#**label**#type_textarea#****#5_elementform_id_temp6#**id**#type_submit_reset_1#**label**#type_submit_reset#****#5_elementform_id_temp7#**id**#Name#**label**#type_name#****#5_elementform_id_temp8#**id**#Email#**label**#type_submitter_mail#****#5_elementform_id_temp9#**id**#Date#**label**#type_date_new#****#5_elementform_id_temp10#**id**#type_submit_reset_1#**label**#type_submit_reset#****#5_elementform_id_temp11#**id**#type_submit_reset_1#**label**#type_submit_reset#****#', '2#**id**#Name#**label**#type_name#****#3#**id**#Email#**label**#type_submitter_mail#****#4#**id**#Date#**label**#type_date_new#****#5#**id**#Cupcakes Flavors (1 doz. minimum)#**label**#type_radio#****#6#**id**#Quantity#**label**#type_spinner#****#7#**id**#Details (if any)#**label**#type_textarea#****#1#**id**#type_submit_reset_1#**label**#type_submit_reset#****#', '0', 'none', '', '1', '', '', '', 0, 'testmode', '', '', 0, '2*:*id*:*type_name*:*type*:*Name*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:***********:*w_first_val*:***********:*w_title*:*Title*********Middle*:*w_mini_labels*:**:*w_size*:*normal*:*w_name_format*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:*no***no*:*w_name_fields*:*no*:*w_autofill*:**:*new_field*:*3*:*id*:*type_submitter_mail*:*type*:*Email*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_first_val*:**:*w_title*:*yes*:*w_required*:*no*:*w_unique*:**:*w_class*:*no*:*w_verification*:*Email confirmation*:*w_verification_label*:**:*w_verification_placeholder*:*no*:*w_autofill*:**:*new_field*:*4*:*id*:*type_date_new*:*type*:*Date*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size*:**:*w_date*:*yes*:*w_required*:*yes*:*w_show_image*:**:*w_class*:*mm/dd/yy*:*w_format*:*0*:*w_start_day*:**:*w_default_date*:**:*w_min_date*:**:*w_max_date*:**:*w_invalid_dates*:*yes***yes***yes***yes***yes***yes***yes*:*w_show_days*:*yes*:*w_hide_time*:*...*:*w_but_val*:*no*:*w_disable_past_days*:**:*new_field*:*5*:*id*:*type_radio*:*type*:*Cupcakes Flavors (1 doz. minimum)*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*right*:*w_field_option_pos*:*no*:*w_hide_label*:*ver*:*w_flow*:*Red Velvet***Vanilla***Chocolate***Guinness***Coconut***Lemon***Chocolate Mint*:*w_choices*:*false***false***false***false***false***false***false*:*w_choices_checked*:*1*:*w_rowcol*:*no*:*w_required*:*no*:*w_randomize*:*no*:*w_allow_other*:*0*:*w_allow_other_num*:*no*:*w_value_disabled*:*Red Velvet***Vanilla***Chocolate***Guinness***Coconut***Lemon***Chocolate Mint*:*w_choices_value*:********************:*w_choices_params*:**:*w_class*:**:*new_field*:*6*:*id*:*type_spinner*:*type*:*Quantity*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:*60*:*w_field_width*:**:*w_field_min_value*:**:*w_field_max_value*:*1*:*w_field_step*:*null*:*w_field_value*:*no*:*w_required*:**:*w_class*:**:*new_field*:*7*:*id*:*type_textarea*:*type*:*Details (if any)*:*w_field_label*:**:*w_field_label_size*:*top*:*w_field_label_pos*:*no*:*w_hide_label*:**:*w_size_w*:*100*:*w_size_h*:**:*w_first_val*:**:*w_title*:*no*:*w_required*:*no*:*w_unique*:**:*w_class*:**:*new_field*:*1*:*id*:*type_submit_reset*:*type*:*type_submit_reset_1*:*w_field_label*:*Submit*:*w_submit_title*:*Reset*:*w_reset_title*:**:*w_class*:*false*:*w_act*:**:*new_field*:*', 1, 1, '*', '{adminemail}', '', '', '', 1, '', '{adminemail}', '', '', '', '', '', '', '', '', '', 1, 1, 1, 1, 'administrator,', 0, '', '', 0, 0, 0, 0, 1, 'Cupcake Order Form', '', '', 'none', 1, 1, 0, '');");
      $insert_form_id[] = $wpdb->insert_id;
      }
      else {
        update_option('contact_form_forms', implode(',', $insert_form_id));
      }
    }
  }
}
