﻿using Microsoft.ApplicationBlocks.Data;
using System;
using System.ComponentModel;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using System.Text;
using System.Web;
using CommonFunc;


    public class DataLayer : IDisposable
    {
        public string mainConnectionString = ConfigurationManager.ConnectionStrings["ConnectionString"].ToString();
        private DataLayer()
        {
            
        }
       public static DataLayer Instance = createInstance.obj(new DataLayer());

        public void CheckTimeOut()
        {
            if (HttpContext.Current.Session["AdminUserID"] == null || HttpContext.Current.Session["AdminUserID"].ToString().Trim() == "")
            {
                if (HttpContext.Current.Request.Cookies["AdminLogin"] != null)
                {
                    HttpContext.Current.Session["AdminEmail"] = HttpContext.Current.Request.Cookies["AdminLogin"]["AdminEmail"];
                    HttpContext.Current.Session["AdminUserID"] = HttpContext.Current.Request.Cookies["AdminLogin"]["AdminUserID"];
                    HttpContext.Current.Session["Firstname"] = HttpContext.Current.Request.Cookies["AdminLogin"]["Firstname"];
                    HttpContext.Current.Session["RoleID"] = HttpContext.Current.Request.Cookies["AdminLogin"]["RoleID"];
                    HttpContext.Current.Session["Permissions"] = HttpContext.Current.Request.Cookies["AdminLogin"]["Permissions"];
                }
                else
                {
                    HttpContext.Current.Response.Redirect("logout", true);
                }
            }
        }
        public string[] GetDatafromQuery(string query)
        {

            DataTable dt = SelectDatatable(query);
            int count = dt.Columns.Count;
            if (count == 0)
            {
                count = 1;
            }
            string[] data = new string[count];
            if (dt != null && dt.Rows.Count > 0)
            {
                for (int i = 0; i < dt.Columns.Count; i++)
                {
                    data[i] = dt.Rows[0][i].ToString().Trim();
                }
            }
            else
            {
                data[0] = "";
            }
            return data;
        }
        public DataTable SelectDatatable(string query)
        {
            using (DataSet ds = SqlHelper.ExecuteDataset(ConfigurationManager.ConnectionStrings["ConnectionString"].ToString().Trim(), CommandType.Text, query))
            {
                DataTable dt = new DataTable();
                if (ds != null)
                {
                    if (ds.Tables.Count > 0)
                    {
                        if (ds.Tables[0].Rows.Count > 0)
                        {
                            dt = ds.Tables[0];
                        }
                    }
                }
                return dt;

            }
        }
        private static void PrepareCommand(SqlCommand cmd, SqlConnection conn, CommandType cmdType, string cmdText, params SqlParameter[] cmdParameters)
        {
            if (conn.State != ConnectionState.Open)
                conn.Open();
            cmd.Connection = conn;
            cmd.CommandType = cmdType;
            cmd.CommandText = cmdText;
            if (cmdParameters != null)
            {
                foreach (SqlParameter param in cmdParameters)
                {
                    cmd.Parameters.Add(param);
                }
            }
            conn.Close();
        }
        public DataSet SelectDataSet(string query)
        {
            DataSet ds = new DataSet();
            using (ds = SqlHelper.ExecuteDataset(ConfigurationManager.ConnectionStrings["ConnectionString"].ToString().Trim(), CommandType.Text, query))
            {
                return ds;
            }
        }
        #region return count
        public int ExecuteNonQuery(string query)
        {
            int i = SqlHelper.ExecuteNonQuery(ConfigurationManager.ConnectionStrings["ConnectionString"].ToString().Trim(), CommandType.Text, query);
            return i;
        }
        #endregion
        public bool checkExistance(string query)
        {
            bool isExists = false;
            try
            {
                DataTable dt = SelectDatatable(query);
                if (dt != null && dt.Rows.Count > 0)
                {
                    isExists = true;
                }
            }
            catch
            {
                // conn.Close();
                //throw;
            }
            return isExists;
        }

        #region return datatable
        public DataTable ExecuteStoreProcedure(string SPName, SqlParameter[] perm)
        {

            DataSet ds = new DataSet();
            using (ds = SqlHelper.ExecuteDataset(ConfigurationManager.ConnectionStrings["ConnectionString"].ToString().Trim(), CommandType.StoredProcedure, SPName, perm))
            {
                DataTable dt = new DataTable();
                if (ds != null)
                {
                    if (ds.Tables.Count > 0)
                    {
                        if (ds.Tables[0].Rows.Count > 0)
                        {
                            dt = ds.Tables[0];
                        }
                    }
                }
                return dt;

            }
            #endregion
        }

        public DataSet GetPageElements(string filename, int home, string alias)
        {
            DataSet ds = new DataSet();
            SqlParameter[] prmPageElements = new SqlParameter[3];
            prmPageElements[0] = new SqlParameter("@pagename", filename);
            prmPageElements[1] = new SqlParameter("@IshomePage", home);
            prmPageElements[2] = new SqlParameter("@alias", alias);
            ds = SqlHelper.ExecuteDataset(ConfigurationManager.ConnectionStrings["ConnectionString"].ToString().Trim(), "proc_DisplayPageElements_SSP", prmPageElements);
            return ds;
        }
        #region return datareader
        public SqlDataReader ExecuteStoreProcedureReader(string SPName, SqlParameter[] perm)
        {


            SqlDataReader dr = SqlHelper.ExecuteReader(ConfigurationManager.ConnectionStrings["ConnectionString"].ToString().Trim(), CommandType.StoredProcedure, SPName, perm);
            return dr;

        }
        #endregion
        public bool CheckAuth(string permissionlist, string PermissionFor)
        {

            bool GetPermission = false;
            string[] Permission = permissionlist.Split(',');
            foreach (string dr in Permission)
            {
                if (PermissionFor.ToString().Trim().ToUpper() == dr.ToString().Trim().ToUpper())
                {
                    GetPermission = true;
                    break;
                }
            }

            return GetPermission;
        }
        public void GetSqlTableClass(string path)
        {
            DirectoryFunc.Create(HttpContext.Current.Server.MapPath("/"), path);
            string query = "SELECT name FROM sys.Tables";
            DataTable dtTable = SelectDatatable(query);
            if (dtTable != null && dtTable.Rows.Count > 0)
            {
                for (int i = 0; i < dtTable.Rows.Count; i++)
                {
                    string TableName = dtTable.Rows[i]["name"].ToString().Trim();
                    DataTable dtSchema = GetSchema(TableName);
                    if (dtSchema != null && dtSchema.Rows.Count > 0)
                    {
                        CreateFile(TableName, dtSchema, path);
                    }
                }
            }
        }
        public void CreateFile(string TableName, DataTable dtSchema, string FilePath)
        {
            try
            {
                //Start with a string builder
                StringBuilder sb = new StringBuilder();
                //get our using statements
                sb.Append("using System;" + "\r\n");
                //sb.Append("using System.Data;" + "\r\n");
                //sb.Append("using System.Data.OleDb;" + "\r\n");
                //extra space so it looks ok
                sb.Append("" + "\r\n");
                //now the namespace
                //sb.Append("namespace " + NameSpace + "\r\n");
                //sb.Append("{" + "\r\n");

                //just a quicky summary to identify it as a generated class
                sb.Append("\t" + "/// <summary>" + "\r\n");
                sb.Append("\t" + "/// Generated Class for Table : " + TableName + "." + "\r\n");
                sb.Append("\t" + "/// </summary>" + "\r\n");
                //start with our class name

                sb.Append("\t" + "public class " + TableName + "" + "\r\n");
                sb.Append("\t" + "{" + "\r\n");


                //loop through all columns and get our private vars.
                foreach (DataRow row in dtSchema.Rows)
                {
                    string ColumnName = row["COLUMN_NAME"].ToString();
                    //Data Type is an integer to start
                    string DataType = fieldtypename(row["DATA_TYPE"].ToString());
                    sb.Append("\t" + "\t" + "public " + DataType + " " + ColumnName.ToString() + " {get; set; }" + "\r\n");

                }
                sb.Append("\t" + "}" + "\r\n");
                //sb.Append("\t" + "}" + "\r\n");
                string val = sb.ToString();
                string path = HttpContext.Current.Server.MapPath(FilePath);
                //using (FileStream fs = File.Create(path))
                //{
                //    Byte[] info = new UTF8Encoding(true).GetBytes(val);
                //    // Add some information to the file.
                //    fs.Write(info, 0, info.Length);
                //}


                using (FileStream fs = File.Create(path + "/" + TableName + ".cs"))
                {
                    Byte[] info = new UTF8Encoding(true).GetBytes(val);
                    // Add some information to the file.
                    fs.Write(info, 0, info.Length);
                }

            }
            catch (Exception ex)
            {

            }
        }
        private string fieldtypename(string parm1)
        {
            string fieldtypename;
            switch (parm1)
            {
                case "bigint":
                    fieldtypename = "long"; break;
                case "binary": fieldtypename = "byte[]"; break;
                case "bit": fieldtypename = "bool"; break;
                case "char": fieldtypename = "string"; break;
                case "date": fieldtypename = "DateTime"; break;
                case "datetime": fieldtypename = "DateTime"; break;
                case "datetime2": fieldtypename = "DateTime"; break;
                case "datetimeoffset": fieldtypename = "DateTimeOffset"; break;
                case "decimal": fieldtypename = "decimal"; break;
                case "float": fieldtypename = "float"; break;
                case "image": fieldtypename = "byte[]"; break;
                case "int": fieldtypename = "int"; break;
                case "money": fieldtypename = "decimal"; break;
                case "nchar": fieldtypename = "char"; break;
                case "ntext": fieldtypename = "string"; break;
                case "numeric": fieldtypename = "decimal"; break;
                case "nvarchar": fieldtypename = "string"; break;
                case "real": fieldtypename = "double"; break;
                case "smalldatetime": fieldtypename = "DateTime"; break;
                case "smallint": fieldtypename = "short"; break;
                case "smallmoney": fieldtypename = "decimal"; break;
                case "text": fieldtypename = "string"; break;
                case "time": fieldtypename = "TimeSpan"; break;
                case "timestamp": fieldtypename = "DateTime"; break;
                case "tinyint": fieldtypename = "byte"; break;
                case "uniqueidentifier": fieldtypename = "Guid"; break;
                case "varbinary": fieldtypename = "byte[]"; break;
                case "varchar": fieldtypename = "string"; break;
                default:
                    fieldtypename = "object";
                    break;
            }
            return fieldtypename;
        }
        public DataTable GetSchema(string TableName)
        {
            string schemaQuery = string.Format("select COLUMN_NAME,DATA_TYPE from INFORMATION_SCHEMA.columns where TABLE_NAME='{0}'", TableName);
            DataTable dt = SelectDatatable(schemaQuery);
            return dt;
        }
        public static void DeleteUnwantedImagesFromFolder(string folder, string table, params string[] columns)
        {
            DataLayer obj = new DataLayer();

            string folderPath = HttpContext.Current.Server.MapPath("/" + folder);
            if (columns.Length > 0)
            {
                System.IO.DirectoryInfo folderInfo = new DirectoryInfo(folderPath);
                foreach (FileInfo file in folderInfo.GetFiles())
                {
                    string subquery = "";
                    string filename = (folder.Contains("product-upload-image")) ? file.Name.Replace("-uploaded", "-i-164") : file.Name;
                    for (int i = 0; i < columns.Length; i++)
                    {
                        subquery += " or " + columns[i] + "='" + filename + "'";
                    }
                    subquery = subquery.Substring(3, subquery.Length - 3);
                    string query = "Select 1 from " + table + " where " + subquery;
                    DataTable dt = obj.SelectDatatable(query);
                    if (dt == null || dt.Rows.Count == 0)
                    {
                        file.Delete();
                    }
                }
            }
        }
        public static void DeleteAllImagesFromFolder(string folder)
        {
            System.IO.DirectoryInfo folderInfo = new DirectoryInfo(folder);
            foreach (FileInfo file in folderInfo.GetFiles())
            {
                file.Delete();
            }
        }
        public static string folderpath(string folder)
        {
            return HttpContext.Current.Server.MapPath("/" + folder);
        }

        public static void CropImage(int Width, int Height, string sourceFilePath, string saveFilePath, string format, string ProfilePicture)
        {
            // variable for percentage resize 
            float percentageResize = 0;
            float percentageResizeW = 0;
            float percentageResizeH = 0;

            // variables for the dimension of source and cropped image 
            int sourceX = 0;
            int sourceY = 0;
            int destX = 0;
            int destY = 0;

            // Create a bitmap object file from source file 
            Bitmap sourceImage = new Bitmap(sourceFilePath);

            // Set the source dimension to the variables 
            int sourceWidth = sourceImage.Width;
            int sourceHeight = sourceImage.Height;

            // Calculate the percentage resize 
            percentageResizeW = ((float)Width / (float)sourceWidth);
            percentageResizeH = ((float)Height / (float)sourceHeight);

            // Checking the resize percentage 
            if (percentageResizeH < percentageResizeW)
            {
                percentageResize = percentageResizeW;
                destY = System.Convert.ToInt16((Height - (sourceHeight * percentageResize)) / 2);
            }
            else
            {
                percentageResize = percentageResizeH;
                destX = System.Convert.ToInt16((Width - (sourceWidth * percentageResize)) / 2);
            }

            // Set the new cropped percentage image
            int destWidth = (int)Math.Round(sourceWidth * percentageResize);
            int destHeight = (int)Math.Round(sourceHeight * percentageResize);

            // Create the image object 
            using (Bitmap objBitmap = new Bitmap(Width, Height))
            {
                objBitmap.SetResolution(sourceImage.HorizontalResolution, sourceImage.VerticalResolution);
                using (Graphics objGraphics = Graphics.FromImage(objBitmap))
                {
                    // Set the graphic format for better result cropping 
                    objGraphics.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.AntiAlias;
                    objGraphics.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.HighQualityBicubic;
                    objGraphics.DrawImage(sourceImage, new Rectangle(destX, destY, destWidth, destHeight), new Rectangle(sourceX, sourceY, sourceWidth, sourceHeight), GraphicsUnit.Pixel);

                    // Save the file path, note we use png format to support png file 
                    if (format.ToLower() == "png")
                    {
                        objBitmap.Save(saveFilePath, ImageFormat.Png);
                    }
                    if (format.ToLower() == "jpeg")
                    {
                        objBitmap.Save(saveFilePath, ImageFormat.Jpeg);
                    }
                    if (format.ToLower() == "jpg")
                    {
                        objBitmap.Save(saveFilePath, ImageFormat.Jpeg);
                    }

                    objGraphics.Dispose();
                }
                objBitmap.Dispose();
            }
            sourceImage.Dispose();
            // System.IO.File.Delete(sourceFilePath);
        }
        public static void CropImage(string sourceFilePath, string saveFilePath, string newFilename, string originalFilename, int Width, int Height)
        {
            // variable for percentage resize 
            float percentageResize = 0;
            float percentageResizeW = 0;
            float percentageResizeH = 0;

            // variables for the dimension of source and cropped image 
            int sourceX = 0;
            int sourceY = 0;
            int destX = 0;
            int destY = 0;

            // Create a bitmap object file from source file 
            Bitmap sourceImage = new Bitmap(sourceFilePath + originalFilename);

            // Set the source dimension to the variables 
            int sourceWidth = sourceImage.Width;
            int sourceHeight = sourceImage.Height;

            // Calculate the percentage resize 
            percentageResizeW = ((float)Width / (float)sourceWidth);
            percentageResizeH = ((float)Height / (float)sourceHeight);

            // Checking the resize percentage 
            if (percentageResizeH < percentageResizeW)
            {
                percentageResize = percentageResizeW;
                destY = System.Convert.ToInt16((Height - (sourceHeight * percentageResize)) / 2);
            }
            else
            {
                percentageResize = percentageResizeH;
                destX = System.Convert.ToInt16((Width - (sourceWidth * percentageResize)) / 2);
            }

            // Set the new cropped percentage image
            int destWidth = (int)Math.Round(sourceWidth * percentageResize);
            int destHeight = (int)Math.Round(sourceHeight * percentageResize);

            // Create the image object 
            using (Bitmap objBitmap = new Bitmap(Width, Height))
            {
                objBitmap.SetResolution(sourceImage.HorizontalResolution, sourceImage.VerticalResolution);
                using (Graphics objGraphics = Graphics.FromImage(objBitmap))
                {
                    // Set the graphic format for better result cropping 
                    objGraphics.InterpolationMode = System.Drawing.Drawing2D.InterpolationMode.HighQualityBicubic;
                    objGraphics.SmoothingMode = System.Drawing.Drawing2D.SmoothingMode.HighQuality;
                    objGraphics.PixelOffsetMode = System.Drawing.Drawing2D.PixelOffsetMode.HighQuality;
                    objGraphics.CompositingQuality = System.Drawing.Drawing2D.CompositingQuality.HighQuality;
                    objGraphics.DrawImage(sourceImage, new Rectangle(destX, destY, destWidth, destHeight), new Rectangle(sourceX, sourceY, sourceWidth, sourceHeight), GraphicsUnit.Pixel);
                    EncoderParameters parameters = UploadFunc.Encoderparameter();
                    string imageformat = newFilename.Split('.')[1];
                    ImageCodecInfo myImageCodecInfo = UploadFunc.GetEncoderInfo(imageformat);
                    // Save the file path, note we use png format to support png file 
                    objBitmap.Save(saveFilePath + newFilename, myImageCodecInfo, parameters);

                    objGraphics.Dispose();
                }
                objBitmap.Dispose();
            }
            sourceImage.Dispose();
            // System.IO.File.Delete(sourceFilePath);
        }
        [Description("Use no out paramter use Null for OutParam")]
        public SqlParameter[] CreateParameter(object OutParam, params object[] field)
        {
            SqlParameter[] perm;
            if (field.Length % 2 == 0)
            {
                perm = new SqlParameter[field.Length / 2];
                int j = 0;
                for (int i = 0; i < field.Length; i = i + 2)
                {
                    if (field[i + 1] == null)
                    {
                        perm[j] = new SqlParameter("@" + field[i].ToString() + "".Trim(), null);
                    }
                    else
                    {
                        //var data = (field[i + 1].GetType() == typeof(Int32) || field[i].GetType() == typeof(decimal)) ? field[i + 1] : HttpUtility.HtmlEncode(field[i + 1].ToString().Trim());
                        perm[j] = new SqlParameter("@" + field[i].ToString() + "".Trim(), field[i + 1]);
                    }
                    j++;
                }
                if (OutParam != null)
                {
                    perm[j] = new SqlParameter("@" + OutParam + "".Trim(), OutParam.GetType());
                    perm[j].Direction = ParameterDirection.Output;
                }
            }
            else
            {
                perm = new SqlParameter[0];
            }
            return perm;
        }
        [Description("Use no out paramter use Null for OutParam")]
        public SqlParameter[] CreateParameterWithEncode(object OutParam, params object[] field)
        {
            SqlParameter[] perm;
            if (field.Length % 2 == 0)
            {
                perm = new SqlParameter[field.Length / 2];
                int j = 0;
                for (int i = 0; i < field.Length; i = i + 2)
                {
                    if (field[i + 1] == null)
                    {
                        perm[j] = new SqlParameter("@" + field[i].ToString() + "".Trim(), null);
                    }
                    else
                    {
                        var data = (field[i + 1].GetType() == typeof(Int32) || field[i].GetType() == typeof(decimal)) ? field[i + 1] : HttpUtility.HtmlEncode(field[i + 1].ToString().Trim());
                        perm[j] = new SqlParameter("@" + field[i].ToString() + "".Trim(), data);
                    }
                    j++;
                }
                if (OutParam != null)
                {
                    perm[j] = new SqlParameter("@" + OutParam + "".Trim(), OutParam.GetType());
                    perm[j].Direction = ParameterDirection.Output;
                }
            }
            else
            {
                perm = new SqlParameter[0];
            }
            return perm;
        }
        public DataTable ExecuteProcedureWithDataReturn(string ProcedureName, params object[] field)
        {
            DataTable dt = new DataTable();
            SqlParameter[] perm = CreateParameter(field);
            if (perm.Length > 0)
            {
                dt = ExecuteStoreProcedure(ProcedureName, perm);
            }
            return dt;
        }
        public object[] ExecuteNonQueryProcedureWithParameter(string ProcedureName, object OutParam, params object[] field)
        {
            object[] result = new object[2];
            SqlParameter[] perm = CreateParameterWithEncode(OutParam, field);
            if (perm.Length <= 0)
            {
                result[0] = "-1";
                return result;
            }

            int status = SqlHelper.ExecuteNonQuery(mainConnectionString, ProcedureName, perm);
            result[0] = status;
            if (OutParam != null)
            {
                result[1] = perm[perm.Length - 1].ToString().Trim();
            }
            return result;
        }
        [Description("Use no out paramter use Null for OutParam")]
        public object[] InsertUpdateDelete(string storedprocedure, object OutParam, params object[] parameters)
        {
            object[] result = new object[2];
            SqlParameter[] perm = CreateParameter(OutParam, parameters);
            if (perm.Length == 0)
            {
                result[0] = "-1";
                return result;
            }
            int status = SqlHelper.ExecuteNonQuery(ConfigurationManager.ConnectionStrings["ConnectionString"].ToString().Trim(), storedprocedure, perm);
            result[0] = status;
            if (OutParam != null)
            {
                result[1] = perm[perm.Length - 1].ToString().Trim();
            }
            return result;
        }

        public void ExporttoExcel(DataTable table, string filename)
        {
            HttpContext.Current.Response.Clear();
            HttpContext.Current.Response.ClearContent();
            HttpContext.Current.Response.ClearHeaders();
            HttpContext.Current.Response.Buffer = true;
            HttpContext.Current.Response.ContentType = "application/ms-excel";
            HttpContext.Current.Response.Write(@"<!DOCTYPE HTML PUBLIC ""-//W3C//DTD HTML 4.0 Transitional//EN"">");
            HttpContext.Current.Response.AddHeader("Content-Disposition", "attachment;filename=" + filename + ".xls");

            HttpContext.Current.Response.Charset = "utf-8";
            HttpContext.Current.Response.ContentEncoding = System.Text.Encoding.GetEncoding("windows-1250");
            //sets font
            HttpContext.Current.Response.Write("<font style='font-size:10.0pt; font-family:Calibri;'>");
            HttpContext.Current.Response.Write("<BR><BR><BR>");
            //sets the table border, cell spacing, border color, font of the text, background, foreground, font height
            HttpContext.Current.Response.Write("<Table border='1' bgColor='#ffffff' " +
              "borderColor='#000000' cellSpacing='0' cellPadding='0' " +
              "style='font-size:10.0pt; font-family:Calibri; background:white;'> <TR>");
            //am getting my grid's column headers
            int columnscount = table.Columns.Count;
#pragma warning disable CS0219 // The variable 'catcolomnid' is assigned but its value is never used
            int catcolomnid = 0;
#pragma warning restore CS0219 // The variable 'catcolomnid' is assigned but its value is never used
            for (int j = 0; j < columnscount; j++)
            {      //write in new column
                HttpContext.Current.Response.Write("<Td>");
                HttpContext.Current.Response.Write("<B>");
                HttpContext.Current.Response.Write(table.Columns[j].ToString());
                HttpContext.Current.Response.Write("</B>");
                HttpContext.Current.Response.Write("</Td>");

            }
            HttpContext.Current.Response.Write("</TR>");
            foreach (DataRow row in table.Rows)
            {//write in new row
                HttpContext.Current.Response.Write("<TR>");
                for (int i = 0; i < table.Columns.Count; i++)
                {
                    HttpContext.Current.Response.Write("<Td>");
                    HttpContext.Current.Response.Write(HttpUtility.HtmlDecode(Convert.ToString(row[i]).Trim()));
                    HttpContext.Current.Response.Write("</Td>");

                }

                HttpContext.Current.Response.Write("</TR>");
            }
            HttpContext.Current.Response.Write("</Table>");
            HttpContext.Current.Response.Write("</font>");
            HttpContext.Current.Response.Flush();
            HttpContext.Current.Response.End();
        }

        bool disposed = false;
        // Instantiate a SafeHandle instance.
        System.Runtime.InteropServices.SafeHandle handle = new Microsoft.Win32.SafeHandles.SafeFileHandle(IntPtr.Zero, true);
        public void Dispose()
        {
            Dispose(true);
            GC.SuppressFinalize(this);
        }
        protected virtual void Dispose(bool disposing)
        {
            if (disposed)
                return;

            if (disposing)
            {
                handle.Dispose();
                GC.Collect();
                GC.WaitForPendingFinalizers();
                // Free any other managed objects here.
                //
            }

            // Free any unmanaged objects here.
            //
            disposed = true;
        }
    }

