﻿using EnvigoHiring.Models.Position;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using CommonFunc;

namespace EnvigoHiring.Controllers
{
    public class positionController : Controller
    {
        // GET: position
        [CustomAuthorize(Roles = "Admin,User")]
        public ActionResult addposition(string id)
        {
            PositionModel pm = new PositionModel();
            pm.Department = pm.DepartmentList();
            if (id != null && id != "")
            {
                if (!CheckFunc.IsNumeric(id))
                {
                    return RedirectToAction("viewposition", "position");
                }
                pm.PositionID = Int32.Parse(id);
                bool result = pm.Filldata();
                if (result == false)
                {
                    return RedirectToAction("viewposition", "position");
                }
            }
            return View(pm);
        }
        [CustomAuthorize(Roles = "Admin,User")]
        [HttpPost]
        public ActionResult addposition(PositionModel pm, string btnsubmit, string btnupload, string id, string ddlDepartment)
        {
            ModelState.Clear();

            //pm.loadMainCategory();
            //pm.loadCompanyCategory();
            if (id != null && id != "")
            {
                if (!CheckFunc.IsNumeric(id))
                {
                    return RedirectToAction("viewposition", "position");
                }
                pm.PositionID = Convert.ToInt32(id);
            }
            else
            {
                pm.PositionID = 0;
            }
            //When submit button Clicked
            if (btnsubmit == "Submit")
            {
                pm.SaveData();
                //if error on saving data
                if (pm.MessageType == "danger")
                {
                    return View(pm);
                }
                else
                {
                    return Redirect("/position/viewposition");
                }
            }
            //When cancel button Clicked
            else if (btnsubmit == "Cancel")
            {
                return RedirectToAction("viewproduct", "product");
            }

            if (pm.PositionID > 0)
            {
                //Load Form
                //pm.loadSubCompanyCategory(pm.ddlCompanyCategory);
                pm.Filldata();

                //pm.loadGallery(Int32.Parse(pm.ID),"Product");
            }
            else
            {
                pm.ddlDepartment = ddlDepartment;
                pm.DesignationList(pm.ddlDepartment);
            }

            return View(pm);
        }

        //[CustomAuthorize(Roles = "Admin,User,Recruiter")]
        public ActionResult viewposition()
        {
            PositionModel cm = new PositionModel();
            cm.dtPosition = cm.viewPosition();
            return View(cm);
        }
        [CustomAuthorize(Roles = "Admin,User,Recruiter")]
        [ActionName("view-inactive-position")]
        public ActionResult viewinactiveposition()
        {
            PositionModel cm = new PositionModel();
            cm.dtPosition = cm.viewInActivePosition();
            return View(cm);
        }
        [CustomAuthorize(Roles = "Admin,User,Recruiter")]
        public ActionResult addjobdescription(string id)
        {
            JDModel jm = new JDModel();
            if (id != null && id != "")
            {
                if (!CheckFunc.IsNumeric(id))
                {
                    return RedirectToAction("viewposition", "position");
                }
                jm.PositionID = Int32.Parse(id);
                jm.FillData();
                
            }
            
            return View(jm);
        }
        [CustomAuthorize(Roles = "Admin,User,Recruiter")]
        [HttpPost]
        public ActionResult addjobdescription(JDModel jm, string id, string btnSubmit, string btnApprove, string btnReject)
        {
            if (id != null && id != "")
            {
                if (!CheckFunc.IsNumeric(id))
                {
                    return RedirectToAction("viewposition", "position");
                }
                jm.PositionID = Int32.Parse(id);
            }
            
            if (btnSubmit == "Submit")
            {
                jm.SaveData();
                //if error on saving data
                if (jm.MessageType == "success")
                {
                    return Redirect("/position/viewposition");
                }
            }
            if (btnApprove == "Approve")
            {
                jm.Approve();
            }
            if (btnReject == "Reject")
            {
                jm.Reject();
            }

            jm.FillData();
            return View(jm);
        }

    }
}