﻿using EnvigoHiring.Models.Department;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;

namespace EnvigoHiring.Controllers
{
    [CustomAuthorize(Roles = "Admin")]
    public class DepartmentController : Controller
    {
        // GET: Department
        public ActionResult Index()
        { 
            Department ds = new Department();
            ds.ListData = ds.getdata();
            return View(ds);
        }
        public ActionResult add()
        {
            Department ds = new Department();
            return View(ds);
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult add(Department ds)
        {
            if (ModelState.IsValid)
            {
                if (!CommonFunctions.CheckSpecialCharTextBoxString(ds.DepartmentName) || ds.DepartmentName == "")
                {
                    ds.MessageType = "danger";
                    ds.lblMessage = "Special Char not allowed !";
                    return View(ds);
                }

                if (ds.CheckDepartment(0))
                {
                    ds.MessageType = "danger";
                    ds.lblMessage = "Department with same name already exist !";
                    return View(ds);
                }
                int i = ds.add();
                if (i > 0)
                {
                    ds.MessageType = "success";
                    ds.lblMessage = "Department added successfuly.";
                    return View(ds);
                }
                else
                {
                    ds.MessageType = "danger";
                    ds.lblMessage = "There are some issue, Please try after some time!";
                    return View(ds);
                }
            }
            else
            {
                ds.MessageType = "danger";
                ds.lblMessage = "There are some issue, Please try after some time!";
                return View(ds);
            }

        }

        public ActionResult edit(int id)
        {
            Department ds = new Department();
            ds.DepartmentID = id;
            ds.ListData = ds.EditData();
            if (ds.ListData != null && ds.ListData.Rows.Count > 0)
            {
                ds.DepartmentName = HttpUtility.HtmlDecode(ds.ListData.Rows[0]["DepartmentName"].ToString().Trim());
            }
            else
            {
                Response.Redirect("index");
            }
            return View(ds);
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult edit(int id, Department ds)
        {
            if (ModelState.IsValid)
            {
                ds.DepartmentID = id;
                if (!CommonFunctions.CheckSpecialCharTextBoxString(ds.DepartmentName) || ds.DepartmentName == "")
                {
                    ds.MessageType = "danger";
                    ds.lblMessage = "Special Char not allowed !";
                    return View(ds);
                }
                if (ds.CheckDepartment(ds.DepartmentID))
                {
                    ds.MessageType = "danger";
                    ds.lblMessage = "Department with same name already exist !";
                    return View(ds);
                }
                int x = ds.edit();
                if (x > 0)
                {
                    ds.MessageType = "success";
                    ds.lblMessage = "Department updated successfuly.";
                    return View(ds);
                }
                else
                {
                    ds.MessageType = "danger";
                    ds.lblMessage = "There are some issue, Please try after some time!";
                    return View(ds);
                }

            }
            else
            {
                ds.MessageType = "danger";
                ds.lblMessage = "There are some issue, Please try after some time!";
                return View(ds);
            }
        }
    }
}