﻿using System;
using System.Web.Mvc;
using EnvigoHiring.Models.Applicants;
namespace EnvigoHiring.Controllers
{
    [CustomAuthorize(Roles = "Admin, Recruiter")]
    public class ApplicantDisplayAllController : Controller
    {
        // GET: AppicantDisplayAll
        public ActionResult Index(int ID)
        {
            Display applicant = new Display();
            applicant.ApplicantID = ID;
            applicant.ApplicantData = applicant.GetApplicantData();
            applicant.ApplicantRounds = applicant.GetApplicantRounds();
            applicant.RoundsRating = applicant.GetRoundsRating();
            applicant.UserList = applicant.Getusers();
            return View(applicant);
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult Index(int ID, Display applicant, string btndelete, string btnsubmit)
        {

            if (ModelState.IsValid)
            {
                applicant.ApplicantID = ID;
                int interviewer = applicant.UserID;
                string SheduledDate = applicant.sheduledOn;

                if (!CommonFunctions.IsDate(SheduledDate))
                {
                    applicant.MessageType = "danger";
                    applicant.lblMessage = "Date is not in a correct format!";
                    applicant.ApplicantData = applicant.GetApplicantData();
                    applicant.ApplicantRounds = applicant.GetApplicantRounds();
                    applicant.RoundsRating = applicant.GetRoundsRating();
                    applicant.UserList = applicant.Getusers();
                    return View(applicant);
                }
                if (applicant.checklastRound())
                {
                    applicant.MessageType = "danger";
                    applicant.lblMessage = "Last round is pendng, please complete/delete or edit last round!";
                    applicant.ApplicantData = applicant.GetApplicantData();
                    applicant.ApplicantRounds = applicant.GetApplicantRounds();
                    applicant.RoundsRating = applicant.GetRoundsRating();
                    applicant.UserList = applicant.Getusers();
                    return View(applicant);
                }
                //int i = applicant.addRound();

                DateTime tmp;
                DateTime.TryParse(applicant.sheduledOn, out tmp);
                applicant.sheduledOn = tmp.ToString();
                int i = applicant.addRound();
                if (i > 0)
                {
                    applicant.MessageType = "success";
                    applicant.lblMessage = "Interview Round has been sheduled.";
                }
                else
                {
                    applicant.MessageType = "danger";
                    applicant.lblMessage = "Please try after some time!";
                }
                applicant.ApplicantData = applicant.GetApplicantData();
                applicant.ApplicantRounds = applicant.GetApplicantRounds();
                applicant.RoundsRating = applicant.GetRoundsRating();
                applicant.UserList = applicant.Getusers();
                return View(applicant);
            }

            applicant.ApplicantData = applicant.GetApplicantData();
            applicant.ApplicantRounds = applicant.GetApplicantRounds();
            applicant.RoundsRating = applicant.GetRoundsRating();
            applicant.UserList = applicant.Getusers();
            return View(applicant);
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult delete(int ID, Display applicant, string btndelete)
        {
            if (btndelete == "Delete")
            {
                applicant.ApplicantID = ID;
                applicant.deleteround();
            }
            return RedirectToAction("index/" + ID.ToString(), "applicantdisplayall");
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult interviewstatus(int ID, Display applicant,string btnIntrvwStatus)
        {
            if (btnIntrvwStatus == "ChangeStatus")
            {
                applicant.ApplicantID = ID;
                applicant.UpdateInterviewStatus();
            }
            return RedirectToAction("index/" + ID.ToString(), "applicantdisplayall");
        }
    }
}