﻿using System.Linq;
using System.Web.Mvc;
using System.Web.Mvc.Filters;

public class CustomAuthorizeAttribute : FilterAttribute, IAuthenticationFilter
{
    public string Roles { get; set; }
    public string CookieName { get; set; }
    string currentArea = "";
    string Area = "";
    public void OnAuthentication(AuthenticationContext context)
    {
        var area = context.RouteData.DataTokens["area"];
        var user = context.HttpContext.User;
        string cookie = (CookieName != null && CookieName != "") ? CookieName : "";
        var UserData = Userlogin.getloginUserDetail(new MembershipUser(),cookie);
        // Area = (UserData.GetType().GetProperty("Area") != null) ? UserData.Area : "";
        var RoleArray = (Roles!=null && Roles!="")?Roles.Split(','):"".Split(',');
        if (context.HttpContext.User.Identity.IsAuthenticated)
        {
            if (Roles != null && Roles != "")
            {
                string Role = (UserData.GetType().GetProperty("Roles") != null) ? UserData.Roles : "";
                if (Role == "")
                {
                    context.Result = new HttpUnauthorizedResult();
                    currentArea = (Area != null && Area != "") ? Area : (area != null && area.ToString() != "") ? area.ToString() : "";
                }
                if (Role!="" && !RoleArray.Any(s=>s.Trim().Equals(Role)))
                {
                    context.Result = new HttpUnauthorizedResult();
                    currentArea = (Area != null && Area != "") ? Area : (area!=null && area.ToString()!="")?area.ToString():"";
                }
                if (area != null && area.ToString() != "" && Area != null && Area != "")
                {
                    if (Role.Contains(Roles) && !area.ToString().Equals(Area))
                    {
                        context.Result = new HttpUnauthorizedResult();
                        currentArea = (Area != null && Area != "") ? Area : (area != null && area.ToString() != "") ? area.ToString() : "";
                    }
                }
            }
        }
        else
        {
            context.Result = new HttpUnauthorizedResult();
            currentArea = (Area != null && Area != "") ? Area : (area != null && area.ToString() != "") ? area.ToString() : "";
        }
    }

    public void OnAuthenticationChallenge(AuthenticationChallengeContext context)
    {

        if (context.Result == null)
        {
            context.Result = new RedirectToRouteResult(new System.Web.Routing.RouteValueDictionary(
         new { area = currentArea, controller = "login", action = "index", returnUrl = context.HttpContext.Request.RawUrl }));
        }
        if (context.Result is HttpUnauthorizedResult)
        {
            if ((currentArea.Equals(Area)))
            {
                context.Result = new RedirectToRouteResult(new System.Web.Routing.RouteValueDictionary(
         new { area = currentArea, controller = "login", action = "index", returnUrl = context.HttpContext.Request.RawUrl }));
            }
            else
            {
                context.Result = new RedirectToRouteResult(new System.Web.Routing.RouteValueDictionary(
         new { area = currentArea, controller = "login", action = "index", returnUrl = context.HttpContext.Request.RawUrl }));
            }
        }


    }
    
    
    //protected override void HandleUnauthorizedRequest(AuthorizationContext filterContext)
    //{
    //    string loginUrl = "";

    //    if (area == "admin")
    //    {
    //        loginUrl = "~/admin/login";
    //    }
    //    else if (area == "gallery")
    //    {
    //        loginUrl = "~/gallery/login";
    //    }

    //    filterContext.Result = new RedirectResult(loginUrl + "?returnUrl=" + filterContext.HttpContext.Request.Url.PathAndQuery);
    //}
}
