﻿using EnvigoHiring.Models.Applicants;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using CommonFunc;

namespace EnvigoHiring.Controllers
{

    public class applicantsController : Controller
    {
        // GET: applicants
        [CustomAuthorize(Roles = "Admin, Recruiter")]
        public ActionResult Index(string id)
        {
            ApplicantsDetail ad = new ApplicantsDetail();
            if (id != null && id != "")
            {
                if (!CheckFunc.IsNumeric(id))
                {
                    return RedirectToAction("index", "applicants");
                }
            }
            ad.dtApplicant = ad.DisplayApplicants(id.ToInt32());
            if (ad.dtApplicant == null || ad.dtApplicant.Rows.Count == 0)
            {
                return RedirectToAction("index", "applicants");
            }
            return View(ad);
        }
        [CustomAuthorize(Roles = "Admin, Recruiter,User")]
        public ActionResult position(string id)
        {
            ApplicantsDetail ad = new ApplicantsDetail();
            if (id != null && id != "")
            {
                if (!CheckFunc.IsNumeric(id))
                {
                    return RedirectToAction("position", "applicants");
                }
            }
            ad.dtApplicant = ad.DisplayApplicantsByPosition(id.ToInt32());
            if (ad.dtApplicant == null || ad.dtApplicant.Rows.Count == 0)
            {
                return RedirectToAction("position", "applicants");
            }
            return View(ad);
        }
        [CustomAuthorize(Roles = "Admin, Recruiter,User")]
        [HttpPost]
        public ActionResult position(ApplicantsDetail ad, string id,string btnActivate)
        {
            if (id != null && id != "")
            {
                if (!CheckFunc.IsNumeric(id))
                {
                    return RedirectToAction("position", "applicants");
                }
                ad.PositionID = id.ToInt32();
            }
            if (btnActivate!=null && btnActivate.Length>0 && btnActivate.Split('_')[0] == "Activate")
            {
                var ActArray = btnActivate.Split('_');

                int CandID = (ActArray.Length > 1) ? ActArray[1].ToString().ToInt32() : 0;
                ad.ActivatereOpenApplicant(CandID);
                if (CandID == 0)
                {
                    ad.alert("Alert! Please try again", false);
                }
            }
            ad.dtApplicant = ad.DisplayApplicantsByPosition(id.ToInt32());
            if (ad.dtApplicant == null || ad.dtApplicant.Rows.Count == 0)
            {
                return RedirectToAction("position", "applicants");
            }
            return View(ad);
        }
        [Route("~/applicants/Interviewerinputs/{ApplicantID}")]
        [CustomAuthorize(Roles = "Admin, User")]
        public ActionResult Interviewerinputs(int ApplicantID)
        {
            InterviewInputs inp = new InterviewInputs();
            if (ApplicantID > 0)
            {
                inp.ApplicantdID = ApplicantID.ToString();
                inp.DisplayApplicantsStatus();
            }
            else
            {
                return RedirectToAction("index", "applicants");
            }
            return View(inp);
        }
        [Route("~/applicants/Interviewerinputs/{ApplicantID}")]
        [HttpPost]
        [CustomAuthorize(Roles = "Admin, User")]
        public ActionResult Interviewerinputs(InterviewInputs inp, int ApplicantID, string btnsubmit)
        {
            if (ApplicantID > 0)
            {
                inp.ApplicantdID = ApplicantID.ToString();
            }
            else
            {
                return RedirectToAction("index", "applicants");
            }
            if (btnsubmit == "Submit")
            {
                inp.SaveData();
            }
            inp.DisplayApplicantsStatus();
            return View(inp);
        }
        [Route("~/applicants/edit/{PositionID}/{candidateID}")]
        [CustomAuthorize(Roles = "Admin, Recruiter")]
        public ActionResult edit(int PositionID, int candidateID)
        {
            ApplicantsDetail ad = new ApplicantsDetail();
            if (PositionID > 0 && candidateID > 0)
            {
                ad.CandidateID = candidateID;
                ad.PositionID = PositionID;
                bool result = ad.FillData();
                if (result == false)
                {
                    return RedirectToAction("index", "applicants");
                }
            }
            else
            {
                return RedirectToAction("index", "applicants");
            }
            return View(ad);
        }
        [HttpPost]
        [Route("~/applicants/edit/{PositionID}/{candidateID}")]
        [CustomAuthorize(Roles = "Admin, Recruiter")]
        public ActionResult edit(ApplicantsDetail ad, int PositionID, int candidateID, string btnSubmit)
        {
            if (PositionID > 0 && candidateID > 0)
            {
                ad.CandidateID = candidateID;
                ad.PositionID = PositionID;
            }
            else
            {
                return RedirectToAction("index", "applicants");
            }
            if (btnSubmit == "Submit")
            {
                ad.SaveData();
                //if error on saving data
                if (ad.MessageType == "success")
                {
                    return Redirect("/candidateselection/select/" + PositionID);
                }
            }
            bool result = ad.FillData();
            if (result == false)
            {
                return Redirect("/candidateselection/select/" + PositionID);
            }
            return View(ad);
        }
    }
}