﻿using System;
using System.ComponentModel.DataAnnotations;
using System.Data;
using System.Data.SqlClient;
using System.Web;

namespace EnvigoHiring.Models.Login
{
    public class LoginModel
    {
        public string UserID { get; set; }
        public string lblMessage { get; set; }
        public bool Display { get; set; }
        public string SetCSS { get; set; }
        public string MessageType { get; set; }
        public string redirection_url { get; set; }
        public string clientid { get; set; }
        public bool IsAntiForgery { get; set; }
     
        DataLayer obj = DataLayer.Instance;
        GLogin login = new GLogin();
        public LoginModel()
        {
            redirection_url = login.redirection_url;
            clientid = login.clientid;
        }

        public void GetUserprofile(string code, string ReturnUrl)
        {
            var user = login.UserProfile(code);
            string username = user.DisplayName;
            string Email = user.Emails.Find(email => email.Type == "account").Value;
            string UserID = user.Id;
            int i = SaveToDatabase(Email, username);
            if (i != 0)
            {
                DataTable dt = GetUserDetail(Email);
                if (dt != null && dt.Rows.Count > 0)
                {
                    string status = dt.Rows[0]["status"].ToString().Trim();
                    if (status == "0")
                    {
                        HttpContext.Current.Response.Redirect("login/thankyou");
                        //Take to thank you page
                    }
                    else
                    {

                        MembershipUser userModel = new MembershipUser
                        {
                            UserName = username,
                            UserEmail = Email,
                            UserID = dt.Rows[0]["UserID"].ToString().Trim(),
                            RoleID = dt.Rows[0]["Role"].ToString().Trim(),
                            Roles = dt.Rows[0]["RoleName"].ToString().Trim(),
                            pic = user.Image.url.ToString()
                        };
                        Userlogin.AuthoriseUser(userModel, Email, ReturnUrl: ReturnUrl);
                    }
                }
            }
            else
            {
                alert("Alert! Please try again later", false);
            }
        }



        public int SaveToDatabase(string Email, string username)
        {
            int i = 0;
            try
            {
                if (Email != null && Email != "")
                {
                    if (isDuplicateUser(Email) == false)
                    {
                        SqlParameter[] prmRecord = new SqlParameter[2];
                        prmRecord[0] = new SqlParameter("@UserName", username);
                        prmRecord[1] = new SqlParameter("@UserEmail", Email);
                        DataTable dtSuccess = obj.ExecuteStoreProcedure("proc_tblUserLogin", prmRecord);
                        if (dtSuccess != null)
                        {
                            i = 1;
                        }
                        else
                        {
                            i = 0;
                        }
                    }
                    else { i = 1; }
                }

            }
            catch
            {
                i = 0;
            }
            return i;
        }
        protected DataTable GetUserDetail(string Email)
        {
            string Query = string.Format(@"SELECT tblUserLogin.UserID, tblUserLogin.UserEmail, tblUserLogin.UserName, tblUserLogin.LastLoginDate, tblUserLogin.Createdate, tblUserLogin.Status, tblUserLogin.Role, tblMasterRole.RoleName
                    FROM  tblUserLogin LEFT OUTER JOIN tblMasterRole ON tblUserLogin.Role = tblMasterRole.RoleID where tblUserLogin.UserEmail = '{0}' ", Email);
            DataTable dt = obj.SelectDatatable(Query);
            return dt;
        }
        protected bool isDuplicateUser(string EmailID)
        {
            try
            {
                bool result = false;
                DataTable dt = GetUserDetail(EmailID);
                if (dt != null && dt.Rows.Count > 0)
                {
                    result = true;
                }
                else
                {
                    result = false;
                }
                return result;
            }
            catch
            {
                return false;
            }
        }
        public void alert(string message, bool success)
        {
            lblMessage = message;
            MessageType = (success == true) ? "success" : "error";
        }
    }
}
