﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using CommonFunc;
using System.Data.SqlClient;
using System.Web.Mvc;
using System.Configuration;

namespace EnvigoHiring.Models.CandidateSelection
{
    public class SelectionModel : BaseClass
    {
        public int PositionID { get; set; }
        public string Department { get; set; }
        public string Designation { get; set; }
        public DataTable dtCandidate { get; set; }
        public DataTable dtSelectedCandidate { get; set; }
        public string CandidateList { get; set; }
        DataLayer obj = DataLayer.Instance;
        public void FillData()
        {
            string query = "Select t1.positionID,DepartmentName,DesignationName,candidate from tblSuggestedApplicants t right outer join vwPosition t1 on (t.PositionID=t1.PositionID) where t1.JDStatus>0 and t1.PositionID=" + PositionID;
            dtSelectedCandidate = obj.SelectDatatable(query);
            if (dtSelectedCandidate != null && dtSelectedCandidate.Rows.Count > 0)
            {
                DataRow row = dtSelectedCandidate.Rows[0];
                PositionID = row.SetParamValue("PositionID").ToInt32();
                Department = row.SetParamValue("DepartmentName");
                Designation = row.SetParamValue("DesignationName");
                FilePath = ConfigurationManager.AppSettings["ResumePath"].ToString().Trim();
                dtCandidate = viewcandidate();
            }
            else
            {
                HttpContext.Current.Response.Redirect("/position/viewposition");
            }
        }
        public bool CandidateSelected(string candidateID)
        {
            bool result = false;
            if (dtSelectedCandidate != null && dtSelectedCandidate.Rows.Count > 0)
            {
                foreach (DataRow row in dtSelectedCandidate.Rows)
                {
                    if (row.SetParamValue("candidate") == candidateID)
                    {
                        result = true;
                    }
                }
            }
            return result;
        }
        public DataTable viewcandidate()
        {
            string query = string.Format(@"select distinct t.CandidateID,aplcnt.CurrentStatus,aplcnt.positionid,Name,t.Experience,EmailID,CandidateStatus,Source,Gender,ResumeName,ResumeGoogleLink,LastContactedDate,Education,LastApplicantID,DepartmentName,aplcnt.Candidate as selectedcandidate
            ,apl.ApplicantID from tblMasterCandidatePool t inner join tblMasterDepartment t1 on(t.InterestedDepartmentID = t1.DepartmentID) left outer join tblSuggestedApplicants aplcnt on (t.CandidateID=aplcnt.Candidate ) 
		   left outer join tblApplicants apl on (aplcnt.PositionID=apl.PositionID and aplcnt.Candidate=apl.CandidateID)
		   where ((aplcnt.PositionID is null or aplcnt.positionid={0})   or (aplcnt.positionid!={0} and aplcnt.CurrentStatus!='Approve'))", PositionID);
            return obj.SelectDatatable(query);
        }
        public void SaveData()
        {
            SaveData sv = new SaveData();
            var vl = ValidationFunc.ValidateModelData<SelectionModel>(this, "CandidateList");
            if (vl.isValid == false)
            {
                alert(vl.Message, vl.isValid);
                return;
            }
            if (CandidateList == null || CandidateList == "")
            {
                alert("Alert! Select atleast on candidate for given position", false);
                return;
            }
            sv = Save();
            alert(sv.Message, sv.isSuccess);
            return;
        }
        public SaveData Save()
        {
            SaveData sv = new SaveData();
            SqlParameter[] perm1 = new SqlParameter[4];
            perm1[0] = new SqlParameter("@PositionID", PositionID);
            perm1[1] = new SqlParameter("@Candidate", CandidateList.HtmlEncode());
            perm1[2] = new SqlParameter("@CurrentStatus", "Selected");
            DataTable success1 = obj.ExecuteStoreProcedure("proc_tblSuggestedApplicants", perm1);
            if (success1 != null)
            {
                sv.isSuccess = true;
                sv.Message = "<b>Success :</b> Candidate List selected successfully.";
            }
            else
            {
                sv.isSuccess = false;
                sv.Message = "<b>Error :</b> Please try again later.";
            }
            return sv;
        }

        public void MoveToSelect(int CandID)
        {
            SqlParameter[] perm1 = new SqlParameter[2];
            perm1[0] = new SqlParameter("@PositionID", PositionID);
            perm1[1] = new SqlParameter("@CandidateID", CandID);
            DataTable success1 = obj.ExecuteStoreProcedure("Proc_tblSuggestedApplicants_Select", perm1);
            if (success1!=null)
            {
                alert("<b>Success :</b> Candidate List Updated successfully.", true);
            }
            else
            {
                alert("<b>Error :</b> Try again later", true);
            }
        }
        //public List<SelectListItem> CanidateList()
        //{
        //    string Query = "Select CandidateID, Name+'('+EmailID+')' as 'candidate' from tblMasterCandidatePool where Iscandidate=0";
        //    return Common.FillSelectList(Query, "candidate", "CandidateID");
        //}
    }
}