﻿using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using CommonFunc;

namespace EnvigoHiring.Models.Applicants
{
    public class InterviewInputs:BaseClass
    {
        public string ApplicantdID { get; set; }
        public string ddlInterViewStatus { get; set; }
        public string ddlResultStatus { get; set; }
        public string ddlComunication { get; set; }
        public string ddlJobknowledge { get; set; }
        public string ddlpastExperience { get; set; }
        public string ddlCompanyFitness { get; set; }
        public string ddlAttitude { get; set; }
        public string RoundID { get; set; }
        public double Rating { get; set; }
        public DataTable dtApplicant { get; set; }
        public DataTable dtInterViewRounds { get; set; }
        public DataTable dtInterviewRating { get; set; }
        DataLayer obj = DataLayer.Instance;
        public void DisplayApplicantsStatus()
        {
            FilePath = ConfigurationManager.AppSettings["ResumePath"].ToString().Trim();
            string Query = string.Format(@"select distinct Name,DesignationName,UnitName,apl.CandidateID,CandidateStatus,PositionID,EmailID,Phone,ResumeName,ResumeGoogleLink,Education,Experience,
            Stage,ms.StatusName,sheduledOn,(select StatusName from tblMasterHiringStatus where HiringID=apl.stage) as CStage
            from vwtblApplicants apl inner join tblInterviewRounds t on(apl.ApplicantID=t.ApplicantID) left outer join  tblApplicantRating t1 on(t.RoundID=t1.RoundID)
            inner join tblMasterInterviewStatus ms on (t.InterviewStatus=ms.InterviewStatusID) where apl.ApplicantID={0} order by sheduledOn desc", ApplicantdID);
            dtApplicant = obj.SelectDatatable(Query);
            if (dtApplicant != null && dtApplicant.Rows.Count > 0)
            {
                DisplayInterViewRounds();
            }
            else
            {
                HttpContext.Current.Response.Redirect("/applicants");
            }
        }
        public void SaveData()
        {
            SqlParameter[] perm1 = new SqlParameter[16];
            perm1[0] = new SqlParameter("@RoundID", RoundID.ToInt32());
            perm1[1] = new SqlParameter("@ApplicantID", ApplicantdID.ToInt32());
            perm1[2] = new SqlParameter("@InterViewStatus", ddlInterViewStatus.ToInt32());
            perm1[3] = new SqlParameter("@InterviewResult", ddlResultStatus.ToInt32());
            perm1[4] = new SqlParameter("@rating", Rating);
            perm1[5] = new SqlParameter("@CommunicationID", 1);
            perm1[6] = new SqlParameter("@Communication", ddlComunication.ToInt32());
            perm1[7] = new SqlParameter("@JobKnowledgeID", 2);
            perm1[8] = new SqlParameter("@JobKnowledge", ddlJobknowledge.ToInt32());
            perm1[9] = new SqlParameter("@PastExperienceID", 3);
            perm1[10] = new SqlParameter("@PastExperience", ddlpastExperience.ToInt32());
            perm1[11] = new SqlParameter("@CompanyFitnessID", 4);
            perm1[12] = new SqlParameter("@CompanyFitness", ddlpastExperience.ToInt32());
            perm1[13] = new SqlParameter("@AttitudeID", 5);
            perm1[14] = new SqlParameter("@Attitude", ddlAttitude.ToInt32());
            perm1[15] = new SqlParameter("@UserID", UserID.ToInt32());
            DataTable success1 = obj.ExecuteStoreProcedure("proc_tblApplicantRating", perm1);
            if (success1 != null)
            {
                alert("<b>Success :</b> Interview Status updated successfully.", true);
            }
            else
            {
                alert("<b>Error :</b> Please try again later.", false);
            }
        }
        public void DisplayInterViewRounds()
        {
            string query = string.Format(@"select r.*,rat.RatingID,rat.Rating as SubRating,res.Result,mr.RatingName,ms.StatusName,(select username from tblUserLogin where UserID=r.Interviewer and Status=1 and role is not null) as InterviewerName 
                     from tblInterviewRounds r left outer join tblApplicantRating rat on (r.RoundID=rat.RoundID) left outer join tblMasterRating mr on (rat.RatingID=mr.ratingID) 
					 left outer join tblMasterInterviewResult res on(r.InterViewresult=res.StatusID)
                     inner join tblMasterInterviewStatus ms on (r.InterviewStatus=ms.InterviewStatusID)  where r.ApplicantID={0} order by sheduledOn desc", ApplicantdID);
             dtInterViewRounds = obj.SelectDatatable(query);
        }

        public void Interviewrating(int RoundID)
        {
            string query = string.Format(@"select rat.*,m.RatingName from tblApplicantRating rat inner join tblMasterRating m on (rat.RatingID=m.RatingID) where RoundID={0} order by rat.ratingid asc", RoundID);
            dtInterviewRating = obj.SelectDatatable(query);
        }

        public List<SelectListItem> InterViewStatusList()
        {
            string query = "select InterviewStatusID,StatusName from tblMasterInterviewStatus";
            return Common.FillSelectList(query, "StatusName", "InterviewStatusID");
        }
        public List<SelectListItem> ResultStatusList()
        {
            string query = "select StatusID,Result from tblMasterInterviewResult order by result ";
            return Common.FillSelectList(query, "Result", "StatusID");
        }
        public List<SelectListItem> RatingList()
        {
            return Common.FillSelectListManual("1", "2", "3", "4", "5");
        }
    }
}