tinymce.PluginManager.add("link", function (e) {
   var editor = e;
    function openmanager() {
        var win, data, dom = editor.dom,
            imgElm = editor.selection.getNode();
        var width, height, imageListCtrl, callconnecter;

        callconnecter = editor.settings.connector;

        win = editor.windowManager.open({
            title: 'File Manager',
            data: data,
            classes: 'filemanager',
            file: callconnecter + '?id=' + editor.id + '&plugin=link',
            filetype: 'link',
            width: 900,
            height: 600,
            inline: 1
        })
    }

    function showDialog() {
        var win, data, dom = editor.dom, imgElm = editor.selection.getNode();
        var width, height, imagListCtrl;

        function buildImageList() {
            var linkImageItems = [{
                text: 'None',
                value: ''
            }];

            tinymce.each(editor.settings.image_list, function (link) {
                linkImageItems.push({
                    text: link.text || link.title,
                    value: link.value || link.url,
                    menu: link.menu
                })

            });

            return linkImageItems
        }

        //function recalcSize(e) {
        //    var widthCtrl, heightCtrl, newWidth, newHeight;
        //    newWidth = widthCtrl.value();
        //    newHeight = heightCtrl.value();
        //    if (win.find('#constrain')[0].checked() && width && height && newWidth && newHeight) {
        //        if (e.control == widthCtrl) {
        //            newHeight = Math.round((newWidth / width) * newHeight);
        //            heightCtrl.value(newHeight)
        //        } else {
        //            newWidth = Math.round((newHeight / height) * newWidth);
        //            widthCtrl.value(newWidth)
        //        }
        //    }
        //    width = newWidth;
        //    height = newHeight
        //}

        //width = dom.getAttrib(imgElm, 'width');
        //height = dom.getAttrib(imgElm, 'height');

        if (imgElm.nodeName == "LINK" && !imgElm.getAttribute('data-mce-object')) {
            data = {
                href: dom.getAttrib(imgElm, 'href'),
                alt: dom.getAttrib(imgElm, 'alt')
            }
        } else {
            imgElm = null
        } if (editor.settings.image_list) {
            imageListCtrl = {
                name: 'target',
                type: 'listbox',
                label: 'Image list',
                values: buildImageList(),
                onselect: function (e) {
                    var altCtrl = win.find('#alt');
                    if (!altCtrl.value() || (e.lastControl && altCtrl.value() == e.lastControl.text())) {
                        altCtrl.value(e.control.text())
                    }
                    win.find('#href').value(e.control.value())
                }
            }
        }

        win = editor.windowManager.open({
            title: "Edit File",
            data: data,
            body: [{
                type: 'container',
                layout: 'flex',
                classes: 'combobox has-open',
                label: 'Source',
                direction: 'row',
                align: 2,
                items: [{
                    name: 'href',
                    type: 'textbox',
                    filetype: 'link',
                    size: 35,
                    classes: 'img_' + editor.id,
                    autofocus: true
                }, {
                    name: 'upl_img',
                    type: 'button',
                    classes: 'btn open',
                    icon: 'browse',
                    onclick: openmanager,
                    tooltip: 'Upload image'
                }
                ]
            }, {
                name: 'alt',
                type: 'textbox',
                label: 'Image description'
            }, {
                type: 'container',
                label: 'Dimensions',
                layout: 'flex',
                direction: 'row',
                align: 'center',
                spacing: 5,
                items: [{
                    name: 'width',
                    type: 'textbox',
                    maxLength: 3,
                    size: 3,
                    onchange: recalcSize
                }, {
                    type: 'label',
                    text: 'x'
                }, {
                    name: 'height',
                    type: 'textbox',
                    maxLength: 3,
                    size: 3,
                    onchange: recalcSize
                }, {
                    name: 'constrain',
                    type: 'checkbox',
                    checked: true,
                    text: 'Constrain proportions'
                }
                ]
            }
            ],
            onSubmit: function (e) {
                var data = e.data;
                if (data.width === '') {
                    delete data.width
                }
                if (data.height === '') {
                    delete data.height
                }
                if (imgElm) {
                    dom.setAttribs(imgElm, data)
                } else {
                    editor.insertContent(dom.createHTML('link', data))
                }
            }
        })

    }


    //////////////
    function t() {
        function t() {
            var t = [{
                text: "None",
                value: ""
            }];
            return tinymce.each(e.settings.link_list, function (e) {
                t.push({
                    text: e.text || e.title,
                    value: e.value || e.url,
                    menu: e.menu
                })
            }), t
        }
        
        function n(t) {
            var n = [{
                text: "None",
                value: ""
            }];
            return tinymce.each(e.settings.rel_list, function (e) {
                n.push({
                    text: e.text || e.title,
                    value: e.value,
                    selected: t === e.value
                })
            }), n
        }

        function r(t) {
            var n = [{
                text: "None",
                value: ""
            }];
            return e.settings.target_list || n.push({
                text: "New window",
                value: "_blank"
            }), tinymce.each(e.settings.target_list, function (e) {
                n.push({
                    text: e.text || e.title,
                    value: e.value,
                    selected: t === e.value
                })
            }), n
        }

        function i() {
            s || 0 !== f.text.length || this.parent().parent().find("#text")[0].value(this.value())
        }
        var o, a, s, l, c, u, d, f = {},
            p = e.selection,
            h = e.dom;
        o = p.getNode(), a = h.getParent(o, "a[href]"), a && p.select(a), f.text = s = p.getContent({
            format: "text"
        }), f.href = a ? h.getAttrib(a, "href") : "", f.target = a ? h.getAttrib(a, "target") : "", f.rel = a ? h.getAttrib(a, "rel") : "", "IMG" == o.nodeName && (f.text = s = " "), e.settings.link_list && (c = {
            type: "listbox",
            label: "Link list",
            values: t(),
            onselect: function (e) {
                var t = l.find("#text");
                (!t.value() || e.lastControl && t.value() == e.lastControl.text()) && t.value(e.control.text()), l.find("#href").value(e.control.value())
            }
        }), e.settings.target_list !== !1 && (d = {
            name: "target",
            type: "listbox",
            label: "Target",
            values: r(f.target)
        }), e.settings.rel_list && (u = {
            name: "rel",
            type: "listbox",
            label: "Rel",
            values: n(f.rel)
        }), l = e.windowManager.open({
            title: "Insert link",
            data: f,
            body: [{
                type: 'container',
                layout: 'flex',
                classes: 'combobox has-open',
                label: 'Source',
                direction: 'row',
                align: 2,
                items: [{
                    name: 'href',
                    type: 'textbox',
                    filetype: 'file',
                    size: 35,
                    classes: 'img_' + editor.id,
                    autofocus: true
                }, {
                    name: 'upl_doc',
                    type: 'button',
                    classes: 'btn open',
                    icon: 'browse',
                    onclick: openmanager,
                    tooltip: 'Upload Document'
                }
                ]
            }, {
                name: "text",
                type: "textbox",
                size: 40,
                label: "Text to display",
                onchange: function () {
                    f.text = this.value()
                }
            }, c, u, d],
            onSubmit: function (t) {
                var n = t.data;
                return n.href ? (n.text != s ? a ? (e.focus(), a.innerHTML = n.text, h.setAttribs(a, {
                    href: n.href,
                    target: n.target ? n.target : null,
                    rel: n.rel ? n.rel : null
                }), p.select(a)) : e.insertContent(h.createHTML("a", {
                    href: n.href,
                    target: n.target ? n.target : null,
                    rel: n.rel ? n.rel : null
                }, n.text)) : e.execCommand("mceInsertLink", !1, {
                    href: n.href,
                    target: n.target,
                    rel: n.rel ? n.rel : null
                }), void 0) : (e.execCommand("unlink"), void 0)
            }
        })
    }
    e.addButton("link", {
        icon: "link",
        tooltip: "Insert/edit link",
        shortcut: "Ctrl+K",
        onclick: t,
        stateSelector: "a[href]"
    }), e.addButton("unlink", {
        icon: "unlink",
        tooltip: "Remove link(s)",
        cmd: "unlink",
        stateSelector: "a[href]"
    }), e.addShortcut("Ctrl+K", "", t), this.showDialog = t, e.addMenuItem("link", {
        icon: "link",
        text: "Insert link",
        shortcut: "Ctrl+K",
        onclick: t,
        stateSelector: "a[href]",
        context: "insert",
        prependToContext: !0
    })
});