﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text.RegularExpressions;
using System.Web;


public static class XSS
{
    public const string PotentialXssAttackExpression = "(http(s)*(%3a|:))|(ftp(s)*(%3a|:))|(javascript)|(alert)|(((\\%3C) <)[^\n]+((\\%3E) >))";

    private static readonly Regex PotentialXssAttackRegex = new Regex(PotentialXssAttackExpression, RegexOptions.IgnoreCase);
    /*Check URL for CrossSite scripting Attack*/
    public static bool IsXssAttack(string Url="")
    {
        if (Url == null || Url == "")
        {
            Url = HttpContext.Current.Request.Url.ToString().Trim();
        }
        string[] exp = new string[] { "<", ">", "alert", "script", "<embed", "<form", "iframe", "<object", "<layer" };
        bool result = true;
        bool result1 = true;
        if (Url != null && Url != "")
        {
            foreach (string c in exp)
            {
                result = Regex.IsMatch(Url, c);
                result1 = Regex.IsMatch(Url, HttpUtility.UrlEncode(c));
                if (result || result1)
                {
                    return true;
                }
            }
        }
        return false;
    }
    /*Check a page for CrossSite scripting Attack*/
    public static bool IsPotentialXssAttack()
    {
        HttpRequest request = HttpContext.Current.Request;
        if (request == null)
        {
            return false;
        }
        if (IsXssAttack())
        {
            return true;
        }
        if (isPotentialXssAttackQuery(request))
        {
            return true;
        }
        if (isPotentialXssAttackFormOrAnything(request))
        {
            return true;
        }
        if (isPotentialXssAttackCookie(request))
        {
            return true;
        }

        return false;
    }

    /*Check QueryString of URL for CrossSite scripting Attack*/
    public static bool isPotentialXssAttackQuery(this HttpRequest request)
    {
        string query = request.QueryString.ToString();
        if (isMatch(query))
        {
            return true;
        }
        return false;
    }

    public static bool isMatch(string input)
    {
        if (string.IsNullOrEmpty(input))
        {
            return false;
        }
        return PotentialXssAttackRegex.IsMatch(input);
    }

    /*Check Form of any Page for CrossSite scripting Attack*/
    public static bool isPotentialXssAttackFormOrAnything(this HttpRequest request)
    {
        if (!request.HttpMethod.Equals("post",
                StringComparison.InvariantCultureIgnoreCase))
        {
            return false;
        }

        string form = request.Form.ToString();
        if (isMatch(form))
        {
            return true;
        }
        return false;
    }
    /*Check Cookie of page for CrossSite scripting Attack*/
    public static bool isPotentialXssAttackCookie(this HttpRequest request)
    {
        if (request.Cookies.Count <= 0)
        {
            return false;
        }
        //HttpCookie cokies = request.Cookies;
        foreach (string cookie in request.Cookies)
        {
            if (request.Cookies[cookie].Value != null)
            {
                if (isMatch(request.Cookies[cookie].Value.ToString()))
                {
                    return true;
                }
            }
        }
        return false;
    }
}
