﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using EnvigoHiring.Models.Designation;

namespace EnvigoHiring.Controllers
{
    [CustomAuthorize(Roles = "Admin")]
    public class designationController : Controller
    {
        // GET: designation
        public ActionResult Index()
        {
            Designation ds = new Designation();
            ds.ListData = ds.getdata();
            return View(ds);
        }

        public ActionResult add()
        {
            Designation ds = new Designation();
            ds.Department = ds.GetDepartment();
            //ds.MessageType = "danger";
            //ds.lblMessage = "test<br/>test";
            return View(ds);
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult add(Designation ds)
        {
            if (ModelState.IsValid)
            {
                if (!CommonFunctions.CheckSpecialCharTextBoxString(ds.DesignationName) || ds.DesignationName == "")
                {
                    ds.MessageType = "danger";
                    ds.lblMessage = "Special Char not allowed !";
                    ds.Department = ds.GetDepartment();
                    return View(ds);
                }

                if (ds.CheckDesignation(0))
                {
                    ds.MessageType = "danger";
                    ds.lblMessage = "Designation with same name already exist !";
                    ds.Department = ds.GetDepartment();
                    return View(ds);
                }
                int i = ds.add();
                if (i > 0)
                {
                    ds.MessageType = "success";
                    ds.lblMessage = "Designation added successfuly.";
                    ds.Department = ds.GetDepartment();
                    return View(ds);
                }
                else
                {
                    ds.MessageType = "danger";
                    ds.lblMessage = "There are some issue, Please try after some time!";
                    ds.Department = ds.GetDepartment();
                    return View(ds);
                }
            }
            else
            {
                ds.MessageType = "danger";
                ds.lblMessage = "There are some issue, Please try after some time!";
                ds.Department = ds.GetDepartment();
                return View(ds);
            }

        }

        public ActionResult edit(int id)
        {
            Designation ds = new Designation();
            ds.DesignationID = id;
            ds.Department = ds.GetDepartment();
            ds.ListData = ds.EditData();
            if (ds.ListData != null && ds.ListData.Rows.Count > 0) {
                ds.DesignationName = HttpUtility.HtmlDecode(ds.ListData.Rows[0]["DesignationName"].ToString().Trim());
                ds.DepartmentID = HttpUtility.HtmlDecode(ds.ListData.Rows[0]["DepartmentID"].ToString().Trim());
            } else {
                Response.Redirect("index");
            }
            return View(ds);
        }
        [HttpPost]
        [ValidateAntiForgeryToken]
        public ActionResult edit(int id, Designation ds)
        {
            if (ModelState.IsValid)
            {
                ds.DesignationID = id;
                if (!CommonFunctions.CheckSpecialCharTextBoxString(ds.DesignationName) || ds.DesignationName == "")
                {
                    ds.MessageType = "danger";
                    ds.lblMessage = "Special Char not allowed !";
                    ds.Department = ds.GetDepartment();
                    return View(ds);
                }
                if (ds.CheckDesignation(ds.DesignationID))
                {
                    ds.MessageType = "danger";
                    ds.lblMessage = "Designation with same name already exist !";
                    ds.Department = ds.GetDepartment();
                    return View(ds);
                }
                int x = ds.edit();
                if (x > 0)
                {
                    ds.MessageType = "success";
                    ds.lblMessage = "Designation updated successfuly.";
                    ds.Department = ds.GetDepartment();
                    return View(ds);
                }
                else
                {
                    ds.MessageType = "danger";
                    ds.lblMessage = "There are some issue, Please try after some time!";
                    ds.Department = ds.GetDepartment();
                    return View(ds);
                }

            }
            else
            {
                ds.MessageType = "danger";
                ds.lblMessage = "There are some issue, Please try after some time!";
                ds.Department = ds.GetDepartment();
                return View(ds);
            }
        }
    }
}