﻿using EnvigoHiring.Models.CandidateSelection;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using CommonFunc;

namespace EnvigoHiring.Controllers
{
    
    public class candidateselectionController : Controller
    {
        // GET: candidateselection
        [CustomAuthorize(Roles = "Admin, Recruiter")]
        public ActionResult select(int id)
        {
            SelectionModel sm = new SelectionModel();
            if (id > 0)
            {
                sm.PositionID = id;
            }
            else
            {
                return Redirect("/position/viewposition");
            }
            sm.FillData();
            return View(sm);
        }
        [CustomAuthorize(Roles = "Admin, Recruiter")]
        [HttpPost]
        public ActionResult select(SelectionModel sm,int id,string btnSubmit, string btnReject)
        {
            if (ModelState.IsValid)
            {
                if (id > 0)
                {
                    sm.PositionID = id;
                }
                else
                {
                    return Redirect("/position/viewposition");
                }
                if (btnSubmit == "Submit")
                {
                    sm.SaveData();
                    //if error on saving data
                    if (sm.MessageType == "danger")
                    {
                        sm.FillData();
                        return View(sm);
                    }
                }
                if (btnReject != null && btnReject.Length > 0 && btnReject.Split('_')[0] == "Reject")
                {
                    var rejArray = btnReject.Split('_');

                    int CandID = (rejArray.Length > 1) ? rejArray[1].ToString().ToInt32() : 0;
                    if (CandID == 0)
                    {
                        sm.alert("Alert! Please try again", false);
                    }
                    sm.MoveToSelect(CandID);
                }
            }
            sm.FillData();
            return View(sm);
        }
        [CustomAuthorize(Roles = "Admin, User")]
        public ActionResult approve(int id)
        {
            ApprovalModel am = new ApprovalModel();
            if (id > 0)
            {
                am.PositionID = id;
            }
            else
            {
                return Redirect("/position/viewposition");
            }
            am.FillData();
            return View(am);
        }
        [CustomAuthorize(Roles = "Admin, User")]
        [HttpPost]
        public ActionResult approve(ApprovalModel am, int id, string btnApprove,string btnReject)
        {
            if (ModelState.IsValid)
            {
                if (id > 0)
                {
                    am.PositionID = id;
                }
                else
                {
                    return Redirect("/position/viewposition");
                }
                
                if (btnApprove!=null && btnApprove.Length>0 && btnApprove.Split('_')[0] == "Approve")
                {
                    var aprvArray = btnApprove.Split('_');
                    int CandID = (aprvArray.Length > 1) ? aprvArray[1].ToString().ToInt32() : 0;
                    if (CandID == 0)
                    {
                        am.alert("Alert! Please try again",false);
                    }
                    am.ApproveCand(CandID);
                    //if error on saving data
                    if (am.MessageType == "danger")
                    {
                        return View(am);
                    }
                }
                if (btnReject!=null && btnReject.Length>0 && btnReject.Split('_')[0] == "Reject")
                {
                    var rejArray = btnReject.Split('_');

                    int CandID = (rejArray.Length > 1) ? rejArray[1].ToString().ToInt32() : 0;
                    if (CandID == 0)
                    {
                        am.alert("Alert! Please try again", false);
                    }
                    am.RejectCand(CandID);
                }
            }
            am.FillData();
            return View(am);
        }

    }
}