﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using CommonFunc;
using System.Web.Mvc;
using System.Data.SqlClient;

namespace EnvigoHiring.Models.Applicants
{
    public class ApplicantsComment: BaseClass
    {
        public string  ApplicantName { get; set; }
        public string  Designation { get; set; }
        public string  Unit { get; set; }
        [AllowHtml]
        public string  Comments { get; set; }
        public int ApplicantID { get; set; }
        public int PositionID { get; set; }
        public int CommentID { get; set; }
        public DataTable dtComments { get; set; }

        DataLayer obj = DataLayer.Instance;
        public bool FillData()
        {
            bool result = false;
            string subQuery = (CommentID > 0) ? " and CommentID=" + CommentID : "";
            string Query = string.Format("Select Name,DesignationName,va.PositionID,UnitName,Comments from vwtblApplicants va left outer join tblApplicantComments ac on (va.ApplicantID=ac.ApplicantdID) where ApplicantID={0} {1}", ApplicantID,subQuery);
            DataTable dt = obj.SelectDatatable(Query);
            if (dt != null && dt.Rows.Count > 0)
            {
                result = true;
                DataRow row = dt.Rows[0];
                ApplicantName = row.SetParamValue("Name");
                Designation = row.SetParamValue("DesignationName");
                Unit = row.SetParamValue("UnitName");
                PositionID = row.SetParamValue("PositionID").ToInt32();
                if (CommentID > 0)
                {
                    Comments = row.SetParamValue("Comments");
                }
                dtComments = ViewComments();
            }
            return result;
        }

        public void SaveData()
        {
            if (Comments == null || Comments == "")
            {
                alert("Alert! Comments should not be blank", false);
                return;
            }
            if (!SpecialCharacterFunc.TextAreaString(Comments))
            {
                alert("Alert! Comments special character not allowed", false);
                return;
            }
            SqlParameter[] perm1 = new SqlParameter[5];
            perm1[0] = new SqlParameter("@CommentID", CommentID);
            perm1[1] = new SqlParameter("@ApplicantdID", ApplicantID);
            perm1[2] = new SqlParameter("@PositionID", PositionID);
            perm1[3] = new SqlParameter("@CommentedBy", UserID);
            perm1[4] = new SqlParameter("@Comments", Comments.HtmlEncode());
            DataTable success1 = obj.ExecuteStoreProcedure("proc_tblApplicantComments", perm1);
            if (success1 != null)
            {
                if (CommentID == 0)
                {
                    alert("<b>Success :</b> Comments added successfully.", true);
                }
                else
                {
                    alert("<b>Success :</b> Comments updated successfully.", true);
                }
            }
            else
            {
                alert("<b>Error :</b> Please try again later.", false);
            }
        }

        public DataTable ViewComments()
        {
            string Query = string.Format("Select Name,DesignationName,va.PositionID,UnitName,Comments,CommentID from vwtblApplicants va inner join tblApplicantComments ac on (va.ApplicantID=ac.ApplicantdID) where ApplicantID={0}", ApplicantID);
            return obj.SelectDatatable(Query);
        }
    }
}