﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using System.Web.Mvc;
using CommonFunc;
using System.Data.SqlClient;
using System.ComponentModel.DataAnnotations;
using System.Configuration;

namespace EnvigoHiring.Models.User
{
    public class UserModel : BaseClass
    {
        public int ID { get; set; }
        public int UserType { get; set; }
        public string PageHeading { get; set; }
        public string UserName { get; set; }
        public string Email { get; set; }
        public string EmailID { get; set; }
        public bool chkActive { get; set; }
        public int Status { get; set; }
        [Required(ErrorMessage = "Alert! Select Roles")]
        public string ddlRoles { get; set; }
        public string backUrl { get; set; }
        public DataTable dtUser { get; set; }
        DataLayer obj = DataLayer.Instance;
        public DataTable ViewUser()
        {
            string query = "Select t.*,t1.RoleName from tblUserLogin t left outer join tblMasterRole t1 on (t.role=t1.RoleID) where status!=0 and (Role is not null and Role!=0)";
            if (UserType == 0)
            {
                query = "Select t.*,t1.RoleName from tblUserLogin t left outer join tblMasterRole t1 on (t.role=t1.RoleID) where status=0 or Role=0 or role is null";
            }
            return obj.SelectDatatable(query);
        }
        public bool FillData()
        {
            bool result = false;
            string query = "Select UserName,UserEmail,Status,Role from tblUserLogin where UserID=" + ID;
            DataTable dt = obj.SelectDatatable(query);
            if (dt != null && dt.Rows.Count > 0)
            {
                result = true;
                DataRow row = dt.Rows[0];
                Email = row.SetParamValue("UserEmail");
                EmailID= row.SetParamValue("UserEmail");
                UserName = row.SetParamValue("UserName");
                ddlRoles = row.SetParamValue("Role");
                chkActive = (row.SetParamValue("status") == "1") ? true : false;

            }
            return result;
        }
        public string RedirectUrl()
        {
            var url = HttpContext.Current.Request.UrlReferrer;
            return (url != null && url.ToString() != "") ? url.ToString() : "/user/pendingusers";
        }
        public void SaveData()
        {
            SaveData sv = new SaveData();
            Status = (chkActive == true) ? 1 : 0;
            SqlParameter[] perm1 = new SqlParameter[3];
            perm1[0] = new SqlParameter("@UserId", ID);
            perm1[1] = new SqlParameter("@Role", ddlRoles);
            perm1[2] = new SqlParameter("@Status", Status);
            DataTable success1 = obj.ExecuteStoreProcedure("proc_tblUserLogin_Approve", perm1);
            if (success1 != null)
            {
                sv.isSuccess = true;
                sv.Message = "<b>Success :</b> User activated successfully.";

            }
            else
            {
                sv.isSuccess = false;
                sv.Message = "<b>Error :</b> Please try again later.";
            }
            alert(sv.Message, sv.isSuccess);
            if (Status == 1)
            {
                string FileName = AppDomain.CurrentDomain.BaseDirectory + "content\\mailer.html";
                System.IO.StreamReader ObjStrmRdr;
                ObjStrmRdr = System.IO.File.OpenText(FileName);
                string StrMail = ObjStrmRdr.ReadToEnd();
                StrMail = StrMail.Replace("$$Heading$$", "Account Activated!");
                StrMail = StrMail.Replace("$$Content$$", "Your account in <b>Envigo Hiring</b> application has been approved by the admin. <a href='"+ConfigurationManager.AppSettings["SiteUrl"]+"' target=_blank>Click here</a> to login again.");
                ObjStrmRdr.Close();
                CommonFunctions.Email_Send("Signin Request Approval - Envigo Hiring", EmailID, StrMail);
            }
        }

        public List<SelectListItem> RolesList()
        {
            string query = "Select RoleID, RoleName from tblMasterRole";
            return Common.FillSelectList(query, "RoleName", "RoleID");
        }
    }
}