﻿using CommonFunc;
using System;
using System.Collections.Generic;
using System.Configuration;
using System.Data;
using System.Data.SqlClient;
using System.Linq;
using System.Web;

namespace EnvigoHiring.Models.CandidateSelection
{
    public class ApprovalModel1:BaseClass
    {
        public int PositionID { get; set; }
        public string Department { get; set; }
        public string Designation { get; set; }
        public DataTable dtCandidate { get; set; }
        public DataTable dtSelectedCandidate { get; set; }
        public string CandidateList { get; set; }
        DataLayer obj = DataLayer.Instance;
        public void FillData()
        {
            string query = "Select t1.positionID,DepartmentName,DesignationName,candidate from tblSuggestedApplicants t right outer join vwPosition t1 on (t.PositionID=t1.PositionID) where t1.JDStatus>0 and t1.PositionID=" + PositionID;
            dtSelectedCandidate = obj.SelectDatatable(query);
            if (dtSelectedCandidate != null && dtSelectedCandidate.Rows.Count > 0)
            {
                DataRow row = dtSelectedCandidate.Rows[0];
                PositionID = row.SetParamValue("PositionID").ToInt32();
                Department = row.SetParamValue("DepartmentName");
                Designation = row.SetParamValue("DesignationName");
                FilePath = ConfigurationManager.AppSettings["ResumePath"].ToString().Trim();
                dtCandidate = viewcandidate();
            }
            else
            {
                HttpContext.Current.Response.Redirect("/position/viewposition");
            }
        }
        public bool CandidateSelected(string candidateID)
        {
            bool result = false;
            if (dtSelectedCandidate != null && dtSelectedCandidate.Rows.Count > 0)
            {
                foreach (DataRow row in dtSelectedCandidate.Rows)
                {
                    if (row.SetParamValue("candidate") == candidateID)
                    {
                        result = true;
                    }
                }
            }
            return result;
        }
        public DataTable viewcandidate()
        {
            string query = string.Format(@"select  CandidateID,CurrentStatus,Name,Experience,EmailID,CandidateStatus,Source,Gender,ResumeName,ResumeGoogleLink,LastContactedDate,Education,DepartmentName from tblMasterCandidatePool t inner join 
										tblSuggestedApplicants t1 on (t.CandidateID=t1.Candidate) inner join
                                        tblMasterDepartment t2 on(t.InterestedDepartmentID = t2.DepartmentID) 
										where positionid="+PositionID+ " ");
            return obj.SelectDatatable(query);
        }
        public void ApproveCand(int CandID)
        {
            SaveData sv = new SaveData();
            SqlParameter[] perm1 = new SqlParameter[3];
            perm1[0] = new SqlParameter("@PositionID", PositionID);
            perm1[1] = new SqlParameter("@CandidateID", CandID);
            perm1[2] = new SqlParameter("@CurrentStatus", "Approve");
            DataTable success1 = obj.ExecuteStoreProcedure("Proc_tblSuggestedApplicants_Approve", perm1);
            if (success1 != null)
            {
                sv.isSuccess = true;
                sv.Message = "<b>Success :</b> Candidate List Shared successfully.";
            }
            else
            {
                sv.isSuccess = false;
                sv.Message = "<b>Error :</b> Please try again later.";
            }
            alert(sv.Message, sv.isSuccess);
            
        }
        public void RejectCand(int CandID)
        {
            SaveData sv = new SaveData();
            SqlParameter[] perm1 = new SqlParameter[3];
            perm1[0] = new SqlParameter("@PositionID", PositionID);
            perm1[1] = new SqlParameter("@CandidateID", CandID);
            perm1[2] = new SqlParameter("@CurrentStatus", "Reject");
            DataTable success1 = obj.ExecuteStoreProcedure("Proc_tblSuggestedApplicants_reject", perm1);
            if (success1 != null)
            {
                sv.isSuccess = true;
                sv.Message = "<b>Success :</b> Candidate List rejected successfully.";
            }
            else
            {
                sv.isSuccess = false;
                sv.Message = "<b>Error :</b> Please try again later.";
            }
            alert(sv.Message, sv.isSuccess);
            
        }
        
    }
}