﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Linq;
using System.Web;
using CommonFunc;
using System.ComponentModel.DataAnnotations;
using System.Data.SqlClient;
using System.Web.Mvc;
using System.Configuration;

namespace EnvigoHiring.Models.Position
{
    public class JDModel : BaseClass
    {
        [AllowHtml]
        //[Required(ErrorMessage = "Alert! Job Description should not be blank")]
        public string JobDescription { get; set; }
        public string DepartmentName { get; set; }
        public string DesignationName { get; set; }
        public int JDStatus { get; set; }
        public int PositionID { get; set; }
        DataLayer obj = DataLayer.Instance;
        public void FillData()
        {
            string query = "Select JobDescription,DepartmentName,DesignationName,ApproveStatus from tblJobDescription t right outer join vwPosition t1 on (t.PositionID=t1.PositionID) where t1.PositionID=" + PositionID;
            DataTable dt = obj.SelectDatatable(query);
            if (dt != null && dt.Rows.Count > 0)
            {
                DataRow row = dt.Rows[0];
                JobDescription = row.SetParamValue("JobDescription");
                DepartmentName = row.SetParamValue("DepartmentName");
                DesignationName = row.SetParamValue("DesignationName");
                JDStatus= row.SetParamValue("ApproveStatus").ToInt32();
            }
            
        }
        public void reset()
        {
            JobDescription = "";
            DepartmentName = "";
            DesignationName = "";
        }
        public void SaveData()
        {
            SaveData sv = new SaveData();
            if (JobDescription == null || JobDescription == "")
            {
                alert("Alert! Job Description should not be blank", false);
                return;
            }
            if (!SpecialCharacterFunc.TextAreaString(JobDescription))
            {
                alert("Alert! Job Description special character not allowed", false);
                return;
            }
            //var vl = ValidationFunc.ValidateModelData<JDModel>(this, "JobDescription");
            //if (vl.isValid == false)
            //{
            //    alert(vl.Message, vl.isValid);
            //    return;
            //}
            sv = Save();
            alert(sv.Message, sv.isSuccess);
            return ;
        }
        public SaveData Save()
        {
            SaveData sv = new SaveData();
            string query = "Select ApproveStatus from tblJobDescription where positionID=" + PositionID;
            int jdstatus = obj.GetDatafromQuery(query)[0].ToInt32();
            jdstatus = (jdstatus > 1) ? jdstatus : 1;
            SqlParameter[] perm1 = new SqlParameter[5];
            perm1[0] = new SqlParameter("@PositionID", PositionID);
            perm1[1] = new SqlParameter("@JobDescription", JobDescription.HtmlEncode());
            perm1[2] = new SqlParameter("@UserID", UserID);
            perm1[3] = new SqlParameter("@nstatus", DbType.Int32);
            perm1[3].Direction = ParameterDirection.Output;
            perm1[4] = new SqlParameter("@ApproveStatus", jdstatus);
            DataTable success1 = obj.ExecuteStoreProcedure("proc_tblJobDescription", perm1);
            if (success1 != null)
            {
                int nstatus = perm1[3].Value.ToString().ToInt32();
                if (nstatus == 1)
                {
                    sv.isSuccess = true;
                    sv.Message = "<b>Success :</b> Job Description added successfully.";
                    string email = CommonFunctions.getadminemailid(4);
                    if (email.Length > 0)
                    {
                    string q = @"SELECT tblUserLogin.UserName,tblUserLogin.Useremail, tblMasterDesignation.DesignationName
                    FROM tblPositions INNER JOIN tblUserLogin ON tblPositions.RequesterID = tblUserLogin.UserID INNER JOIN
                     tblMasterDesignation ON tblPositions.DesignationID = tblMasterDesignation.DesignationID
                    WHERE(tblPositions.PositionID = " + PositionID + ")";
                        DataTable dt = obj.SelectDatatable(q);
                        email += "," + dt.Rows[0]["Useremail"].ToString().Trim();

                        string FileName = AppDomain.CurrentDomain.BaseDirectory + "content\\mailer.html";
                        System.IO.StreamReader ObjStrmRdr;
                        ObjStrmRdr = System.IO.File.OpenText(FileName);
                        string StrMail = ObjStrmRdr.ReadToEnd();
                        StrMail = StrMail.Replace("$$Heading$$", "JD uploaded for review!");
                        StrMail = StrMail.Replace("$$Content$$", "Dear Member,<br/><br/> " + dt.Rows[0]["DesignationName"] + " - JD has been added by " + Users.LoginDetail().UserName.ToString().Trim() + " in <b>Envigo Hiring</b> application. <a href='" + ConfigurationManager.AppSettings["SiteUrl"] + "' target=_blank>Click here</a> to review.");
                        ObjStrmRdr.Close();
                        CommonFunctions.Email_Send("JD for Position - "+ dt.Rows[0]["DesignationName"] + "", email, StrMail);
                    }

                }
                else if (nstatus == 2)
                {
                    sv.isSuccess = true;
                    sv.Message = "<b>Success :</b> Job Description updated successfully.";
                    string email = CommonFunctions.getadminemailid(4);
                    if (email.Length > 0)
                    {
                        string q = @"SELECT tblUserLogin.UserName,tblUserLogin.Useremail, tblMasterDesignation.DesignationName
                    FROM tblPositions INNER JOIN tblUserLogin ON tblPositions.RequesterID = tblUserLogin.UserID INNER JOIN
                     tblMasterDesignation ON tblPositions.DesignationID = tblMasterDesignation.DesignationID
                    WHERE(tblPositions.PositionID = " + PositionID + ")";
                        DataTable dt = obj.SelectDatatable(q);
                        email += "," + dt.Rows[0]["Useremail"].ToString().Trim();

                        string FileName = AppDomain.CurrentDomain.BaseDirectory + "content\\mailer.html";
                        System.IO.StreamReader ObjStrmRdr;
                        ObjStrmRdr = System.IO.File.OpenText(FileName);
                        string StrMail = ObjStrmRdr.ReadToEnd();
                        StrMail = StrMail.Replace("$$Heading$$", "JD uploaded for review!");
                        StrMail = StrMail.Replace("$$Content$$", "Dear Member,<br/><br/> " + dt.Rows[0]["DesignationName"] + " - JD has been updated by " + Users.LoginDetail().UserName.ToString().Trim() + " in <b>Envigo Hiring</b> application. <a href='" + ConfigurationManager.AppSettings["SiteUrl"] + "' target=_blank>Click here</a> to review.");
                        ObjStrmRdr.Close();
                        CommonFunctions.Email_Send("JD for Position - " + dt.Rows[0]["DesignationName"] + "", email, StrMail);
                    }
                }
            }
            else
            {
                sv.isSuccess = false;
                sv.Message = "<b>Error :</b> Please try again later.";
            }
            return sv;
        }
        public void Approve()
        {
            SaveData sv = new SaveData();
            SqlParameter[] perm1 = new SqlParameter[3];
            perm1[0] = new SqlParameter("@PositionID", PositionID);
            perm1[1] = new SqlParameter("@ApproveStatus", 2);
            perm1[2] = new SqlParameter("@UserID", UserID);
            DataTable success1 = obj.ExecuteStoreProcedure("proc_tblJobDescription_Approve", perm1);
            if (success1 != null)
            {
                string email = CommonFunctions.getadminemailid(4);
                if (email.Length > 0)
                {
                    string q = @"SELECT tblUserLogin.UserName,tblUserLogin.Useremail, tblMasterDesignation.DesignationName
                    FROM tblPositions INNER JOIN tblUserLogin ON tblPositions.RequesterID = tblUserLogin.UserID INNER JOIN
                     tblMasterDesignation ON tblPositions.DesignationID = tblMasterDesignation.DesignationID
                    WHERE(tblPositions.PositionID = " + PositionID + ")";
                    DataTable dt = obj.SelectDatatable(q);
                    email += "," + dt.Rows[0]["Useremail"].ToString().Trim();

                    string FileName = AppDomain.CurrentDomain.BaseDirectory + "content\\mailer.html";
                    System.IO.StreamReader ObjStrmRdr;
                    ObjStrmRdr = System.IO.File.OpenText(FileName);
                    string StrMail = ObjStrmRdr.ReadToEnd();
                    StrMail = StrMail.Replace("$$Heading$$", "JD uploaded for review!");
                    StrMail = StrMail.Replace("$$Content$$", "Dear Member,<br/><br/> " + dt.Rows[0]["DesignationName"] + " - JD has been approved by " + Users.LoginDetail().UserName.ToString().Trim() + " in <b>Envigo Hiring</b> application. <a href='" + ConfigurationManager.AppSettings["SiteUrl"] + "' target=_blank>Click here</a> to review.");
                    ObjStrmRdr.Close();
                    CommonFunctions.Email_Send("JD for Position - " + dt.Rows[0]["DesignationName"] + "", email, StrMail);
                }
                //sv.isSuccess = true;
                //sv.Message = "<b>Success :</b> Job Description approved successfully.";
                HttpContext.Current.Response.Redirect("/position/viewposition");
            }
            else
            {
                sv.isSuccess = false;
                sv.Message = "<b>Error :</b> Please try again later.";
            }
            alert(sv.Message, sv.isSuccess);
        }
        public void Reject()
        {
            SaveData sv = new SaveData();
            SqlParameter[] perm1 = new SqlParameter[3];
            perm1[0] = new SqlParameter("@PositionID", PositionID);
            perm1[1] = new SqlParameter("@ApproveStatus", 3);
            perm1[2] = new SqlParameter("@UserID", UserID);
            DataTable success1 = obj.ExecuteStoreProcedure("proc_tblJobDescription_Approve", perm1);
            if (success1 != null)
            {
                string email = CommonFunctions.getadminemailid(4);
                if (email.Length > 0)
                {
                    string q = @"SELECT tblUserLogin.UserName,tblUserLogin.Useremail, tblMasterDesignation.DesignationName
                    FROM tblPositions INNER JOIN tblUserLogin ON tblPositions.RequesterID = tblUserLogin.UserID INNER JOIN
                     tblMasterDesignation ON tblPositions.DesignationID = tblMasterDesignation.DesignationID
                    WHERE(tblPositions.PositionID = " + PositionID + ")";
                    DataTable dt = obj.SelectDatatable(q);
                    email += "," + dt.Rows[0]["Useremail"].ToString().Trim();

                    string FileName = AppDomain.CurrentDomain.BaseDirectory + "content\\mailer.html";
                    System.IO.StreamReader ObjStrmRdr;
                    ObjStrmRdr = System.IO.File.OpenText(FileName);
                    string StrMail = ObjStrmRdr.ReadToEnd();
                    StrMail = StrMail.Replace("$$Heading$$", "JD uploaded for review!");
                    StrMail = StrMail.Replace("$$Content$$", "Dear Member,<br/><br/> " + dt.Rows[0]["DesignationName"] + " - JD has been rejected by " + Users.LoginDetail().UserName.ToString().Trim() + " in <b>Envigo Hiring</b> application. <a href='" + ConfigurationManager.AppSettings["SiteUrl"] + "' target=_blank>Click here</a> to review.");
                    ObjStrmRdr.Close();
                    CommonFunctions.Email_Send("JD for Position - " + dt.Rows[0]["DesignationName"] + "", email, StrMail);
                }
                //sv.isSuccess = true;
                //sv.Message = "<b>Success :</b> Job Description rejected successfully.";
                HttpContext.Current.Response.Redirect("/position/viewposition");
            }
            else
            {
                sv.isSuccess = false;
                sv.Message = "<b>Error :</b> Please try again later.";
            }
            alert(sv.Message, sv.isSuccess);
        }
    }
}