@extends('layouts.frontend')

@section('content')
  
    <section class="container-fluid hero-space">
        @if(!empty($pageData->banner_image))
        <?php $detailBannerImage = asset('storage/'.$pageData->banner_image); ?>
            <picture>
                <source media="(max-width: 767px)" srcset="<?php echo $detailBannerImage; ?>">
                <img src="{{ $detailBannerImage }}" alt="Flowers" style="width:auto;">
            </picture>
        @else    
            <picture>
                <source media="(max-width: 767px)" srcset="">
                <img src="/headmast.png" alt="Flowers" style="width:auto;">
            </picture>
        @endif
    </section>
    <section class="container address-box">

        <section class="address-box_inner">
            <h2 class="title">{{ $locationDetailAPIdata['data']['name'] }}</h2>
            <span class="ratings">
                <?php for($i=1; $i<=5; $i++){ 
                    $rating = round($locationDetailAPIdata['data']['averageRating']);
                    if($rating >= $i){ 
                        echo'<i class="mdi mdi-star"></i>';
                    }else{
                        echo '<i class="mdi mdi-star-outline"></i>';
                    }
                    ?>
                <?php } ?>
                <span class="counts">{{ $locationDetailAPIdata['data']['averageRating'] }}</span>
            </span>
            <div class="share dropdown">
                <span class="share-btn" id="address-box_social" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="mdi mdi-share-variant icon-grey"></i></span>
                <div class="share-option dropdown-menu dropdown-menu-right" aria-labelledby="address-box_social">
                    <ul>
                        <li><a href="#"><i class="mdi mdi-facebook-box"></i> Facebook</a></li>
                        <li><a href="#"><i class="mdi mdi-twitter-box"></i> Twitter</a></li>
                        <li><a href="#"><i class="mdi mdi-whatsapp"></i> Whatsapp</a></li>

                    </ul>
                </div>
            </div>
            <div class="row">
                <div class="col-md-5">
                    <p>
                    {{ $locationDetailAPIdata['data']['fullAddress']['addressLines'][0] }}
                    @if(!empty($locationDetailAPIdata['data']['fullAddress']['addressLines'][1]))
                    <br>
                    {{ $locationDetailAPIdata['data']['fullAddress']['addressLines'][1] }}
                    @endif
                    @if(!empty($locationDetailAPIdata['data']['fullAddress']['addressLines'][2]))
                    <br>
                    {{ $locationDetailAPIdata['data']['fullAddress']['addressLines'][2] }}
                    @endif
                    </p>
                </div>
                <div class="col-md-3 ">
                    <p class="d-flex align-items-center"><i class="mdi mdi-phone icon-grey mr-3"></i>
                    {{ $locationDetailAPIdata['data']['phone'] }}</p>
                </div>
                <div class="col-md-4 ">
                    @if(!empty($locationDetailAPIdata['data']['regularHours']))
                    <p class="dropdown d-flex align-items-center" id="address-box_openinghours" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i class="mdi mdi-clock icon-grey mr-3"></i>Open Now<i class="mdi mdi-chevron-down icon-grey ml-2"></i></p>
                    <div class="openinghours dropdown-menu" aria-labelledby="address-box_openinghours">
                        <ul>
                            @foreach($locationDetailAPIdata['data']['regularHours'] as $regularHours)
                            <li>
                            <span>{{ $regularHours['openDay'] }}</span> 
                            {{ $regularHours['openTime'] }} am - {{ $regularHours['closeTime'] }} pm
                            </li>
                            @endforeach
                        </ul>
                    </div>
                    @endif
                </div>
            </div>
        </section>

    </section>
    <section class="container-fluid about">
        <div class="row">
            <div class="col-12">
                <div class="content">

                    <h2 class="title">About {{ $locationDetailAPIdata['data']['name'] }}</h2>
                    <div class="content_paragraph">
                        <p>{{ $locationDetailAPIdata['data']['description'] }}</p>
                    </div>
                
                </div>
            </div>
        </div>
    </section>
    
    @if($locationDetailAPIdata['data']['coordinates']['latitude'] != 0)
    <section class="container-fluid location_onmap ">
        <div class="row no-gutters">
            <div class="col-12">
            <iframe src="http://maps.google.com/maps?q={{ $locationDetailAPIdata['data']['name'] }}&coord={{ $locationDetailAPIdata['data']['coordinates']['latitude'] }},{{ $locationDetailAPIdata['data']['coordinates']['longitude'] }}&z=15&output=embed" width="100%" height="450" frameborder="0" style="border:0" allowfullscreen></iframe>        
            </div>
        </div>
    </section>
    @endif

    <?php if($homepage->show_feed == 1){ ?>            
    <section class="container promotion-wrapper">
        <div class="row">
            <div class="col-12">
                <section class="promotion-wrapper-items">
                    <?php foreach($feedDetail as $feed){ ?>
                
                    <div class="item">
                        <figure><a href="{{ $feed->link }}" target="_blank"><img src="{{ $feed->image_link }}"> </a></figure>
                        <p class="name">{{ $feed->title }}</p>
                        <p class="currency bold">{{ $feed->price }}</p>
                        <p class="publisher">{{ $feed->brand }}</p>
                        <p class="grey-txt">Sale Price: {{ $feed->sale_price }}</p>
                    </div>
                    <?php } ?>
                </section>
            </div>
        </div>
    </section>
                    <?php } ?>                    





    <section class="container location_reviews_outer">
        <div class="row ">
            <div class="col-md-8 col-12">
                <section class="location_reviews">
                    <input type="hidden" value="{{ $locatorID }}" id="locaterid">
                    <?php 
                    $reviewData = Apihelpers::review_api($locatorID);
                    $totalreviewcount = $reviewData['meta']['total'];
                    ?>
                    <h5 class="title">Reviews</h5>
                    <div class="row location_reviews-head">
                        <div class="col-sm-6 col-12 text-center">
                            <div class="average">
                            {{ $locationDetailAPIdata['data']['averageRating'] }}
                            </div>
                            <span class="ratings">
                                <?php for($i=1; $i<=5; $i++){ 
                                    $rating = round($locationDetailAPIdata['data']['averageRating']);
                                    if($rating >= $i){ 
                                        echo'<i class="mdi mdi-star"></i>';
                                    }else{
                                        echo '<i class="mdi mdi-star-outline"></i>';
                                    }
                                    ?>
                                <?php } ?>
                                <span class="counts">{{ $totalreviewcount }}</span>
                            </span>
                        </div>
                        <div class="col-sm-6 col-12 location_reviews-rb">
                            <div class="row">
                                <div class="col-2"><i class="mdi mdi-star"></i> 5</div>
                                <div class="col-8">
                                    <div class="progress">
                                        <div class="progress-bar cr5" role="progressbar" style="width: 85%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </div>
                                <div class="col-2">19</div>
                            </div>
                            <div class="row">
                                <div class="col-2"><i class="mdi mdi-star"></i> 4</div>
                                <div class="col-8">
                                    <div class="progress">
                                        <div class="progress-bar cr4" role="progressbar" style="width: 55%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </div>
                                <div class="col-2">9</div>
                            </div>
                            <div class="row">
                                <div class="col-2"><i class="mdi mdi-star"></i> 3</div>
                                <div class="col-8">
                                    <div class="progress">
                                        <div class="progress-bar cr3" role="progressbar" style="width: 45%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </div>
                                <div class="col-2">4</div>
                            </div>
                            <div class="row">
                                <div class="col-2"><i class="mdi mdi-star"></i> 2</div>
                                <div class="col-8">
                                    <div class="progress">
                                        <div class="progress-bar cr2" role="progressbar" style="width: 35%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </div>
                                <div class="col-2">7</div>
                            </div>
                            <div class="row">
                                <div class="col-2"><i class="mdi mdi-star"></i> 1</div>
                                <div class="col-8">
                                    <div class="progress">
                                        <div class="progress-bar cr1" role="progressbar" style="width: 15%" aria-valuenow="25" aria-valuemin="0" aria-valuemax="100"></div>
                                    </div>
                                </div>
                                <div class="col-2">4</div>
                            </div>

                        </div>
                    </div>
                    <div class="row">
                        <div class="col-6">
                            <div class="dropdown mb-3">
                                <div class="btn btn-secondary custom-dropdown" id="reviewbyfilter" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                                    Most Newest
                                </div>
                                <!--dropdown-toggle <div class="dropdown-menu" aria-labelledby="reviewbyfilter">
                                    <a class="dropdown-item" href="javascript:void(0);">Highest rating</a>
                                    <a class="dropdown-item" href="javascript:void(0);">Lowest rating</a>
                                </div>-->
                            </div>
                        </div>
                    </div>
                    <div class="row" id="reviewElement">
                    @include('frontend.searchs.review_element')
                    </div>

                </section>
            </div>
            <div class="col-md-4 col-12">
                <aside class="nearby_locations">
                    <h5 class="title">
                        Nearby Global Desi Store Locator's
                    </h5>
                    <div class="card">
                        <div class="card-body">
                            <h5 class="title">Global Desi - Women Clothing Store</h5>
                            <span class="ratings">
                                    <i class="mdi mdi-star"></i>
                                    <i class="mdi mdi-star"></i>
                                    <i class="mdi mdi-star"></i>
                                    <i class="mdi mdi-star"></i>
                                    <i class="mdi mdi-star-outline"></i>
                                    <span class="counts">(20)</span>
                            </span>
                            <p class="address">Vasant Kunj, Sector C, Mehruali Road New Delhi - 110070</p>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body">
                            <h5 class="title">Global Desi - Women Clothing Store</h5>
                            <span class="ratings">
                                        <i class="mdi mdi-star"></i>
                                        <i class="mdi mdi-star"></i>
                                        <i class="mdi mdi-star"></i>
                                        <i class="mdi mdi-star"></i>
                                        <i class="mdi mdi-star-outline"></i>
                                        <span class="counts">(20)</span>
                            </span>
                            <p class="address">Vasant Kunj, Sector C, Mehruali Road New Delhi - 110070</p>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body">
                            <h5 class="title">Global Desi - Women Clothing Store</h5>
                            <span class="ratings">
                                            <i class="mdi mdi-star"></i>
                                            <i class="mdi mdi-star"></i>
                                            <i class="mdi mdi-star"></i>
                                            <i class="mdi mdi-star"></i>
                                            <i class="mdi mdi-star-outline"></i>
                                            <span class="counts">(20)</span>
                            </span>
                            <p class="address">Vasant Kunj, Sector C, Mehruali Road New Delhi - 110070</p>
                        </div>
                    </div>
                    <div class="card">
                        <div class="card-body">
                            <h5 class="title">Global Desi - Women Clothing Store</h5>
                            <span class="ratings">
                                <i class="mdi mdi-star"></i>
                                <i class="mdi mdi-star"></i>
                                <i class="mdi mdi-star"></i>
                                <i class="mdi mdi-star"></i>
                                <i class="mdi mdi-star-outline"></i>
                                <span class="counts">(20)</span>
                            </span>
                            <p class="address">Vasant Kunj, Sector C, Mehruali Road New Delhi - 110070</p>
                        </div>
                    </div>

                </aside>
            </div>
        </div>

    </section>
    <script type="text/javascript">
        $("#reviewElement").on('click','.pagination li a',function () {
            var page = $(this).data('page');
            var locatorID = $('#locaterid').val();
            reviewPaginate(page,locatorID);
        });

        function reviewPaginate(page,locatorID){
            $.ajax({
                type: 'post',
                url: "{{route('reviewPaginate')}}",
                data: {"_token": "{{ csrf_token() }}",page:page,locatorID:locatorID},
                    success: function (datanew) {
                    $( "#reviewElement" ).html( datanew );
                    $( "#locatorID" ).val(locatorID);
                }
            });
        }
    </script>
    @endsection

    