@extends('adminlte::page')

@section('content')

<div class="container-fluid">
    <div class="">
        <div class="col-sm-6">
            <h2>Locator Page</h2>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Update Page</li>
            </ol>
        </div>
    </div>
</div><!-- /.container-fluid -->

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <!-- Horizontal Form -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"></h3>
                            <div class="alert alert-success alert-dismissible groputitle" style="display:none">
                        </div>
                        @if(Session::has('add_message'))
                        <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        {!! session('add_message') !!} 
                        </div>
                        @endif

                        <form class="form-horizontal" id="add-pageform" action="{{route('admin.pages.save')}}" method="POST" enctype="multipart/form-data">

                        {{ csrf_field() }}

                        <div class="col-md-12">
                            <!-- Custom Tabs -->
                            <div class="nav-tabs-custom">
                                <ul class="nav nav-tabs">
                                <li class="active"><a href="#tab_1" data-toggle="tab" aria-expanded="true">MAIN</a></li>
                                <li class=""><a href="#tab_2" data-toggle="tab" aria-expanded="false">SEO</a></li>
                                </ul>
                                <div class="tab-content">
                                <div class="tab-pane active" id="tab_1">
                                    <div class="form-group @if($errors->first('locater_id')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Locater ID<em>*</em></label>
                                    <div class="col-sm-10">
                                        <select name="locater_id" class="form-control">
                                            <option value="">Select</option>
                                            @foreach($locater_identity as $key => $option)
                                            <?php if(isset($data) && !empty($data)){ ?>
                                            <option 
                                                @if($data->locater_id == $option->id) {{'selected'}} @endif value="<?php echo $option->id; ?>"><?php echo $option->locater_identity; ?></option>
                                            <?php }else{ ?>
                                                <option 
                                                value="<?php echo $option->id; ?>"><?php echo $option->locater_identity; ?></option>
                                            <?php } ?>
                                            @endforeach
                                        </select>
                                    </div>
                                    </div>

                                    <div class="form-group @if($errors->first('title')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Title<em>*</em></label>
                                    <div class="col-sm-10">
                                        <input type="text" name="title" id="title" class="form-control" placeholder="Title" value="{{old('title',@$data->title)}}">
                                        <?php if(@$errors->first('title')) { ?> <span class="help-block">{{@$errors->first('title')}}</span> <?php } ?>
                                    </div>
                                    </div>
                                    <!--<div class="form-group @if($errors->first('slug')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Slug</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="slug" class="form-control" placeholder="Slug" value="{{old('slug',@$data->slug)}}">
                                        <?php if(@$errors->first('slug')) { ?> <span class="help-block">{{@$errors->first('slug')}}</span> <?php } ?>
                                    </div>
                                    </div>-->

                                    <!-- new code -->            
                                    <div class="form-group @if($errors->first('slug')) {{' has-error has-feedback'}} @endif ">
                                        <label for="inputError" class="col-sm-2 control-label">Slug</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="slug" class="form-control permalink" id="target_url" placeholder="Slug" value="{{old('slug',@$data->slug)}}" readonly = "true">    
                                            <a href="javascript:void(0)" class="btn btn-round btn-mini" type="button" id="edit_target_url"><?php echo __("Edit"); ?></a>
                                        </div>
                                    </div>

                                    <div class="form-group @if($errors->first('contents')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Contents<em>*</em></label>
                                    <div class="col-sm-10">
                                        <textarea class="form-control" id="contents" name="contents">
                                        <?php if(isset($data->contents) && !empty($data->contents)){ ?>
                                        {{$data->contents}}
                                        <?php } ?>
                                        </textarea>
                                    </div>
                                    </div>
                                    <div class="form-group @if($errors->first('status')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Status<em>*</em></label>
                                    <div class="col-sm-10">
                                        <?php $options = array('1'=>'Active','0'=>'In Active'); ?>
                                        <select name="status" class="form-control">
                                            <option value="">Select</option>
                                            @foreach($options as $key => $option)
                                            <?php if(isset($data->status) && !empty($data->status)){ ?>
                                                <option @if($key == $data->status) {{'selected'}} @endif value="<?php echo $key; ?>"><?php echo $option; ?></option>
                                            <?php }else{ ?>
                                                <option value="<?php echo $key; ?>"><?php echo $option; ?></option>
                                            <?php } ?>
                                            @endforeach
                                        </select>
                                    </div>
                                    </div>
                                    <div class="form-group @if($errors->first('banner_image')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Image</label>
                                    <div class="col-sm-10">
                                        <input type="file" name="banner_image" class="form-control" placeholder="Offer Image">
                                    </div>
                                    </div>
                                    <div class="form-group @if($errors->first('banner_content')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Image Content</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="banner_content" class="form-control" placeholder="Header Image Content" value="{{old('banner_content',@$data->banner_content)}}">
                                        <?php if(@$errors->first('banner_content')) { ?> <span class="help-block">{{@$errors->first('banner_content')}}</span> <?php } ?>
                                    </div>
                                    </div>
                                </div>
                                <!-- /.tab-pane -->
                                <div class="tab-pane" id="tab_2">
                                    <div class="form-group @if($errors->first('meta_title')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Meta Title</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="meta_title" class="form-control" placeholder="Meta Title" value="{{old('meta_title',@$data->meta_title)}}">
                                        <?php if(@$errors->first('meta_title')) { ?> <span class="help-block">{{@$errors->first('meta_title')}}</span> <?php } ?>
                                    </div>
                                    </div>
                                    <div class="form-group @if($errors->first('meta_keyword')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Meta Keyword</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="meta_keyword" class="form-control" placeholder="Meta Keyword" value="{{old('meta_keyword',@$data->meta_keyword)}}">
                                        <?php if(@$errors->first('meta_keyword')) { ?> <span class="help-block">{{@$errors->first('meta_keyword')}}</span> <?php } ?>
                                    </div>
                                    </div>
                                    <div class="form-group @if($errors->first('meta_description')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Meta Description</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="meta_description" class="form-control" placeholder="Meta Description" value="{{old('meta_description',@$data->meta_description)}}">
                                        <?php if(@$errors->first('meta_description')) { ?> <span class="help-block">{{@$errors->first('meta_description')}}</span> <?php } ?>
                                    </div>
                                    </div>
                                </div>
                                </div>
                                <!-- /.tab-content -->
                            </div>
                        <!-- nav-tabs-custom -->
                        </div>    


                        <!-- /.box-body -->
                        <div class="box-footer">
                            <input type="submit" value="Submit" class="btn btn-info">
                            <a href="{{route('admin.pages')}}" class="btn btn-default">Cancel</a>
                        </div>
                        <!-- /.box-footer -->
                        </form>
                        
                    </div>
                    
                </div>
                <!--/.col (right) -->
            </div>
        </div>
    </div>
        
                
            <style>
                .help-block{
                    color:red;
                }
                .error{
                    color:red;
                }
            </style>
<script src="{{ asset('/vendor/adminlte/dist/js/slug.js') }}"></script>
<script type="text/javascript">
    $( document ).ready(function() {
    
      $('#add-pageform').validate({
            ignore: ".ignore",
            rules: {
                locater_id: "required",
                title: "required",
                //contents: "required",
                status: "required",
                //banner_image: "required",
                banner_content: "required",
            },
            // Specify validation error messages
            messages: {
                locater_id: "Please select locator",
                title: "Please enter Name.",
                //contents: "Please enter Description.",
                status: "Please select Status.",
                //banner_image: "Please enter Banner Image url.",
                banner_content: "Please enter Meta Banner Content.",
            },
        });
    });
    
    $(function() {
        $("#title").slug({ slug:'permalink',hide: false });
        $('#edit_target_url').bind('click',function(){if ($('#target_url').attr('readonly') !== undefined) {
        $('#target_url').removeAttr( "readonly");
        } else {$('#target_url').attr('readonly','readonly')}
        });
        $('#target_url').bind('blur',function(){$(this).attr('readonly','readonly')});
        
    });
</script>
<script src="{{ asset('/vendor/unisharp/laravel-ckeditor/ckeditor.js') }}"></script>
<script>
    CKEDITOR.replace( 'contents' );
</script>

@endsection        