@extends('adminlte::page')

@section('content')

<div class="container-fluid">
    <div class="row mb-2">
        <div class="col-sm-6">
            <h1>Locater</h1>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Update Locater</li>
            </ol>
        </div>
    </div>
</div><!-- /.container-fluid -->

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <!-- Horizontal Form -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"></h3>
                            <div class="alert alert-success alert-dismissible groputitle" style="display:none">
                        </div>
                        @if(Session::has('add_message'))
                        <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        {!! session('add_message') !!} 
                        </div>
                        @endif

                        <form class="form-horizontal" id="add-locaterform" action="@if(@$data->id) {{route('admin-locatersedit',['id'=>@$data->id])}} @else  {{route('admin-addlocater')}} @endif" method="POST" enctype="multipart/form-data">

                        {{ csrf_field() }}
                        <div class="box-body">
                        <input type="hidden" name="id" value="{{old('id',@$data->id)}}">

                            <div class="form-group @if($errors->first('locater_id_url')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Locater ID<em>*</em></label>
                            <div class="col-sm-10">
                                <input type="text" name="locater_id_url" class="form-control" placeholder="Locater ID" value="{{old('locater_id_url',@$data->locater_id_url)}}">
                                <?php if(@$errors->first('locater_id_url')) { ?> <span class="help-block">{{@$errors->first('locater_id_url')}}</span> <?php } ?>
                            </div>
                            </div>

                            <div class="form-group @if($errors->first('locater_code')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Locater Code<em>*</em></label>
                            <div class="col-sm-10">
                                <input type="text" name="locater_code" class="form-control" placeholder="Locater Code" value="{{old('locater_code',@$data->locater_code)}}">
                                <?php if(@$errors->first('locater_code')) { ?> <span class="help-block">{{@$errors->first('locater_code')}}</span> <?php } ?>
                            </div>
                            </div>

                            <div class="form-group @if($errors->first('name')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Name<em>*</em></label>
                            <div class="col-sm-10">
                                <input type="text" name="name" class="form-control" placeholder="Name" value="{{old('name',@$data->name)}}">
                                <?php if(@$errors->first('name')) { ?> <span class="help-block">{{@$errors->first('name')}}</span> <?php } ?>
                            </div>
                            </div>
                            <div class="form-group @if($errors->first('description')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Description<em>*</em></label>
                            <div class="col-sm-10">
                                <input type="text" name="description" class="form-control" placeholder="Description" value="{{old('description',@$data->description)}}">
                                <?php if(@$errors->first('description')) { ?> <span class="help-block">{{@$errors->first('description')}}</span> <?php } ?>
                            </div>
                            </div>

                            <!--<div class="form-group @if($errors->first('created_by')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Created By<em>*</em></label>
                            <div class="col-sm-10">
                                <input type="text" name="created_by" readonly="true" class="form-control" placeholder="Created By" value="{{old('created_by',@$data->created_by)}}">
                                <?php //if(@$errors->first('created_by')) { ?> <span class="help-block">{{@$errors->first('created_by')}}</span> <?php //} ?>
                            </div>
                            </div>
                            <div class="form-group @if($errors->first('modified_by')) {{' has-error has-feedback'}} @endif ">
                            <label for="inputError" class="col-sm-2 control-label">Modified By<em>*</em></label>
                            <div class="col-sm-10">
                                <input type="text" name="modified_by" readonly="true" class="form-control" placeholder="Modified By" value="{{old('modified_by',@$data->modified_by)}}">
                                <?php //if(@$errors->first('modified_by')) { ?> <span class="help-block">{{@$errors->first('modified_by')}}</span> <?php //} ?>
                            </div>
                            </div>-->

                            
                        </div>
                        <!-- /.box-body -->
                        <div class="box-footer">
                            <input type="submit" value="Submit" class="btn btn-info">
                            <a href="{{route('admin-locaters')}}" class="btn btn-default">Cancel</a>
                        </div>
                        <!-- /.box-footer -->
                        </form>
                        
                    </div>
                    
                </div>
                <!--/.col (right) -->
            </div>
        </div>
    </div>
        
                
            <style>
                .help-block{
                    color:red;
                }
                .error{
                    color:red;
                }
            </style>

<script type="text/javascript">
    $( document ).ready(function() {
    
      $.validator.addMethod('filesize', function(value, element, param) {
        return this.optional(element) || (element.files[0].size <= param)
      });
         
      $.validator.addMethod("alphanumspecial", function (value, element) {
        return this.optional(element) || /^(?=.*[a-z])(?=.*[0-9])(?=.*[!@#\$%\^&\*])(?=.{6,})/i.test(value);
      }, "Combination of alphabets,special characters & numeric values required.");
      $('#add-locaterform').validate({
            ignore: ".ignore",
            rules: {
                locater_id_url: {
                    required:true,
                    remote: {
                        url: '{{route("check_locater_id_url")}}'+'?id='+'{{@$data->id}}',
                        type: "get",
                        data: {
                            title: function() {
                                return $("#locater_id_url").val();
                            }
                        },
                    },
                },
                name: "required",
                description: "required",
            },
            // Specify validation error messages
            messages: {
                locater_id_url:
                {
                    required:"Please enter Locater ID.",
                    remote:"Locater ID already exist."
                },
                locater_code: "Please enter Locater Code.",
                name: "Please enter Name.",
                description: "Please enter Description.",
            },
        });
    });
  
</script>

@endsection        