@extends('adminlte::page')

@section('content')

<div class="container-fluid">
    <div class="">
        <div class="col-sm-6">
            <h2>Manage Country / State / City</h2>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Add Country / State / City</li>
            </ol>
        </div>
    </div>
</div><!-- /.container-fluid -->

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <!-- Horizontal Form -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"></h3>
                            <div class="alert alert-success alert-dismissible groputitle" style="display:none">
                        </div>
                        @if(Session::has('add_message'))
                        <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        {!! session('add_message') !!} 
                        </div>
                        @endif

                        <form class="form-horizontal" id="add-citiesform" action="{{route('admin.cities.save')}}" method="POST" enctype="multipart/form-data">

                        {{ csrf_field() }}

                        <div class="col-md-12">
                            <!-- Custom Tabs -->
                            <div class="nav-tabs-custom">
                                <ul class="nav nav-tabs">
                                <li class="active"><a href="#tab_1" data-toggle="tab" aria-expanded="true">MAIN</a></li>
                                </ul>
                                <div class="tab-content">
                                <div class="tab-pane active" id="tab_1">
                                    <div class="form-group @if($errors->first('type')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Type<em>*</em></label>
                                    <div class="col-sm-10">
                                        <?php $options = array('1'=>'Country', '2'=>'State', '3'=>'City'); ?>
                                        <select name="type" class="form-control fieldType">
                                            <option value="">Select</option>
                                            @foreach($options as $key => $option)
                                            <?php if(isset($data->type) && !empty($data->type)){ ?>
                                                <option @if($key == $data->type) {{'selected'}} @endif value="<?php echo $key; ?>"><?php echo $option; ?></option>
                                            <?php }else{ ?>
                                                <option value="<?php echo $key; ?>"><?php echo $option; ?></option>
                                            <?php } ?>
                                            @endforeach
                                        </select>
                                    </div>
                                    </div>

                                    <div class="form-group @if($errors->first('parent_id')) {{' has-error has-feedback'}} @endif parentDetail">
                                    @include('admin.cities.parent_element')
                                    </div>
                                    
                                    <!-- new code -->            
                                    <div class="form-group @if($errors->first('name')) {{' has-error has-feedback'}} @endif ">
                                        <label for="inputError" class="col-sm-2 control-label">Name</label>
                                        <div class="col-sm-10">
                                            <input type="text" name="name" class="form-control permalink" id="target_url" placeholder="Name" value="{{old('name',@$data->name)}}">    
                                        </div>
                                    </div>

                                    <div class="form-group @if($errors->first('status')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Status<em>*</em></label>
                                    <div class="col-sm-10">
                                        <?php $options = array('1'=>'Active','0'=>'In Active'); ?>
                                        <select name="status" class="form-control">
                                            <option value="">Select</option>
                                            @foreach($options as $key => $option)
                                            <?php if(isset($data->status) && !empty($data->status)){ ?>
                                                <option @if($key == $data->status) {{'selected'}} @endif value="<?php echo $key; ?>"><?php echo $option; ?></option>
                                            <?php }else{ ?>
                                                <option value="<?php echo $key; ?>"><?php echo $option; ?></option>
                                            <?php } ?>
                                            @endforeach
                                        </select>
                                    </div>
                                    </div>
                                </div>
                                
                                </div>
                                <!-- /.tab-content -->
                            </div>
                        <!-- nav-tabs-custom -->
                        </div>    


                        <!-- /.box-body -->
                        <div class="box-footer">
                            <input type="submit" value="Submit" class="btn btn-info">
                            <a href="{{route('admin.cities')}}" class="btn btn-default">Cancel</a>
                        </div>
                        <!-- /.box-footer -->
                        </form>
                        
                    </div>
                    
                </div>
                <!--/.col (right) -->
            </div>
        </div>
    </div>
        
                
            <style>
                .help-block{
                    color:red;
                }
                .error{
                    color:red;
                }
            </style>
<script type="text/javascript">
    $( document ).ready(function() {
    
      $('#add-citiesform').validate({
            ignore: ".ignore",
            rules: {
                type: "required",
                name: "required",
            },
            // Specify validation error messages
            messages: {
                type: "Please select type",
                name: "Please enter Name.",
            },
        });
    });

    $(function () {
        $('.fieldType').on('change', function (e) {
        var type = $(this).val();
        e.preventDefault();
        $.ajax({
            type: 'post',
            url: "{{route('getParentValue')}}",
            data: {"_token": "{{ csrf_token() }}",type:type},
                success: function (datanew) {
                if(datanew.status == 'success') {
                    $('.parentDetail').html(datanew.data);
                } else {
                    $('.parentDetail').html(datanew.data);
                }
            }
        });
        });
    });
    
    
</script>

@endsection        