<?php

namespace App;

use Illuminate\Notifications\Notifiable;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

class OfferType extends Model
{
    use Notifiable;
    use Sortable;

    protected $primaryKey = 'id';
    protected $table = 'offer_types';

    public $sortable = ['id',
                        'name',
                        'created_at',
                        'updated_at'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name','status','locater_id',
    ];

    

    
    
}
