<?php

namespace App;

use Illuminate\Notifications\Notifiable;
//use Illuminate\Contracts\Auth\MustVerifyEmail;
//use Illuminate\Foundation\Auth\Locater as Authenticatable;
use Illuminate\Database\Eloquent\Model;
use Kyslik\ColumnSortable\Sortable;

class Locater extends Model
{
    use Notifiable;
    use Sortable;

    protected $table = 'locaters';

    public $sortable = ['id',
                        'name',
                        'description',
                        'locater_id_url',
                        'created_at',
                        'updated_at'];

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name', 'description','status','locater_id_url'
    ];

    public function page()
    {
        return $this->hasOne('App\Page','locater_id','id')->select('*');
    }

    
}
