<?php
   
namespace App\Imports;
   
use App\LocaterFeed;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithHeadingRow;
    
class FeedsImport implements ToModel, WithHeadingRow
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        $getLocaterFeedData = LocaterFeed::where('is_deleted', '=', '0')->pluck('feeds_id','id')->toarray();
        
        if(!in_array($row['id'], $getLocaterFeedData)){
            return new LocaterFeed([
                'feeds_id'      => $row['id'],
                'title'         => $row['title'],
                'description'   => htmlentities($row['description']),
                'gtin'          => $row['gtin'],
                'brand'         => $row['brand'],
                'color'         => $row['color'],
                'size'          => trim($row['size']),
                'link'          => $row['link'],
                'image_link'    => $row['image_link'],
                'availability'  => $row['availability'],
                'product_condition'     => $row['condition'],
                'item_group_id'     => $row['item_group_id'],
                'google_product_category'    => $row['google_product_category'], 
                'product_type'     => $row['product_type'],
                'sale_price'     => $row['sale_price'],
                'price'     => $row['price'],
            ]);
        }
    }
}