<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\User;
use App\Locater;

class HomeController extends Controller
{
    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('auth');
    }

    /**
     * Show the application dashboard.
     *
     * @return \Illuminate\Contracts\Support\Renderable
     */
    public function index()
    {
        return view('home');
    }

    public function check_email(Request $request) {
        $email = strtolower(trim($request->email));
        $id = strtolower(trim($request->id));
        $user = User::where('email', '=', $email);
        if($id){
            $user->where('id', '!=', $id);
        }
        $user = $user->first();    
        if (!empty($user)) {
            return 'false';
        }else{
            return 'true';
        }
    } 

    public function check_locater_identity(Request $request) {
        $locater_identity = strtolower(trim($request->locater_identity));
        $id = strtolower(trim($request->id));
        $locater = Locater::where('locater_identity', '=', $locater_identity);
        if($id){
            $locater->where('id', '!=', $id);
        }
        $locater = $locater->first();    
        if (!empty($locater)) {
            return 'false';
        }else{
            return 'true';
        }
    } 
}
