<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Admin\AdminController;
use App\Locater;
use App\User;
use App\Page;
use App\Offer;
use App\OfferType;
use DB;
use Validator;
use Illuminate\Support\Facades\Hash;

class OfferController extends AdminController
{
    const RECORD_PER_PAGE = 10;

    public function __construct()
    {
        $this->middleware('auth');
    }


    public function offersList(Request $request) {
        $admin_id = $request->session()->get('id');

        $pageNo = trim($request->input('page', 1));

        DB::enableQueryLog();

        $keyword = strtolower(trim($request->input('keyword')));
        
        $offerList = Offer::where('offers.is_deleted', '=', '0')
            ->with(array('locaterlists' => function ($query){
                $query->select(['locater_identity', 'id']);
            }));

        $count = Offer::where('offers.is_deleted', '=', '0')
            ->with(array('locaterlists' => function ($query){
                $query->select(['locater_identity', 'id']);
            }))
            ->count();

        if($keyword)
        {
            $offerList = $offerList->where(function ($query) use ($keyword) {
                $query->orwhere('offers.offer_name', 'like', '%'.$keyword);
            });
        }
        
        $this->data['records'] = $offerList->sortable(['id'=>'desc'])->paginate(Self::RECORD_PER_PAGE);
        $queries = DB::getQueryLog();

        return view('admin.offers.offers_mng', ['data' => $this->data,'pageNo' => @$pageNo, 'record_per_page' => Self::RECORD_PER_PAGE,'request'=>$request]);
    }


    public function createOffer(){
        $locater_identity = Locater::where('locaters.is_deleted', '=', '0')->get();
        $offer_list = OfferType::where('offer_types.status', '=', '1')->get();
        return view('admin.offers.add', compact('locater_identity','offer_list'));
    }

    public function saveOffer(Request $request) {
        $user_id = auth()->user('id');
        
        if ($request->all()) {
            
            $offer_name = trim($request->offer_name);
            $locater_id = trim($request->locater_id);
            $start_date = date("Y-m-d", strtotime($request->start_date));
            $end_date = date("Y-m-d", strtotime($request->end_date));//trim($request->end_date);
            $offer_type = trim($request->offer_type);
            $offer_link = trim($request->offer_link);
            $created_by = trim($user_id->id);
            $status = trim($request->status);
            
            $validator = Validator::make($request->all(), [
                'locater_id' => 'required',
                'offer_name' => 'required',
                'start_date' => 'required',
                'offer_image' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                'end_date' => 'required',
                'offer_type' => 'required',
            ]);

            if ($validator->fails()) {
                return redirect()->route('admin.offers.add')
                            ->withErrors($validator)
                            ->withInput();
            } else {
                $offer = new Offer;
                $offer->created_by = $user_id->id;
                $offer->offer_name = $offer_name;
                $offer->locater_id = $locater_id;
                $offer->start_date = $start_date;
                $offer->end_date = $end_date;
                $offer->offer_type = $offer_type;
                $offer->offer_link = $offer_link;
                
                if(!empty($request->offer_image)){
                    $offer->offer_image = $request->file('offer_image')->store('image');
                }
                
                $offer->status = $status;
                $offer->save();

                $msg = 'Offer has been added successfully.';
                $request->session()->flash('add_message', $msg);
                return redirect()->route('admin.offers');
            }
        }
    }

    public function editOffer(Request $request, $id){
        if(!empty($id)){
            $data = Offer::find($id);
        }
        $locater_identity = Locater::where('locaters.is_deleted', '=', '0')->get();
        $offer_list = OfferType::where('offer_types.status', '=', '1')->get();
        return view('admin.offers.edit', compact('data','locater_identity','offer_list'));
    }

    public function updateOffer(Request $request, $id) {
        $user_id = auth()->user('id');
        $data = array();
        if(!empty($id)){
            $data = Offer::find($id);
        }
        if ($request->all()) {

            $offer_name = trim($request->offer_name);
            $locater_id = trim($request->locater_id);
            $start_date = date("Y-m-d", strtotime($request->start_date));
            $end_date = date("Y-m-d", strtotime($request->end_date));//trim($request->end_date);
            $offer_type = trim($request->offer_type);
            $offer_link = trim($request->offer_link);
            $created_by = trim($user_id->id);
            $status = trim($request->status);
            
            $validator = Validator::make($request->all(), [
                'locater_id' => 'required',
                'offer_name' => 'required',
                'offer_image' => 'image|mimes:jpeg,png,jpg,gif,svg|max:2048',
                'start_date' => 'required',
                'end_date' => 'required',
                'offer_type' => 'required',
            ]);
            $messages = $validator->messages();

            if ($validator->fails()) {
                return redirect()->route('admin.offers.edit',['id'=>$id])
                            ->withErrors($validator)
                            ->withInput(); 
            } else {
                $offer = Offer::find($id);
                $modified_by = trim($user_id->id);
                $offer->modified_by = $modified_by;
                $offer->offer_name = $offer_name;
                $offer->locater_id = $locater_id;
                $offer->start_date = $start_date;
                $offer->end_date = $end_date;
                $offer->offer_type = $offer_type;
                $offer->offer_link = $offer_link;
                if(!empty($request->offer_image)){
                    $offer->offer_image = $request->file('offer_image')->store('image');
                }
                
                $offer->status = $status;
                $offer->save();
                $msg = 'Offer has been updated successfully.';
                $request->session()->flash('add_message', $msg);
                return redirect()->route('admin.offers');
            }
        }
    }

    
    public function deleteOffer($id, Request $request) {
        if ($id) {
            $offer = Offer::find($id);
            $offer->is_deleted = '1';
            if($offer->save()){
                $msg = 'Offer has been deleted successfully.';
                $request->session()->flash('message', $msg);
            }
        }
        return redirect()->route('admin.offers');
    }

}