<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Admin\AdminController;
use App\City;
use DB;
use Validator;
use Illuminate\Support\Facades\Hash;

class CityController extends AdminController
{
    const RECORD_PER_PAGE = 10;

    public function __construct()
    {
        $this->middleware('auth');
    }

    public function citiesList(Request $request) {
        $admin_id = $request->session()->get('id');

        $pageNo = trim($request->input('page', 1));

        DB::enableQueryLog();

        $keyword = strtolower(trim($request->input('keyword')));
        $citiesList = City::where('cities.is_deleted', '=', '0');
        $count = City::where('cities.is_deleted', '=', '0')->count();

        if($keyword)
        {
            $citiesList = $citiesList->where(function ($query) use ($keyword) {
                $query->orwhere('cities.name', 'like', '%'.$keyword);
            });
        }
        
        $records = $citiesList->sortable(['id'=>'desc'])->paginate(Self::RECORD_PER_PAGE);
        
        $queries = DB::getQueryLog();
        
        return view('admin.cities.cities_mng', ['records' => $records,'pageNo' => @$pageNo, 'record_per_page' => Self::RECORD_PER_PAGE,'request'=>$request]);
    }


    public function getParentValue(Request $request)
    {
        if($request->type == 1){

            $parentDetail = "";

        }else if($request->type == 2){

            $parentDetail = City::where('cities.name', '!=', '')->where('cities.type', '=', '1')->pluck('name','id')->toarray();

        }else if($request->type == 3){

            $parentDetail = City::where('cities.name', '!=', '')->where('cities.type', '=', '2')->pluck('name','id')->toarray();

        }
        
        if(!empty($parentDetail)){

            $html = view('admin.cities.parent_element', compact('parentDetail'))->render();
            return response()->json([
                'status' => 'success',
                'data' => $html
            ]);
            
        }else{

            $html = view('admin.cities.parent_element', compact('parentDetail'))->render();
            return response()->json(['status' => 'error', 'data' => $html]);

        }
    }

    public function createCity(){
        return view('admin.cities.add');
    }

    public function saveCity(Request $request) {
        $user_id = auth()->user('id');
        if ($request->all()) { 
            
            $type = trim($request->type);
            $name = trim($request->name);
            if(!empty($request->parent_id)){
                $parent_id = trim($request->parent_id);
            }else{
                $parent_id = '';
            }
            
            
            $status = trim($request->status);
            
            $validator = Validator::make($request->all(), [
                'type' => 'required',
                'name' => 'required',
            ]);

            if ($validator->fails()) {
                return redirect()->route('admin.cities.add')
                            ->withErrors($validator)
                            ->withInput();
            } else {
                $city = new City;
                $city->type = $type;
                if(!empty($parent_id)){
                    $city->parent_id = $parent_id;
                }
                
                $city->name = $name;
                $city->status = $status;
                $city->save();

                $msg = 'City has been added successfully.';
                $request->session()->flash('add_message', $msg);
                return redirect()->route('admin.cities');
            }
        }
    }

    public function editCity(Request $request, $id){
        if(!empty($id)){
            $data = City::find($id);
        }
        $parentDetail = City::where('cities.name', '!=', '')->where('cities.id', '=', $data->parent_id)->pluck('name','id')->toarray();
        return view('admin.cities.edit', compact(array('data', 'parentDetail')));
    }

    public function updateCity(Request $request, $id) {
        $user_id = auth()->user('id');
        $data = array();
        if(!empty($id)){
            $data = City::find($id);
        }
        if ($request->all()) { 
            
            $type = trim($request->type);
            if(!empty($request->parent_id)){
                $parent_id = trim($request->parent_id);
            }else{
                $parent_id = '';
            }
            $name = trim($request->name);
            $status = trim($request->status);

            $validator = Validator::make($request->all(), [
                    'type' => 'required',
                    'name' => 'required',
                ]);
                $messages = $validator->messages();

            if ($validator->fails()) {
                return redirect()->route('admin.cities.edit',['id'=>$id])
                            ->withErrors($validator)
                            ->withInput(); 
            } else {

                $city = City::find($id);
                
                $city->type = $type;
                if(!empty($parent_id)){
                    $city->parent_id = $parent_id;
                }
                $city->name = $name;
                $city->status = $status;
                $city->save();
                
                $msg = 'City has been updated successfully.';
                $request->session()->flash('add_message', $msg);
                return redirect()->route('admin.cities');
            }
        }
    }

    
    public function deleteCity($id, Request $request) {
        if ($id) {
            $city = City::find($id);
            $city->is_deleted = '1';
            if($city->save()){
                $msg = 'Deleted successfully.';
                $request->session()->flash('message', $msg);
            }
        }
        return redirect()->route('admin.cities');
    }

}