@extends('adminlte::page')

@section('content')
        <div class="container-fluid">
            <div class="">
                <div class="col-sm-6">
                    <h2>Homepages</h2>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                    <li class="breadcrumb-item"><a href="#">Home</a></li>
                    <li class="breadcrumb-item active">Homepages Tables</li>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    

    <section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <!-- Horizontal Form -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"></h3>
                            <div class="alert alert-success alert-dismissible groputitle" style="display:none">
                        </div>
                        @if(Session::has('add_message'))
                        <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        {!! session('add_message') !!} 
                        </div>
                        @endif
                        <form id="homepages-mng" method="get" action="{{route('admin.homepages')}}">
                            {{ csrf_field() }}
                            <div class="row clearfix">
                                <div class="col-sm-2">
                                    <div class="form-group">
                                        <div class="form-line">
                                            <input class="form-control" name="keyword" value="{{old('keyword',$request->keyword)}}" placeholder="Keyword" type="text">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-sm-4">
                                    <button type="submit" class="btn btn-primary btn-info">Search<div></div></button>
                                    <a href="{{route('admin.homepages')}}" class="btn btn-primary btn-success">Reset</a>
                                </div>
                                <div class="col-sm-2 pull-right">
                                    <a href="{{route('admin.homepages.add')}}" class="btn btn-block btn-warning">Add Homepages</a>
                                </div>
                            </div>
                        </form>

                        @if(Session::has('message'))
                        <div class="alert alert-success alert-dismissible">
                            <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                            {!! session('message') !!} 
                        </div>
                        @endif
                    </div>

                    

                    <!-- /.box-header -->
                    <form id="homepages-add" method="get" action="">

                    <div class="card">
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table class="table table-bordered">
                            <tr>
                                <th style="width: 10px">#</th>
                                <th>@sortablelink('other_setting')</th>
                                <th>@sortablelink('created_at')</th>
                                <th style="width: 40px">Action</th>
                            </tr>
                            @if(count($data['records'])>0)
                            <?php $k = ($pageNo == 1) ? $pageNo : (($pageNo - 1) * $record_per_page) + 1; ?>
                            @foreach($data['records'] as $row)
                            <tr>
                                <td>{{$row->id}}</td>
                                <td>{{$row->other_setting}}</td>
                                <td>{{date("F j, Y", strtotime($row->created_at))}}</td>
                                <td style="width:10%">
                                    <a href="{{route('admin.homepages.edit',['id'=>$row->id])}}" class="btn btn-info btn-xs action-btn" title ="Edit"><span class="glyphicon glyphicon-pencil" aria-hidden="true"></span></a>
                                    <a href="{{route('admin.homepages.delete',['id'=>$row->id])}}" class="btn btn-danger btn-xs action-btn" onclick="return confirm('Are you sure you want to delete ?');" title ="Delete"><span class="glyphicon glyphicon-trash" aria-hidden="true"></span></a>
                                </td>
                            </tr>
                            <?php $k++; ?>     
                            @endforeach
                            @else
                            <tr class="bg-info">
                                <td colspan="4">Record(s) not found.</td>
                            </tr>
                            @endif
                            </table>
                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer clearfix">
                            <ul class="pagination pagination-sm m-0 float-right">
                                {!! $data['records']->links() !!}
                            </ul>
                        </div>
                        <!-- /.card -->
                    </div>    
                    </form>
                    <!-- /.box-body -->
                    
                </div>
                <!-- /.box -->
            </div>
        </div>
</div>

@endsection
