@extends('adminlte::page')

@section('content')

<div class="container-fluid">
    <div class="">
        <div class="col-sm-6">
            <h2>Homepage Settings</h2>
        </div>
        <div class="col-sm-6">
            <ol class="breadcrumb float-sm-right">
                <li class="breadcrumb-item"><a href="#">Home</a></li>
                <li class="breadcrumb-item active">Homepage Settings</li>
            </ol>
        </div>
    </div>
</div><!-- /.container-fluid -->

<section class="content">
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <!-- Horizontal Form -->
                <div class="box box-info">
                    <div class="box-header with-border">
                        <h3 class="box-title"></h3>
                            <div class="alert alert-success alert-dismissible groputitle" style="display:none">
                        </div>
                        @if(Session::has('add_message'))
                        <div class="alert alert-success alert-dismissible">
                        <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
                        {!! session('add_message') !!} 
                        </div>
                        @endif

                        <form class="form-horizontal" id="add-pageform" action="{{route('admin.homepages.update',['id'=>@$data->id])}}" method="POST" enctype="multipart/form-data">

                        {{ csrf_field() }}

                        <div class="col-md-12">
                            <!-- Custom Tabs -->
                            <div class="nav-tabs-custom">
                                <ul class="nav nav-tabs">
                                <li class="active"><a href="#other" data-toggle="tab" aria-expanded="true">Show Feed</a></li>
                                <li><a href="#tab_1" data-toggle="tab" aria-expanded="false">MAIN</a></li>
                                <li class=""><a href="#tab_2" data-toggle="tab" aria-expanded="false">SEO</a></li>
                                </ul>
                                <div class="tab-content">
                                <div class="tab-pane active" id="other">
                                    <div class="form-group">
                                        <div class="form-line">
                                        <?php 
                                        if($data->show_feed == 1){
                                            $checked = "checked";
                                        }else{
                                            $checked = "";
                                        } ?>
                                        <input <?php echo $checked; ?> type="checkbox" style="width: 25px;height: 25px;" name="show"> 
                                        <span><b>Checked check box if you want to show feeds in detail page.</b></span>
                                        <br>
                                        </div>
                                    </div>
                                </div>
                                <div class="tab-pane" id="tab_1">
                                    
                                    <div class="form-group @if($errors->first('header_image_normal')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">header_image_normal</label>
                                    <div class="col-sm-10">
                                        <input type="file" name="header_image_normal" class="form-control">
                                    </div>
                                    </div>

                                    <div class="form-group @if($errors->first('header_image_mobile')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">header_image_mobile</label>
                                    <div class="col-sm-10">
                                        <input type="file" name="header_image_mobile" class="form-control">
                                    </div>
                                    </div>

                                    <div class="form-group @if($errors->first('footer_image_normal')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">footer_image_normal</label>
                                    <div class="col-sm-10">
                                        <input type="file" name="footer_image_normal" class="form-control">
                                    </div>
                                    </div>

                                    <div class="form-group @if($errors->first('footer_image_mobile')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">footer_image_mobile</label>
                                    <div class="col-sm-10">
                                        <input type="file" name="footer_image_mobile" class="form-control">
                                    </div>
                                    </div>
                                </div>
                                <!-- /.tab-pane -->
                                <div class="tab-pane" id="tab_2">
                                    <div class="form-group @if($errors->first('meta_title')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Meta Title</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="meta_title" class="form-control" placeholder="Meta Title" value="{{old('meta_title',@$data->meta_title)}}">
                                    </div>
                                    </div>
                                    <div class="form-group @if($errors->first('meta_keyword')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Meta Keyword</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="meta_keyword" class="form-control" placeholder="Meta Keyword" value="{{old('meta_keyword',@$data->meta_keyword)}}">
                                    </div>
                                    </div>
                                    <div class="form-group @if($errors->first('meta_description')) {{' has-error has-feedback'}} @endif ">
                                    <label for="inputError" class="col-sm-2 control-label">Meta Description</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="meta_description" class="form-control" placeholder="Meta Description" value="{{old('meta_description',@$data->meta_description)}}">
                                    </div>
                                    </div>
                                </div>
                                </div>
                                <!-- /.tab-content -->
                            </div>
                        <!-- nav-tabs-custom -->
                        </div>    


                        <!-- /.box-body -->
                        <div class="box-footer">
                            <input type="submit" value="Submit" class="btn btn-info">
                            <a href="{{route('admin.homepages')}}" class="btn btn-default">Cancel</a>
                        </div>
                        <!-- /.box-footer -->
                        </form>
                        
                    </div>
                    
                </div>
                <!--/.col (right) -->
            </div>
        </div>
    </div>
        
                
            <style>
                .help-block{
                    color:red;
                }
                .error{
                    color:red;
                }
            </style>
<script src="{{ asset('/vendor/adminlte/dist/js/slug.js') }}"></script>
<script type="text/javascript">
    $( document ).ready(function() {
    
      $('#add-pageform').validate({
            ignore: ".ignore",
            rules: {
                locater_id: "required",
                title: "required",
                //contents: "required",
                status: "required",
                //banner_image: "required",
                banner_content: "required",
            },
            // Specify validation error messages
            messages: {
                locater_id: "Please select locator",
                title: "Please enter Name.",
                //contents: "Please enter Description.",
                status: "Please select Status.",
                //banner_image: "Please enter Banner Image url.",
                banner_content: "Please enter Meta Banner Content.",
            },
        });
    });
    
    $(function() {
        $("#title").slug({ slug:'permalink',hide: false });
        $('#edit_target_url').bind('click',function(){if ($('#target_url').attr('readonly') !== undefined) {
        $('#target_url').removeAttr( "readonly");
        } else {$('#target_url').attr('readonly','readonly')}
        });
        $('#target_url').bind('blur',function(){$(this).attr('readonly','readonly')});
        
    });
</script>
<script src="{{ asset('/vendor/unisharp/laravel-ckeditor/ckeditor.js') }}"></script>
<script>
    CKEDITOR.replace( 'contents' );
</script>

@endsection        