<?php

namespace App\Http\Controllers\Admin;

use Illuminate\Http\Request;
use App\Http\Controllers\Admin\AdminController;
use App\Homepage;
use DB;
use Validator;
use Illuminate\Support\Facades\Hash;

class HomepageController extends AdminController
{
    public function __construct()
    {
        $this->middleware('auth');
        $this->record_per_page=10;
    }

    public function homepagesList(Request $request) {
        $admin_id = $request->session()->get('id');

        $pageNo = trim($request->input('page', 1));
        
        DB::enableQueryLog();
        
        $homepageList = Homepage::where('homepages.is_deleted', '=', '0');
        $count = Homepage::where('homepages.is_deleted', '=', '0');
        $this->data['records'] = $homepageList->sortable(['id'=>'desc'])->paginate($this->record_per_page);
        $queries = DB::getQueryLog();

        return view('admin.homepages.homepages_mng', ['data' => $this->data,'pageNo' => @$pageNo, 'record_per_page' => $this->record_per_page,'request'=>$request]);
    }

    public function createHomepage(){
        return view('admin.homepages.add');
    }

    public function saveHomepage(Request $request) {
        $user_id = auth()->user('id');
        if ($request->all()) { 
            $show = trim($request->show);
            $feed_csv_url = trim($request->feed_csv_url);
            $header = trim($request->header);
            $footer = trim($request->footer);
            $created_by = trim($user_id->id);
            $meta_title = trim($request->meta_title);
            $meta_keyword = trim($request->meta_keyword);
            $meta_description = trim($request->meta_description);
            
            $homepage = new Homepage;
            $homepage->created_by = $user_id->id;
            
            if(!empty($request->header)){
                $homepage->header = $request->header;
            }
            if(!empty($request->footer)){
                $homepage->footer = $request->footer;
            }
            if($show == 'on'){
                $homepage->show_feed = '1';
            }else{
                $homepage->show_feed = '0';
            }
            $homepage->feed_csv_url = $feed_csv_url;
            $homepage->meta_title = $meta_title;
            $homepage->meta_keyword = $meta_keyword;
            $homepage->meta_description = $meta_description;
            $homepage->save();

            $msg = 'Homepage has been added successfully.';
            $request->session()->flash('add_message', $msg);
            return redirect()->route('admin.homepages');
        }
    }

    public function editHomepage(Request $request, $id){
        if(!empty($id)){
            $data = Homepage::find($id);
        }
        return view('admin.homepages.edit',compact('data'));
    }


    public function updateHomepage(Request $request, $id) {
        $user_id = auth()->user('id');

        $data = array();
        
        if(!empty($id)){
            $data = Homepage::find($id);
        }

        if ($request->all()) { //dd($request->all());
            $show = trim($request->show);
            $feed_csv_url = trim($request->feed_csv_url);
            $header = trim($request->header);
            $footer = trim($request->footer);
            $created_by = trim($user_id->id);
            $meta_title = trim($request->meta_title);
            $meta_keyword = trim($request->meta_keyword);
            $meta_description = trim($request->meta_description);
            
            $homepage = Homepage::find($id);//->with('userlists');
            $modified_by = trim($user_id->id);
            $homepage->modified_by = $modified_by;
            if(!empty($request->header)){
                $homepage->header = $request->header;
            }
            if(!empty($request->footer)){
                $homepage->footer = $request->footer;
            }
            
            if($show == 'on'){
                $homepage->show_feed = '1';
            }else{
                $homepage->show_feed = '0';
            }
            $homepage->feed_csv_url = $feed_csv_url;
            $homepage->meta_title = $meta_title;
            $homepage->meta_keyword = $meta_keyword;
            $homepage->meta_description = $meta_description;
            $homepage->save();

            $msg = 'Homepage has been updated successfully.';
            $request->session()->flash('add_message', $msg);
            return redirect()->route('admin.homepages');
        }
    }

    public function deleteHomepage($id, Request $request) {
        if ($id) {
            $homepage = Homepage::find($id);
            $homepage->is_deleted = '1';

            if($homepage->save()){
                $msg = 'Homepage has been deleted successfully.';
                $request->session()->flash('message', $msg);
            }
            
        }
        return redirect()->route('admin.homepages');
    }

    

}